/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.utils.DatabaseUtils;

public class PortfolioItem
extends GenericBean {
    private int id = -1;
    private String name = null;
    private String description = null;
    private int positionId = -1;
    private int imageId = -1;
    private String caption = null;
    private int categoryId = -1;
    private boolean enabled = false;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    FileItem image = null;
    boolean buildResources = false;
    boolean positionIdHasChanged = false;

    public PortfolioItem() {
    }

    public PortfolioItem(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public PortfolioItem(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Portfolio Item ID");
        }
        StringBuffer sb = new StringBuffer(" SELECT pi.*  FROM portfolio_item pi  WHERE pi.item_id = ? ");
        PreparedStatement pst = db.prepareStatement(sb.toString());
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        if (this.buildResources) {
            this.buildResources(db);
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("item_id"));
        this.name = rs.getString("item_name");
        this.description = rs.getString("item_description");
        this.positionId = DatabaseUtils.getInt(rs, "item_position_id");
        this.imageId = DatabaseUtils.getInt(rs, "image_id");
        this.caption = rs.getString("caption");
        this.categoryId = DatabaseUtils.getInt(rs, "portfolio_category_id");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "portfolio_item_item_id_seq");
            sql.append("INSERT INTO portfolio_item (item_name, item_description, item_position_id,image_id, caption, portfolio_category_id, enabled, ");
            if (this.id > -1) {
                sql.append("item_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            sql.append("enteredby, ");
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("modifiedby )");
            sql.append(" VALUES (?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?, ");
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("? )");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setString(++i, this.getName());
            pst.setString(++i, this.getDescription());
            DatabaseUtils.setInt(pst, ++i, this.getPositionId());
            DatabaseUtils.setInt(pst, ++i, this.getImageId());
            pst.setString(++i, this.getCaption());
            DatabaseUtils.setInt(pst, ++i, this.getCategoryId());
            pst.setBoolean(++i, this.getEnabled());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.getEntered());
            }
            pst.setInt(++i, this.getModifiedBy());
            if (this.modified != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "portfolio_item_item_id_seq", this.id);
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        boolean commit = false;
        if (this.getId() == -1) {
            return -1;
        }
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE portfolio_item SET item_name = ?, item_description = ?, item_position_id = ?, image_id = ?, caption = ?, portfolio_category_id = ?, enabled = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "modifiedby = ? " + "WHERE item_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            pst.setString(++i, this.getName());
            pst.setString(++i, this.getDescription());
            DatabaseUtils.setInt(pst, ++i, this.getPositionId());
            DatabaseUtils.setInt(pst, ++i, this.getImageId());
            pst.setString(++i, this.getCaption());
            DatabaseUtils.setInt(pst, ++i, this.getCategoryId());
            pst.setBoolean(++i, this.getEnabled());
            pst.setInt(++i, this.getModifiedBy());
            pst.setInt(++i, this.getId());
            resultCount = pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Portfolio Item ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        Object pst = null;
        Object rs = null;
        boolean i = false;
        Dependency docDependency = new Dependency();
        docDependency.setName("documents");
        docDependency.setCount(FileItemList.retrieveRecordCount((Connection)db, (int)223061228, (int)this.getId()));
        docDependency.setCanDelete(true);
        dependencyList.add(docDependency);
        return dependencyList;
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Portfolio Item ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            Object rs = null;
            int nextPositionId = this.getNextPositionId(db);
            if (nextPositionId > -1) {
                PortfolioItem nextPosition = new PortfolioItem(db, nextPositionId);
                nextPosition.setPositionId(this.getPositionId());
                nextPosition.update(db);
            }
            pst = db.prepareStatement("DELETE FROM portfolio_item WHERE item_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            FileItemList fileList = new FileItemList();
            fileList.setLinkModuleId(223061228);
            fileList.setLinkItemId(this.getId());
            fileList.buildList(db);
            fileList.delete(db, this.getFileLibraryPath(baseFilePath, "portfolioitem"));
            fileList = null;
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildResources(Connection db) throws SQLException {
        if (this.imageId > -1) {
            this.image = new FileItem(db, this.imageId, this.getId(), 223061228);
        }
    }

    public int getNextPositionId(Connection db) throws SQLException {
        int result = -1;
        PreparedStatement pst = db.prepareStatement("SELECT item_id FROM portfolio_item WHERE item_position_id = ? ");
        pst.setInt(1, this.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = DatabaseUtils.getInt(rs, "item_id");
        }
        rs.close();
        pst.close();
        return result;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("entered");
        thisList.add("modified");
        return thisList;
    }

    public String toString() {
        return this.getName();
    }

    public void updateCategory(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Portfolio Item ID not specified");
        }
        boolean commit = true;
        try {
            int nextPositionId;
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            if ((nextPositionId = this.getNextPositionId(db)) > -1) {
                PortfolioItem nextPosition = new PortfolioItem(db, nextPositionId);
                nextPosition.setPositionId(this.getPositionId());
                nextPosition.update(db);
            }
            PreparedStatement pst = db.prepareStatement("UPDATE portfolio_item set portfolio_category_id = ? where item_id = ? ");
            DatabaseUtils.setInt(pst, 1, this.getCategoryId());
            pst.setInt(2, this.getId());
            pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public int getPositionId() {
        return this.positionId;
    }

    public void setPositionId(int tmp) {
        if (tmp != this.positionId) {
            this.setPositionIdHasChanged(true);
        }
        this.positionId = tmp;
    }

    public void setPositionId(String tmp) {
        if (this.positionId != Integer.parseInt(tmp)) {
            this.setPositionIdHasChanged(true);
        }
        this.positionId = Integer.parseInt(tmp);
    }

    public int getImageId() {
        return this.imageId;
    }

    public void setImageId(int tmp) {
        this.imageId = tmp;
    }

    public void setImageId(String tmp) {
        this.imageId = Integer.parseInt(tmp);
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String tmp) {
        this.caption = tmp;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public FileItem getImage() {
        return this.image;
    }

    public void setImage(FileItem tmp) {
        this.image = tmp;
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getPositionIdHasChanged() {
        return this.positionIdHasChanged;
    }

    public void setPositionIdHasChanged(boolean tmp) {
        this.positionIdHasChanged = tmp;
    }

    public void setPositionIdHasChanged(String tmp) {
        this.positionIdHasChanged = DatabaseUtils.parseBoolean(tmp);
    }
}

