/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.website.base.PortfolioItem;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class PortfolioItemList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int categoryId = -1;
    private int enabledOnly = -1;

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM portfolio_item pi  WHERE pi.item_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("pi.entered", null);
            boolean flag = true;
            if (DatabaseUtils.getType(db) == 2 && this.pagedListInfo.getColumnToSortBy().equals("pi.item_name")) {
                sqlOrder.append("ORDER BY " + DatabaseUtils.convertToVarChar(db, "pi.item_name") + (this.pagedListInfo.getSortOrder() != null ? " DESC " : " "));
                flag = false;
            }
            if (flag) {
                this.pagedListInfo.appendSqlTail(db, sqlOrder);
            }
        } else {
            sqlOrder.append("ORDER BY pi.item_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" pi.*  FROM portfolio_item pi  WHERE pi.item_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (System.getProperty("DEBUG") != null) {
            // empty if block
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            PortfolioItem thisItem = new PortfolioItem(rs);
            this.add(thisItem);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.id > -1) {
            sqlFilter.append("AND pi.item_id = ? ");
        }
        if (this.categoryId > -1) {
            sqlFilter.append(" AND pi.portfolio_category_id = ? ");
        } else {
            sqlFilter.append("AND pi.portfolio_category_id IS NULL ");
        }
        if (this.enabledOnly != -1) {
            sqlFilter.append(" AND pi.enabled = ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.enabledOnly != -1) {
            pst.setBoolean(++i, this.enabledOnly == 1);
        }
        return i;
    }

    public PortfolioItemList reorder() {
        HashMap positionMap = this.getItemIdsAsHashMap();
        HashMap items = this.getItemsByPositionAsHashMap();
        PortfolioItemList reorderedList = new PortfolioItemList();
        reorderedList.setEnabledOnly(this.getEnabledOnly());
        reorderedList.setCategoryId(this.getCategoryId());
        String tempItemId = "-1";
        for (int i = 0; i < this.size(); ++i) {
            PortfolioItem thisItem = (PortfolioItem)((Object)items.get(tempItemId));
            if (thisItem == null) continue;
            tempItemId = (String)positionMap.get(tempItemId);
            if (this.enabledOnly != -1) {
                if (thisItem.getEnabled() != (this.enabledOnly == 1)) continue;
                reorderedList.add(thisItem);
                continue;
            }
            reorderedList.add(thisItem);
        }
        return reorderedList;
    }

    public PortfolioItemList reset(ActionContext context, Connection db) throws SQLException {
        PortfolioItemList oldList = this.reorder();
        HashMap oldOrder = oldList.getItemPositionsAsHashMap();
        HashMap<String, Object> newOrder = new HashMap<String, Object>();
        for (PortfolioItem item : oldList) {
            String position = context.getRequest().getParameter("item" + item.getId());
            if (position.indexOf(".") > -1) {
                try {
                    position = new Integer((int)Math.ceil(Double.parseDouble(context.getRequest().getParameter("item" + item.getId())))).toString();
                }
                catch (NumberFormatException e) {
                    position = (String)oldOrder.get(String.valueOf(item.getId()));
                }
            }
            if (position == null || "".equals(position.trim())) {
                position = (String)oldOrder.get(String.valueOf(item.getId()));
            }
            if (newOrder.get(position) != null) {
                Object content = newOrder.get(position);
                if (content instanceof ArrayList) {
                    ArrayList tempList = (ArrayList)content;
                    int oldPosition = Integer.parseInt((String)oldOrder.get(String.valueOf(item.getId())));
                    if (oldPosition > Integer.parseInt(position)) {
                        tempList.add(0, String.valueOf(item.getId()));
                    } else {
                        tempList.add(String.valueOf(item.getId()));
                    }
                    newOrder.put(position, tempList);
                    continue;
                }
                if (!(content instanceof String)) continue;
                String oldCatId = (String)content;
                ArrayList<String> tempList = new ArrayList<String>();
                tempList.add(oldCatId);
                int oldPosition = Integer.parseInt((String)oldOrder.get(String.valueOf(item.getId())));
                if (oldPosition > Integer.parseInt(position)) {
                    tempList.add(0, String.valueOf(item.getId()));
                } else {
                    tempList.add(String.valueOf(item.getId()));
                }
                newOrder.put(position, tempList);
                continue;
            }
            newOrder.put(position, String.valueOf(item.getId()));
        }
        HashMap itemsMap = oldList.getItemsAsHashMap();
        PortfolioItemList currentList = new PortfolioItemList();
        int itemCounter = 0;
        int currentSize = this.size();
        int i = 1;
        while (true) {
            if (newOrder.get(String.valueOf(i)) != null) {
                Object content = newOrder.get(String.valueOf(i));
                if (content instanceof String) {
                    PortfolioItem tempItem = (PortfolioItem)((Object)itemsMap.get((String)content));
                    currentList.add(tempItem);
                    ++itemCounter;
                } else if (content instanceof ArrayList) {
                    ArrayList tempList = (ArrayList)content;
                    for (int j = 0; j < tempList.size(); ++j) {
                        PortfolioItem tempItem = (PortfolioItem)((Object)itemsMap.get((String)tempList.get(j)));
                        currentList.add(tempItem);
                        ++itemCounter;
                    }
                }
            }
            if (itemCounter >= currentSize) break;
            ++i;
        }
        currentList.setEnabledOnly(this.getEnabledOnly());
        currentList.setCategoryId(this.getCategoryId());
        Iterator iter = currentList.iterator();
        if (iter.hasNext()) {
            PortfolioItem firstItem = (PortfolioItem)((Object)iter.next());
            firstItem.setPositionId(-1);
            if (firstItem.getPositionIdHasChanged()) {
                firstItem.update(db);
            }
            Iterator iter2 = currentList.iterator();
            while (iter.hasNext()) {
                PortfolioItem parentItem = (PortfolioItem)((Object)iter2.next());
                PortfolioItem item = (PortfolioItem)((Object)iter.next());
                item.setPositionId(parentItem.getId());
                if (!item.getPositionIdHasChanged()) continue;
                item.update(db);
            }
        }
        return currentList;
    }

    public HashMap getItemIdsAsHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (PortfolioItem item : this) {
            map.put(String.valueOf(item.getPositionId()), String.valueOf(item.getId()));
        }
        return map;
    }

    public HashMap getItemsByPositionAsHashMap() {
        HashMap<String, PortfolioItem> map = new HashMap<String, PortfolioItem>();
        for (PortfolioItem item : this) {
            map.put(String.valueOf(item.getPositionId()), item);
        }
        return map;
    }

    public HashMap getItemsAsHashMap() {
        HashMap<String, PortfolioItem> map = new HashMap<String, PortfolioItem>();
        for (PortfolioItem item : this) {
            map.put(String.valueOf(item.getId()), item);
        }
        return map;
    }

    public HashMap getItemPositionsAsHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iter = this.iterator();
        int i = 1;
        while (iter.hasNext()) {
            PortfolioItem item = (PortfolioItem)((Object)iter.next());
            map.put(String.valueOf(item.getId()), String.valueOf(i));
            ++i;
        }
        return map;
    }

    public PortfolioItem getItemById(int id) {
        PortfolioItem result = null;
        for (PortfolioItem item : this) {
            if (item.getId() != id) continue;
            result = item;
            break;
        }
        return result;
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        for (PortfolioItem item : this) {
            item.delete(db, baseFilePath);
        }
        return true;
    }

    public int getIdByIndex(int index) {
        PortfolioItem item;
        int result = -1;
        if (this.size() > 0 && index < this.size() && (item = (PortfolioItem)((Object)this.get(index))) != null) {
            result = item.getId();
        }
        return result;
    }

    public int getLastItemId() {
        return this.getIdByIndex(this.size() - 1);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public int getEnabledOnly() {
        return this.enabledOnly;
    }

    public void setEnabledOnly(int tmp) {
        this.enabledOnly = tmp;
    }

    public void setEnabledOnly(String tmp) {
        this.enabledOnly = Integer.parseInt(tmp);
    }
}

