/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.Icelet;
import org.aspcfs.modules.website.base.IceletList;
import org.aspcfs.modules.website.base.IceletProperty;
import org.aspcfs.modules.website.base.IceletPropertyMap;
import org.aspcfs.modules.website.base.PageRow;
import org.aspcfs.modules.website.base.PageRowList;
import org.aspcfs.modules.website.base.RowColumnList;
import org.aspcfs.modules.website.icelet.HtmlContentPortlet;
import org.aspcfs.utils.DatabaseUtils;

public class RowColumn
extends GenericBean {
    public static final int INITIAL_POSITION = 0;
    private int id = -1;
    private int position = -1;
    private int width = -1;
    private int pageRowId = -1;
    private int iceletId = -1;
    private boolean enabled = true;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private String iceletConfiguratorClass = null;
    private Icelet icelet = null;
    private boolean buildIcelet = false;
    private IceletPropertyMap iceletPropertyMap = null;
    private boolean buildIceletPropertyMap = false;
    private IceletPropertyMap defaultPropertyMap = null;
    private boolean buildSubRows = false;
    private PageRowList subRows = null;
    private boolean override = false;
    private int previousRowColumnId = -1;
    private int nextRowColumnId = -1;
    private int level = -1;
    private PageRow parentRow = null;
    private boolean swappingRowColumn = false;
    private boolean deletingFromList = false;

    public RowColumn() {
    }

    public RowColumn(Connection db, int tmpRowColumnId) throws SQLException {
        this.queryRecord(db, tmpRowColumnId);
    }

    public RowColumn(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setPosition(int tmp) {
        this.position = tmp;
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public void setWidth(int tmp) {
        this.width = tmp;
    }

    public void setWidth(String tmp) {
        this.width = Integer.parseInt(tmp);
    }

    public void setPageRowId(int tmp) {
        this.pageRowId = tmp;
    }

    public void setPageRowId(String tmp) {
        this.pageRowId = Integer.parseInt(tmp);
    }

    public void setIceletId(int tmp) {
        this.iceletId = tmp;
    }

    public void setIceletId(String tmp) {
        this.iceletId = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIceletConfiguratorClass(String tmp) {
        this.iceletConfiguratorClass = tmp;
    }

    public void setIcelet(Icelet tmp) {
        this.icelet = tmp;
    }

    public void setBuildIcelet(boolean tmp) {
        this.buildIcelet = tmp;
    }

    public void setBuildIcelet(String tmp) {
        this.buildIcelet = DatabaseUtils.parseBoolean(tmp);
    }

    public void setIceletPropertyMap(IceletPropertyMap tmp) {
        this.iceletPropertyMap = tmp;
    }

    public void setBuildIceletPropertyMap(boolean tmp) {
        this.buildIceletPropertyMap = tmp;
    }

    public void setBuildIceletPropertyMap(String tmp) {
        this.buildIceletPropertyMap = DatabaseUtils.parseBoolean(tmp);
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getPosition() {
        return this.position;
    }

    public int getWidth() {
        return this.width;
    }

    public int getPageRowId() {
        return this.pageRowId;
    }

    public int getIceletId() {
        return this.iceletId;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getIceletConfiguratorClass() {
        return this.iceletConfiguratorClass;
    }

    public Icelet getIcelet() {
        return this.icelet;
    }

    public boolean getBuildIcelet() {
        return this.buildIcelet;
    }

    public IceletPropertyMap getIceletPropertyMap() {
        return this.iceletPropertyMap;
    }

    public boolean getBuildIceletPropertyMap() {
        return this.buildIceletPropertyMap;
    }

    public boolean getOverride() {
        return this.override;
    }

    public int getPreviousRowColumnId() {
        return this.previousRowColumnId;
    }

    public void setPreviousRowColumnId(int tmp) {
        this.previousRowColumnId = tmp;
    }

    public void setPreviousRowColumnId(String tmp) {
        this.previousRowColumnId = Integer.parseInt(tmp);
    }

    public int getNextRowColumnId() {
        return this.nextRowColumnId;
    }

    public void setNextRowColumnId(int tmp) {
        this.nextRowColumnId = tmp;
    }

    public void setNextRowColumnId(String tmp) {
        this.nextRowColumnId = Integer.parseInt(tmp);
    }

    public IceletPropertyMap getDefaultPropertyMap() {
        return this.defaultPropertyMap;
    }

    public void setDefaultPropertyMap(IceletPropertyMap tmp) {
        this.defaultPropertyMap = tmp;
    }

    public boolean getBuildSubRows() {
        return this.buildSubRows;
    }

    public void setBuildSubRows(boolean tmp) {
        this.buildSubRows = tmp;
    }

    public void setBuildSubRows(String tmp) {
        this.buildSubRows = DatabaseUtils.parseBoolean(tmp);
    }

    public PageRowList getSubRows() {
        return this.subRows;
    }

    public void setSubRows(PageRowList tmp) {
        this.subRows = tmp;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public PageRow getParentRow() {
        return this.parentRow;
    }

    public void setParentRow(PageRow tmp) {
        this.parentRow = tmp;
    }

    public boolean getDeletingFromList() {
        return this.deletingFromList;
    }

    public void setDeletingFromList(boolean tmp) {
        this.deletingFromList = tmp;
    }

    public void setDeletingFromList(String tmp) {
        this.deletingFromList = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getSwappingRowColumn() {
        return this.swappingRowColumn;
    }

    public void setSwappingRowColumn(boolean tmp) {
        this.swappingRowColumn = tmp;
    }

    public void setSwappingRowColumn(String tmp) {
        this.swappingRowColumn = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean queryRecord(Connection db, int tmpRowColumnId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT *  FROM web_row_column  WHERE row_column_id = ? ");
        pst.setInt(1, tmpRowColumnId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.buildIcelet) {
            this.buildIcelet(db);
        }
        if (this.buildIceletPropertyMap) {
            this.buildIceletPropertyMap(db);
        }
        if (this.buildSubRows) {
            this.buildSubRows(db);
        }
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "web_row_column_row_column_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_row_column (" + (this.id > -1 ? "row_column_id, " : "") + "column_position , " + "page_row_id , " + "icelet_id , " + "width , " + "enabled , " + "enteredby , " + "modifiedby ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.position);
        DatabaseUtils.setInt(pst, ++i, this.pageRowId);
        DatabaseUtils.setInt(pst, ++i, this.iceletId);
        DatabaseUtils.setInt(pst, ++i, this.width);
        pst.setBoolean(++i, this.enabled);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.modifiedBy);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "web_row_column_row_column_id_seq", this.id);
        pst.close();
        if (!this.getSwappingRowColumn()) {
            this.updateRelatedRowColumns(db, true);
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE web_row_column SET column_position = ? , width = ? , page_row_id = ? , icelet_id = ? , enabled = ? ");
        if (!this.override) {
            sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
        }
        sql.append("WHERE row_column_id = ? ");
        if (!this.override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.position);
        DatabaseUtils.setInt(pst, ++i, this.width);
        DatabaseUtils.setInt(pst, ++i, this.pageRowId);
        DatabaseUtils.setInt(pst, ++i, this.iceletId);
        pst.setBoolean(++i, this.enabled);
        if (!this.override) {
            pst.setInt(++i, this.modifiedBy);
        }
        pst.setInt(++i, this.id);
        if (!this.override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            PageRow pageRow;
            if (commit) {
                db.setAutoCommit(false);
            }
            this.iceletPropertyMap = new IceletPropertyMap();
            this.iceletPropertyMap.setIceletRowColumnId(this.getId());
            this.iceletPropertyMap.buildList(db);
            this.iceletPropertyMap.delete(db);
            this.iceletPropertyMap = null;
            this.buildSubRows(db);
            if (this.subRows != null && this.subRows.size() > 0) {
                this.subRows.delete(db);
            }
            if (!this.getSwappingRowColumn()) {
                this.updateRelatedRowColumns(db, false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM web_row_column WHERE row_column_id =  ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (!this.getDeletingFromList() && (pageRow = new PageRow(db, this.getPageRowId())).getRowColumnId() != -1) {
                pageRow.fixBlankSubRow(db);
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public static boolean isRowColumnViewable(Connection db, int tmpRowColumnId) throws SQLException {
        boolean canBeViewed = false;
        int numberOfRecords = 0;
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" select count(*) AS numberOfRecords from web_site s, web_tab t, web_page_group pg, web_page p,  web_page_version pv, web_page_row pr, web_row_column rc  where rc.row_column_id = ?  and rc.enabled = ?  and pr.page_row_id = rc.page_row_id  and pr.enabled = ?  and pr.page_version_id = pv.page_version_id  and pv.page_id = p.active_page_version_id  and p.enabled = ?  and pg.page_group_id = p.page_group_id  and t.tab_id = pg.tab_id  and t.enabled = ?  and s.site_id = t.site_id  and s.enabled = ? ");
        int i = 0;
        pst.setInt(++i, tmpRowColumnId);
        pst.setBoolean(++i, true);
        pst.setBoolean(++i, true);
        pst.setBoolean(++i, true);
        pst.setBoolean(++i, true);
        pst.setBoolean(++i, true);
        rs = pst.executeQuery();
        if (rs.next()) {
            numberOfRecords = rs.getInt("numberOfRecords");
        }
        rs.close();
        pst.close();
        if (numberOfRecords != 0) {
            canBeViewed = true;
        }
        return canBeViewed;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("row_column_id");
        this.position = rs.getInt("column_position");
        this.width = DatabaseUtils.getInt(rs, "width");
        this.pageRowId = DatabaseUtils.getInt(rs, "page_row_id");
        this.iceletId = DatabaseUtils.getInt(rs, "icelet_id");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }

    public void buildIcelet(Connection db) throws SQLException {
        if (this.iceletId != -1) {
            this.icelet = new Icelet(db, this.iceletId);
        }
    }

    public void buildIceletPropertyMap(Connection db) throws SQLException {
        this.iceletPropertyMap = new IceletPropertyMap();
        this.iceletPropertyMap.setIceletRowColumnId(this.id);
        this.iceletPropertyMap.setBuildNames(true);
        this.iceletPropertyMap.setDefaultProperties(this.getDefaultPropertyMap());
        this.iceletPropertyMap.buildList(db);
    }

    public void buildSubRows(Connection db) throws SQLException {
        this.subRows = new PageRowList();
        this.subRows.setRowColumnId(this.getId());
        this.subRows.setBuildColumns(true);
        this.subRows.setBuildIcelet(this.getBuildIcelet());
        this.subRows.setBuildIceletPropertyMap(this.getBuildIceletPropertyMap());
        this.subRows.setBuildSubRows(this.getBuildSubRows());
        this.subRows.buildList(db);
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Column ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        Object pst = null;
        Object rs = null;
        boolean i = false;
        return dependencyList;
    }

    public int computeRowColumnPosition(Connection db) throws SQLException {
        int result = 0;
        RowColumn otherRowColumn = new RowColumn();
        if (this.previousRowColumnId != -1) {
            otherRowColumn.queryRecord(db, this.previousRowColumnId);
            result = otherRowColumn.getPosition() + 1;
        } else if (this.nextRowColumnId != -1) {
            otherRowColumn.queryRecord(db, this.nextRowColumnId);
            result = otherRowColumn.getPosition();
        }
        return result;
    }

    public void updateRelatedRowColumns(Connection db, boolean add) throws SQLException {
        if (this.previousRowColumnId > -1) {
            RowColumnList.updateRelatedRowColumns(db, this.getId(), this.previousRowColumnId, this.getPageRowId(), false, add);
        } else if (this.nextRowColumnId > -1) {
            RowColumnList.updateRelatedRowColumns(db, this.getId(), this.nextRowColumnId, this.getPageRowId(), true, add);
        } else if (!add) {
            RowColumnList.updateRelatedRowColumns(db, this.getId(), -1, this.getPageRowId(), false, add);
        }
    }

    public void move(Connection db, boolean moveLeft) throws SQLException {
        RowColumn switchRowColumn = null;
        RowColumnList columns = new RowColumnList();
        columns.setPageRowId(this.getPageRowId());
        columns.setPosition(moveLeft ? this.getPosition() - 1 : this.getPosition() + 1);
        columns.buildList(db);
        if (columns.size() > 0) {
            switchRowColumn = (RowColumn)((Object)columns.get(0));
            int switchRowColumnPosition = this.getPosition();
            this.setPosition(switchRowColumn.getPosition());
            this.update(db);
            switchRowColumn.setPosition(switchRowColumnPosition);
            switchRowColumn.update(db);
        }
    }

    public void parsePropertyMapEntries(Connection db, RowColumn oldSelection) throws SQLException {
        if (oldSelection.getIceletId() > -1 && oldSelection.getIceletPropertyMap() != null) {
            oldSelection.getIceletPropertyMap().delete(db);
        }
        if (this.getIceletId() > -1) {
            this.getIceletPropertyMap().insert(db);
        }
    }

    public void addSubRow(Connection db) throws SQLException {
        PageRow pageRow = new PageRow();
        if (this.subRows.size() == 0) {
            RowColumn rowColumn = new RowColumn();
            rowColumn.setPageRowId(this.getPageRowId());
            rowColumn.setModifiedBy(this.getModifiedBy());
            rowColumn.setPosition(this.getPosition());
            rowColumn.setWidth(this.getWidth());
            rowColumn.setEnabled(this.getEnabled());
            rowColumn.setSwappingRowColumn(true);
            rowColumn.insert(db);
            PageRow pageRow1 = new PageRow();
            pageRow1.setRowColumnId(rowColumn.getId());
            pageRow1.setPosition(0);
            pageRow1.setEnabled(true);
            pageRow1.setModifiedBy(this.getModifiedBy());
            pageRow1.insert(db);
            this.setPosition(0);
            this.setPageRowId(pageRow1.getId());
            this.update(db);
            pageRow.setRowColumnId(rowColumn.getId());
            pageRow.setPosition(1);
            pageRow.setEnabled(true);
            pageRow.setModifiedBy(this.getModifiedBy());
            pageRow.insert(db);
        } else {
            PageRowList pageRowList = new PageRowList();
            pageRowList.setRowColumnId(this.getId());
            pageRowList.setBuildLastPosition(true);
            pageRowList.buildList(db);
            pageRow.setRowColumnId(this.getId());
            pageRow.setPosition(pageRowList.getLastPosition() != 0 ? pageRowList.getLastPosition() + 1 : pageRowList.getLastPosition());
            pageRow.setEnabled(true);
            pageRow.setModifiedBy(this.getModifiedBy());
            pageRow.insert(db);
        }
        Icelet htmlIcelet = null;
        IceletList iceletList = new IceletList();
        iceletList.setConfiguratorClass("HtmlContentPortlet");
        iceletList.buildList(db);
        if (iceletList.size() > 0) {
            htmlIcelet = (Icelet)((Object)iceletList.get(0));
        }
        RowColumn rowColumn = new RowColumn();
        rowColumn.setPageRowId(pageRow.getId());
        rowColumn.setModifiedBy(this.getModifiedBy());
        rowColumn.setEnabled(true);
        rowColumn.setWidth(50);
        rowColumn.setPosition(0);
        if (htmlIcelet != null && htmlIcelet.getId() > -1) {
            rowColumn.setIceletId(htmlIcelet.getId());
        }
        rowColumn.insert(db);
        if (htmlIcelet != null && htmlIcelet.getId() > -1) {
            IceletProperty property = new IceletProperty();
            property.setRowColumnId(rowColumn.getId());
            property.setValue("Please enter your html text here");
            property.setTypeConstant(HtmlContentPortlet.PROPERTY_HTMLTEXT);
            property.setModifiedBy(this.getModifiedBy());
            property.insert(db);
        }
    }

    public void buildSubColumns(HashMap map) {
        if (this.subRows != null && this.subRows.size() > 0) {
            for (PageRow subRow : this.subRows) {
                if (subRow.getRowColumnList() == null || subRow.getRowColumnList().size() <= 0) continue;
                for (RowColumn subColumn : subRow.getRowColumnList()) {
                    map.put(String.valueOf(subColumn.getId()), subColumn);
                    subColumn.buildSubColumns(map);
                }
            }
        }
    }

    public void fixSingleCellSubRow(Connection db) throws SQLException {
        PageRow subRow;
        if (this.subRows != null && this.subRows.size() == 1 && (subRow = (PageRow)((Object)this.getSubRows().get(0))).getRowColumnList().size() == 1) {
            RowColumn subColumn = (RowColumn)((Object)subRow.getRowColumnList().get(0));
            subColumn.setPageRowId(this.getPageRowId());
            subColumn.setWidth(this.getWidth());
            subColumn.setEnabled(this.getEnabled());
            subColumn.setPosition(this.getPosition());
            subColumn.setModifiedBy(this.getModifiedBy());
            subColumn.update(db);
            this.setSwappingRowColumn(true);
            this.delete(db);
        }
    }
}

