/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.aspcfs.modules.website.base.RowColumn;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class RowColumnList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int pageRowId = -1;
    private int iceletId = -1;
    private int enabled = -1;
    private boolean buildIcelet = false;
    private boolean buildIceletPropertyMap = false;
    private boolean buildSubRows = false;
    private int ignoreRowColumnId = -1;
    private int lastPosition = 0;
    private int lastPositionColumnId = -1;
    private boolean buildLastPosition = false;
    private int afterPosition = -1;
    private int beforePosition = -1;
    private int position = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setPageRowId(int tmp) {
        this.pageRowId = tmp;
    }

    public void setPageRowId(String tmp) {
        this.pageRowId = Integer.parseInt(tmp);
    }

    public void setIceletId(int tmp) {
        this.iceletId = tmp;
    }

    public void setIceletId(String tmp) {
        this.iceletId = Integer.parseInt(tmp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setBuildIcelet(boolean tmp) {
        this.buildIcelet = tmp;
    }

    public void setBuildIcelet(String tmp) {
        this.buildIcelet = DatabaseUtils.parseBoolean(tmp);
    }

    public void setBuildIceletPropertyMap(boolean tmp) {
        this.buildIceletPropertyMap = tmp;
    }

    public void setBuildIceletPropertyMap(String tmp) {
        this.buildIceletPropertyMap = DatabaseUtils.parseBoolean(tmp);
    }

    public void setIgnoreRowColumnId(int tmp) {
        this.ignoreRowColumnId = tmp;
    }

    public void setIgnoreRowColumnId(String tmp) {
        this.ignoreRowColumnId = Integer.parseInt(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getPageRowId() {
        return this.pageRowId;
    }

    public int getIceletId() {
        return this.iceletId;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public boolean getBuildIcelet() {
        return this.buildIcelet;
    }

    public boolean getBuildIceletPropertyMap() {
        return this.buildIceletPropertyMap;
    }

    public int getIgnoreRowColumnId() {
        return this.ignoreRowColumnId;
    }

    public int getLastPosition() {
        return this.lastPosition;
    }

    public void setLastPosition(int tmp) {
        this.lastPosition = tmp;
    }

    public void setLastPosition(String tmp) {
        this.lastPosition = Integer.parseInt(tmp);
    }

    public boolean getBuildLastPosition() {
        return this.buildLastPosition;
    }

    public void setBuildLastPosition(boolean tmp) {
        this.buildLastPosition = tmp;
    }

    public void setBuildLastPosition(String tmp) {
        this.buildLastPosition = DatabaseUtils.parseBoolean(tmp);
    }

    public int getAfterPosition() {
        return this.afterPosition;
    }

    public void setAfterPosition(int tmp) {
        this.afterPosition = tmp;
    }

    public void setAfterPosition(String tmp) {
        this.afterPosition = Integer.parseInt(tmp);
    }

    public int getBeforePosition() {
        return this.beforePosition;
    }

    public void setBeforePosition(int tmp) {
        this.beforePosition = tmp;
    }

    public void setBeforePosition(String tmp) {
        this.beforePosition = Integer.parseInt(tmp);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int tmp) {
        this.position = tmp;
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public int getLastPositionColumnId() {
        return this.lastPositionColumnId;
    }

    public void setLastPositionColumnId(int tmp) {
        this.lastPositionColumnId = tmp;
    }

    public void setLastPositionColumnId(String tmp) {
        this.lastPositionColumnId = Integer.parseInt(tmp);
    }

    public boolean getBuildSubRows() {
        return this.buildSubRows;
    }

    public void setBuildSubRows(boolean tmp) {
        this.buildSubRows = tmp;
    }

    public void setBuildSubRows(String tmp) {
        this.buildSubRows = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            RowColumn thisRowColumn = this.getObject(rs);
            this.add(thisRowColumn);
            if (!this.buildLastPosition) continue;
            this.lastPosition = thisRowColumn.getPosition() > this.getLastPosition() ? thisRowColumn.getPosition() : this.lastPosition;
            this.lastPositionColumnId = this.lastPosition == thisRowColumn.getPosition() ? thisRowColumn.getId() : this.lastPositionColumnId;
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        if (this.buildIceletPropertyMap || this.buildIcelet || this.buildSubRows) {
            for (RowColumn thisRowColumn : this) {
                thisRowColumn.setBuildIceletPropertyMap(this.buildIceletPropertyMap);
                thisRowColumn.setBuildIcelet(this.buildIcelet);
                thisRowColumn.setBuildSubRows(this.buildSubRows);
                if (this.buildIceletPropertyMap) {
                    thisRowColumn.buildIceletPropertyMap(db);
                }
                if (this.buildIcelet) {
                    thisRowColumn.buildIcelet(db);
                }
                if (!this.buildSubRows) continue;
                thisRowColumn.buildSubRows(db);
            }
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM web_row_column WHERE row_column_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("column_position", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY column_position ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("wrc.* FROM web_row_column wrc WHERE row_column_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id != -1) {
            sqlFilter.append("AND row_column_id = ? ");
        }
        if (this.pageRowId != -1) {
            sqlFilter.append("AND page_row_id = ? ");
        }
        if (this.iceletId != -1) {
            sqlFilter.append("AND icelet_id = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
        if (this.ignoreRowColumnId != -1) {
            sqlFilter.append("AND row_column_id <> ? ");
        }
        if (this.afterPosition > -1) {
            sqlFilter.append("AND column_position > ? ");
        }
        if (this.beforePosition > -1) {
            sqlFilter.append("AND column_position < ? ");
        }
        if (this.position > -1) {
            sqlFilter.append("AND column_position = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id != -1) {
            pst.setInt(++i, this.id);
        }
        if (this.pageRowId != -1) {
            pst.setInt(++i, this.pageRowId);
        }
        if (this.iceletId != -1) {
            pst.setInt(++i, this.iceletId);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        if (this.ignoreRowColumnId != -1) {
            pst.setInt(++i, this.ignoreRowColumnId);
        }
        if (this.afterPosition > -1) {
            pst.setInt(++i, this.afterPosition);
        }
        if (this.beforePosition > -1) {
            pst.setInt(++i, this.beforePosition);
        }
        if (this.position > -1) {
            pst.setInt(++i, this.position);
        }
        return i;
    }

    public RowColumn getObject(ResultSet rs) throws SQLException {
        return new RowColumn(rs);
    }

    public void delete(Connection db) throws SQLException {
        for (RowColumn thisRowColumn : this) {
            thisRowColumn.setDeletingFromList(true);
            thisRowColumn.delete(db);
        }
    }

    public static void updateRelatedRowColumns(Connection db, int currentId, int adjacentId, int pageRowId, boolean changeAdjacentPosition, boolean addition) throws SQLException {
        if (addition) {
            PreparedStatement pst = db.prepareStatement("UPDATE web_row_column SET column_position = column_position + 1 WHERE row_column_id <> ? AND page_row_id = ? AND " + (changeAdjacentPosition ? "column_position >= " : "column_position > ") + "(SELECT column_position FROM web_row_column WHERE row_column_id = ?) ");
            pst.setInt(1, currentId);
            pst.setInt(2, pageRowId);
            pst.setInt(3, adjacentId);
            pst.executeUpdate();
            pst.close();
        } else {
            PreparedStatement pst = db.prepareStatement("UPDATE web_row_column SET column_position = column_position - 1 WHERE page_row_id = ? AND column_position > (SELECT column_position FROM web_row_column WHERE row_column_id = ?) ");
            pst.setInt(1, pageRowId);
            pst.setInt(2, currentId);
            pst.executeUpdate();
            pst.close();
        }
    }

    public int getTotalColumnWidth() {
        int result = 0;
        for (RowColumn thisRowColumn : this) {
            result += thisRowColumn.getWidth();
        }
        return result;
    }
}

