/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.Page;
import org.aspcfs.modules.website.base.PageRowList;
import org.aspcfs.modules.website.base.SiteList;
import org.aspcfs.modules.website.base.Tab;
import org.aspcfs.modules.website.base.TabList;
import org.aspcfs.utils.DatabaseUtils;

public class Site
extends GenericBean {
    public static int EDIT_MODE = 602171327;
    public static int PORTAL_MODE = 602171328;
    private int id = -1;
    private String name = null;
    private String internalDescription = null;
    private int hitCount = 0;
    private String notes = null;
    private boolean enabled = false;
    private int layoutId = -1;
    private int styleId = -1;
    private int logoImageId = -1;
    private String template = null;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private boolean buildTabList = false;
    private TabList tabList = null;
    private boolean override = true;
    private Tab tabToDisplay = null;

    public Site() {
    }

    public Site(Connection db, int tmpSiteId) throws SQLException {
        this.queryRecord(db, tmpSiteId);
    }

    public Site(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setInternalDescription(String tmp) {
        this.internalDescription = tmp;
    }

    public void setHitCount(int tmp) {
        this.hitCount = tmp;
    }

    public void setHitCount(String tmp) {
        this.hitCount = Integer.parseInt(tmp);
    }

    public void setNotes(String tmp) {
        this.notes = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setLayoutId(int tmp) {
        this.layoutId = tmp;
    }

    public void setLayoutId(String tmp) {
        this.layoutId = Integer.parseInt(tmp);
    }

    public void setStyleId(int tmp) {
        this.styleId = tmp;
    }

    public void setStyleId(String tmp) {
        this.styleId = Integer.parseInt(tmp);
    }

    public void setLogoImageId(int tmp) {
        this.logoImageId = tmp;
    }

    public void setLogoImageId(String tmp) {
        this.logoImageId = Integer.parseInt(tmp);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setBuildTabList(boolean tmp) {
        this.buildTabList = tmp;
    }

    public void setBuildTabList(String tmp) {
        this.buildTabList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setTabList(TabList tmp) {
        this.tabList = tmp;
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getInternalDescription() {
        return this.internalDescription;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public String getNotes() {
        return this.notes;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getLayoutId() {
        return this.layoutId;
    }

    public int getStyleId() {
        return this.styleId;
    }

    public int getLogoImageId() {
        return this.logoImageId;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public boolean getBuildTabList() {
        return this.buildTabList;
    }

    public TabList getTabList() {
        if (this.tabList != null) {
            return this.tabList;
        }
        return new TabList();
    }

    public boolean getOverride() {
        return this.override;
    }

    public Tab getTabToDisplay() {
        return this.tabToDisplay;
    }

    public void setTabToDisplay(Tab tmp) {
        this.tabToDisplay = tmp;
    }

    public boolean queryRecord(Connection db, int tmpSiteId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT *  FROM web_site  WHERE site_id = ? ");
        pst.setInt(1, tmpSiteId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Site record not found");
        }
        if (this.buildTabList) {
            this.buildTabList(db);
        }
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean autoCommit = db.getAutoCommit();
        try {
            if (autoCommit) {
                db.setAutoCommit(false);
            }
            if (this.enabled) {
                SiteList.disableOtherSites(db);
            }
            this.id = DatabaseUtils.getNextSeq(db, "web_site_site_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO web_site (" + (this.id > -1 ? "site_id, " : "") + "site_name , " + "internal_description , " + "hit_count , " + "notes , " + "enabled , " + "layout_id , " + "style_id , " + "logo_image_id, " + "enteredby , " + "modifiedby ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?,?,?,?,?)");
            int i = 0;
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setString(++i, this.name);
            pst.setString(++i, this.internalDescription);
            DatabaseUtils.setInt(pst, ++i, this.hitCount > 0 ? this.hitCount : -1);
            pst.setString(++i, this.notes);
            pst.setBoolean(++i, this.enabled);
            DatabaseUtils.setInt(pst, ++i, this.layoutId);
            DatabaseUtils.setInt(pst, ++i, this.styleId);
            DatabaseUtils.setInt(pst, ++i, this.logoImageId);
            pst.setInt(++i, this.modifiedBy);
            pst.setInt(++i, this.modifiedBy);
            pst.execute();
            this.id = DatabaseUtils.getCurrVal(db, "web_site_site_id_seq", this.id);
            pst.close();
            if (autoCommit) {
                db.commit();
            }
        }
        catch (Exception e) {
            if (autoCommit) {
                db.rollback();
            }
            throw new SQLException("Site-> Error: " + e.getMessage());
        }
        finally {
            if (autoCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        if (this.getEnabled()) {
            SiteList.disableOtherSites(db);
        }
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE web_site SET site_name = ?, internal_description = ?, " + (this.hitCount > 0 ? "hit_count = ?, " : "") + "notes = ?, " + (this.layoutId > -1 ? "layout_id = ?, " : "") + (this.styleId > -1 ? "style_id = ?, " : "") + (this.logoImageId > -1 ? "logo_image_id = ?, " : "") + "enabled = ? ");
        if (!this.override) {
            sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
        }
        sql.append("WHERE site_id = ? ");
        if (!this.override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setString(++i, this.name);
        pst.setString(++i, this.internalDescription);
        if (this.hitCount > 0) {
            DatabaseUtils.setInt(pst, ++i, this.hitCount > 0 ? this.hitCount : -1);
        }
        pst.setString(++i, this.notes);
        if (this.layoutId > -1) {
            DatabaseUtils.setInt(pst, ++i, this.layoutId);
        }
        if (this.styleId > -1) {
            DatabaseUtils.setInt(pst, ++i, this.styleId);
        }
        if (this.logoImageId > -1) {
            DatabaseUtils.setInt(pst, ++i, this.logoImageId);
        }
        pst.setBoolean(++i, this.enabled);
        if (!this.override) {
            pst.setInt(++i, this.modifiedBy);
        }
        pst.setInt(++i, this.id);
        if (!this.override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int update(Connection db, boolean flag) throws SQLException {
        this.setOverride(flag);
        return this.update(db);
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Site ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        Object pst = null;
        Object rs = null;
        boolean i = false;
        return dependencyList;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("UPDATE web_site_access_log  SET site_id = ?  WHERE site_id = ? ");
            int i = 0;
            DatabaseUtils.setInt(pst, ++i, -1);
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            TabList tmpTabList = new TabList();
            tmpTabList.setSiteId(this.getId());
            tmpTabList.buildList(db);
            tmpTabList.delete(db);
            tmpTabList = null;
            pst = db.prepareStatement("DELETE FROM web_site WHERE site_id = ? ");
            i = 0;
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("site_id");
        this.name = rs.getString("site_name");
        this.internalDescription = rs.getString("internal_description");
        this.hitCount = DatabaseUtils.getInt(rs, "hit_count", 0);
        this.notes = rs.getString("notes");
        this.enabled = rs.getBoolean("enabled");
        this.layoutId = DatabaseUtils.getInt(rs, "layout_id");
        this.styleId = DatabaseUtils.getInt(rs, "style_id");
        this.logoImageId = DatabaseUtils.getInt(rs, "logo_image_id");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }

    public void buildTabList(Connection db) throws SQLException {
        this.buildTabList(db, -1);
    }

    public void buildTabList(Connection db, int enabled) throws SQLException {
        this.tabList = new TabList();
        this.tabList.setSiteId(this.getId());
        this.tabList.setEnabled(enabled);
        this.tabList.buildList(db);
    }

    public void buildResources(Connection db, int tabId, int pageId, int mode) throws SQLException {
        if (this.tabList == null) {
            this.buildTabList(db);
        }
        for (Tab thisTab : this.tabList) {
            if (thisTab.getId() != tabId) continue;
            thisTab.setMode(mode);
            thisTab.setPageToBuild(pageId);
            thisTab.setBuildPages(true);
            thisTab.buildPageGroupList(db);
            thisTab.buildTabBanner(db);
            this.setTabToDisplay(thisTab);
        }
    }

    public void buildRowsColumns(ArrayList rowColumnList) {
        Page page = this.getTabToDisplay().getThisPageToBuild();
        PageRowList rowList = page.getPageVersionToView().getPageRowList();
        rowList.buildRowsColumns(rowColumnList, 0);
    }

    public void updateLogoImageId(Connection db, int newLogoImageId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE web_site SET logo_image_id = ? WHERE site_id = ?");
        DatabaseUtils.setInt(pst, 1, newLogoImageId);
        pst.setInt(2, this.id);
        pst.executeUpdate();
        pst.close();
        this.logoImageId = newLogoImageId;
    }

    public void updateLayoutId(Connection db, int newLayoutId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE web_site SET layout_id = ? WHERE site_id = ?");
        DatabaseUtils.setInt(pst, 1, newLayoutId);
        pst.setInt(2, this.id);
        pst.executeUpdate();
        pst.close();
        this.layoutId = newLayoutId;
    }

    public void updateStyleId(Connection db, int newStyleId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE web_site SET style_id = ? WHERE site_id = ?");
        DatabaseUtils.setInt(pst, 1, newStyleId);
        pst.setInt(2, this.id);
        pst.executeUpdate();
        pst.close();
        this.styleId = newStyleId;
    }
}

