/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.aspcfs.modules.website.base.Site;
import org.aspcfs.utils.web.PagedListInfo;

public class SiteList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int enabled = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            Site thisSite = this.getObject(rs);
            this.add(thisSite);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM web_site WHERE site_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("modified", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY modified ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("w.* FROM web_site w WHERE site_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id != -1) {
            sqlFilter.append("AND site_id = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id != -1) {
            pst.setInt(++i, this.id);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        return i;
    }

    public Site getObject(ResultSet rs) throws SQLException {
        Site thisSite = new Site(rs);
        return thisSite;
    }

    public void delete(Connection db) throws SQLException {
        for (Site thisSite : this) {
            thisSite.delete(db);
        }
    }

    public static void disableOtherSites(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE web_site SET enabled = ? ");
        pst.setBoolean(1, false);
        pst.executeUpdate();
        pst.close();
    }
}

