/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class SiteLog
extends GenericBean {
    private int id = -1;
    private int siteId = -1;
    private int userId = -1;
    private String ip = "";
    private Timestamp entered = null;
    private String browser = null;
    private String referrer = null;

    public SiteLog() {
    }

    public SiteLog(Connection db, int tmpSiteLogId) throws SQLException {
        this.queryRecord(db, tmpSiteLogId);
    }

    public SiteLog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSite_id(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public void setIp(String tmp) {
        this.ip = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setBrowser(String tmp) {
        this.browser = tmp;
    }

    public void setReferrer(String tmp) {
        this.referrer = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getIp() {
        return this.ip;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public boolean queryRecord(Connection db, int tmpSiteLogId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT wsal.* FROM web_site_access_log wsal WHERE site_log_id = ? ");
        pst.setInt(1, tmpSiteLogId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "web_site_access_log_site_log_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_site_access_log (" + (this.id > -1 ? "site_log_id, " : "") + "site_id , " + "user_id , " + "ip , " + "browser , " + "referrer ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        DatabaseUtils.setInt(pst, ++i, this.siteId);
        DatabaseUtils.setInt(pst, ++i, this.userId);
        pst.setString(++i, this.ip);
        pst.setString(++i, this.browser);
        pst.setString(++i, this.referrer);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "web_site_access_log_site_log_id_seq", this.id);
        pst.close();
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM web_site_access_log WHERE site_log_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("site_log_id");
        this.siteId = rs.getInt("site_id");
        this.userId = rs.getInt("user_id");
        this.ip = rs.getString("ip");
        this.entered = rs.getTimestamp("entered");
        this.browser = rs.getString("browser");
        this.referrer = rs.getString("referrer");
    }
}

