/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class Style
extends GenericBean {
    private int id = -1;
    private int constant = -1;
    private String name = null;
    private String css = null;
    private String thumbnail = null;
    private boolean custom = false;
    private int layoutId = -1;

    public Style() {
    }

    public Style(Connection db, int tmpStyleId) throws SQLException {
        this.queryRecord(db, tmpStyleId);
    }

    public Style(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setConstant(int tmp) {
        this.constant = tmp;
    }

    public void setConstant(String tmp) {
        this.constant = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setCss(String tmp) {
        this.css = tmp;
    }

    public void setThumbnail(String tmp) {
        this.thumbnail = tmp;
    }

    public void setCustom(boolean tmp) {
        this.custom = tmp;
    }

    public void setCustom(String tmp) {
        this.custom = DatabaseUtils.parseBoolean(tmp);
    }

    public void setLayoutId(int tmp) {
        this.layoutId = tmp;
    }

    public void setLayoutId(String tmp) {
        this.layoutId = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getConstant() {
        return this.constant;
    }

    public String getName() {
        return this.name;
    }

    public String getCss() {
        return this.css;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public boolean getCustom() {
        return this.custom;
    }

    public int getLayoutId() {
        return this.layoutId;
    }

    public boolean queryRecord(Connection db, int tmpStyleId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT *  FROM web_style  WHERE style_id = ? ");
        pst.setInt(1, tmpStyleId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Style record not found");
        }
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "web_style_style_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_style (" + (this.id > -1 ? "style_id, " : "") + "style_constant , " + "style_name , " + "css , " + "thumbnail , " + "custom , " + "layout_id ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        DatabaseUtils.setInt(pst, ++i, this.constant);
        pst.setString(++i, this.name);
        pst.setString(++i, this.css);
        pst.setString(++i, this.thumbnail);
        pst.setBoolean(++i, this.custom);
        DatabaseUtils.setInt(pst, ++i, this.layoutId);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "web_style_style_id_seq", this.id);
        pst.close();
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE web_style SET style_constant = ? , style_name = ? , css = ? , thumbnail = ? , custom = ? , layout_id = ?  ");
        sql.append("WHERE layout_id = ? ");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.constant);
        pst.setString(++i, this.name);
        pst.setString(++i, this.css);
        pst.setString(++i, this.thumbnail);
        pst.setBoolean(++i, this.custom);
        DatabaseUtils.setInt(pst, ++i, this.layoutId);
        pst.setInt(++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM web_style WHERE style_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("style_id");
        this.constant = DatabaseUtils.getInt(rs, "style_constant");
        this.name = rs.getString("style_name");
        this.css = rs.getString("css");
        this.thumbnail = rs.getString("thumbnail");
        this.custom = rs.getBoolean("custom");
        this.layoutId = DatabaseUtils.getInt(rs, "layout_id");
    }
}

