/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.website.base.Page;
import org.aspcfs.modules.website.base.PageGroupList;
import org.aspcfs.modules.website.base.TabBanner;
import org.aspcfs.modules.website.base.TabBannerList;
import org.aspcfs.modules.website.base.TabList;
import org.aspcfs.utils.DatabaseUtils;

public class Tab
extends GenericBean {
    public static final int INITIAL_POSITION = 0;
    private int id = -1;
    private String displayText = null;
    private String internalDescription = null;
    private int siteId = -1;
    private int position = -1;
    private boolean enabled = false;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private int mode = -1;
    private boolean buildPageGroupList = false;
    private boolean buildPages = false;
    private PageGroupList pageGroupList = null;
    private boolean buildTabBanner = false;
    private TabBanner tabBanner = null;
    private int pageToBuild = -1;
    private boolean override = false;
    private Page thisPageToBuild = null;
    private int previousTabId = -1;
    private int nextTabId = -1;

    public Tab() {
    }

    public Tab(Connection db, int tmpTabId) throws SQLException {
        this.queryRecord(db, tmpTabId);
    }

    public Tab(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setDisplayText(String tmp) {
        this.displayText = tmp;
    }

    public void setInternalDescription(String tmp) {
        this.internalDescription = tmp;
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public void setPosition(int tmp) {
        this.position = tmp;
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setMode(int tmp) {
        this.mode = tmp;
    }

    public void setMode(String tmp) {
        this.mode = Integer.parseInt(tmp);
    }

    public void setBuildPageGroupList(boolean tmp) {
        this.buildPageGroupList = tmp;
    }

    public void setBuildPageGroupList(String tmp) {
        this.buildPageGroupList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setBuildPages(boolean tmp) {
        this.buildPages = tmp;
    }

    public void setBuildPages(String tmp) {
        this.buildPages = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPageGroupList(PageGroupList tmp) {
        this.pageGroupList = tmp;
    }

    public void setBuildTabBanner(boolean tmp) {
        this.buildTabBanner = tmp;
    }

    public void setBuildTabBanner(String tmp) {
        this.buildTabBanner = DatabaseUtils.parseBoolean(tmp);
    }

    public void setTabBanner(TabBanner tmp) {
        this.tabBanner = tmp;
    }

    public void setPageToBuild(int tmp) {
        this.pageToBuild = tmp;
    }

    public void setPageToBuild(String tmp) {
        this.pageToBuild = Integer.parseInt(tmp);
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getInternalDescription() {
        return this.internalDescription;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean getBuildPageGroupList() {
        return this.buildPageGroupList;
    }

    public boolean getBuildPages() {
        return this.buildPages;
    }

    public PageGroupList getPageGroupList() {
        return this.pageGroupList;
    }

    public boolean getBuildTabBanner() {
        return this.buildTabBanner;
    }

    public TabBanner getTabBanner() {
        return this.tabBanner;
    }

    public int getPageToBuild() {
        return this.pageToBuild;
    }

    public boolean getOverride() {
        return this.override;
    }

    public Page getThisPageToBuild() {
        return this.thisPageToBuild;
    }

    public void setThisPageToBuild(Page tmp) {
        this.thisPageToBuild = tmp;
    }

    public int getPreviousTabId() {
        return this.previousTabId;
    }

    public void setPreviousTabId(int tmp) {
        this.previousTabId = tmp;
    }

    public void setPreviousTabId(String tmp) {
        this.previousTabId = Integer.parseInt(tmp);
    }

    public int getNextTabId() {
        return this.nextTabId;
    }

    public void setNextTabId(int tmp) {
        this.nextTabId = tmp;
    }

    public void setNextTabId(String tmp) {
        this.nextTabId = Integer.parseInt(tmp);
    }

    public boolean queryRecord(Connection db, int tmpTabId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT *  FROM web_tab  WHERE tab_id = ? ");
        pst.setInt(1, tmpTabId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Tab record not found");
        }
        if (this.buildPageGroupList) {
            this.buildPageGroupList(db);
        }
        if (this.buildTabBanner) {
            this.buildTabBanner(db);
        }
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "web_tab_tab_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_tab (" + (this.id > -1 ? "tab_id, " : "") + "display_text , " + "internal_description , " + "site_id , " + "tab_position , " + "enabled , " + "enteredby , " + "modifiedby ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.displayText);
        pst.setString(++i, this.internalDescription);
        DatabaseUtils.setInt(pst, ++i, this.siteId);
        pst.setInt(++i, this.position);
        pst.setBoolean(++i, this.enabled);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.modifiedBy);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "web_tab_tab_id_seq", this.id);
        pst.close();
        this.updateRelatedTabs(db, true);
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE web_tab SET display_text = ? , internal_description = ? , site_id = ? , tab_position = ? , enabled = ?  ");
        if (!this.override) {
            sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
        }
        sql.append("WHERE tab_id = ? ");
        if (!this.override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.displayText);
        pst.setString(++i, this.internalDescription);
        DatabaseUtils.setInt(pst, ++i, this.siteId);
        pst.setInt(++i, this.position);
        pst.setBoolean(++i, this.enabled);
        if (!this.override) {
            pst.setInt(++i, this.modifiedBy);
        }
        pst.setInt(++i, this.id);
        if (!this.override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            PageGroupList tmpPageGroupList = new PageGroupList();
            tmpPageGroupList.setTabId(this.getId());
            tmpPageGroupList.buildList(db);
            tmpPageGroupList.delete(db);
            tmpPageGroupList = null;
            TabBannerList tmpTabBannerList = new TabBannerList();
            tmpTabBannerList.setTabId(this.getId());
            tmpTabBannerList.buildList(db);
            tmpTabBannerList.delete(db);
            tmpTabBannerList = null;
            this.updateRelatedTabs(db, false);
            PreparedStatement pst = db.prepareStatement("DELETE FROM web_tab WHERE tab_id =  ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("tab_id");
        this.displayText = rs.getString("display_text");
        this.internalDescription = rs.getString("internal_description");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
        this.position = rs.getInt("tab_position");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }

    public void buildPageGroupList(Connection db) throws SQLException {
        this.pageGroupList = new PageGroupList();
        this.pageGroupList.setTabId(this.getId());
        this.pageGroupList.setMode(this.mode);
        this.pageGroupList.setBuildPages(this.buildPages);
        this.pageGroupList.setPageToBuild(this.pageToBuild);
        this.pageGroupList.buildList(db);
        if (this.pageToBuild != -1 && this.pageGroupList.getThisPageToBuild() != null) {
            this.setThisPageToBuild(this.pageGroupList.getThisPageToBuild());
            this.getThisPageToBuild().setPageGroup(this.pageGroupList.getGroupById(this.getThisPageToBuild().getPageGroupId()));
        }
    }

    public void buildTabBanner(Connection db) throws SQLException {
        TabBannerList tabBannerList = new TabBannerList();
        tabBannerList.setTabId(this.getId());
        tabBannerList.buildList(db);
        if (tabBannerList.size() > 0) {
            this.tabBanner = (TabBanner)((Object)tabBannerList.get(0));
        }
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Site ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        Object pst = null;
        Object rs = null;
        boolean i = false;
        return dependencyList;
    }

    public int computeTabPosition(Connection db) throws SQLException {
        int result = 0;
        Tab otherTab = new Tab();
        if (this.previousTabId != -1) {
            otherTab.queryRecord(db, this.previousTabId);
            result = otherTab.getPosition() + 1;
        } else if (this.nextTabId != -1) {
            otherTab.queryRecord(db, this.nextTabId);
            result = otherTab.getPosition();
        }
        return result;
    }

    public void updateRelatedTabs(Connection db, boolean add) throws SQLException {
        if (this.previousTabId > -1) {
            TabList.updateRelatedTabs(db, this.getId(), this.previousTabId, this.getSiteId(), false, add);
        } else if (this.nextTabId > -1) {
            TabList.updateRelatedTabs(db, this.getId(), this.nextTabId, this.getSiteId(), true, add);
        } else if (!add) {
            TabList.updateRelatedTabs(db, this.getId(), -1, this.getSiteId(), false, add);
        }
    }

    public void move(Connection db, boolean moveLeft) throws SQLException {
        Tab switchTab = null;
        TabList tabs = new TabList();
        tabs.setSiteId(this.getSiteId());
        tabs.setPosition(moveLeft ? this.getPosition() - 1 : this.getPosition() + 1);
        tabs.buildList(db);
        if (tabs.size() > 0) {
            switchTab = (Tab)((Object)tabs.get(0));
            int switchTabPosition = this.getPosition();
            this.setPosition(switchTab.getPosition());
            this.update(db);
            switchTab.setPosition(switchTabPosition);
            switchTab.update(db);
        }
    }
}

