/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.website.base.PageList;
import org.aspcfs.utils.DatabaseUtils;

public class TabBanner
extends GenericBean {
    private int id = -1;
    private int tabId = -1;
    private int imageId = -1;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private boolean override = false;

    public TabBanner() {
    }

    public TabBanner(Connection db, int tmpTabBannerId) throws SQLException {
        this.queryRecord(db, tmpTabBannerId);
    }

    public TabBanner(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setTabId(int tmp) {
        this.tabId = tmp;
    }

    public void setTabId(String tmp) {
        this.tabId = Integer.parseInt(tmp);
    }

    public void setImageId(int tmp) {
        this.imageId = tmp;
    }

    public void setImageId(String tmp) {
        this.imageId = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getTabId() {
        return this.tabId;
    }

    public int getImageId() {
        return this.imageId;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public boolean getOverride() {
        return this.override;
    }

    public boolean queryRecord(Connection db, int tmpTabBannerId) throws SQLException {
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "web_tab_banner_tab_banner_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_tab_banner (" + (this.id > -1 ? "tab_banner_id, " : "") + "tab_id , " + "image_id , " + "enteredby , " + "modifiedby ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        DatabaseUtils.setInt(pst, ++i, this.tabId);
        DatabaseUtils.setInt(pst, ++i, this.imageId);
        pst.setInt(++i, this.enteredBy);
        pst.setInt(++i, this.modifiedBy);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "web_tab_banner_tab_banner_id_seq", this.id);
        pst.close();
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE web_tab_banner SET tab_id = ? , image_id = ? ");
        if (!this.override) {
            sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
        }
        sql.append("WHERE tab_banner_id = ? ");
        if (!this.override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.tabId);
        DatabaseUtils.setInt(pst, ++i, this.imageId);
        if (!this.override) {
            pst.setInt(++i, this.modifiedBy);
        }
        pst.setInt(++i, this.id);
        if (!this.override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            PageList tmpPageList = new PageList();
            tmpPageList.setTabBannerId(this.getId());
            tmpPageList.buildList(db);
            tmpPageList.delete(db);
            tmpPageList = null;
            PreparedStatement pst = db.prepareStatement("DELETE FROM web_tab_banner WHERE tab_banner_id =  ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("tab_banner_id");
        this.tabId = DatabaseUtils.getInt(rs, "tab_id");
        this.imageId = DatabaseUtils.getInt(rs, "image_id");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }
}

