/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.aspcfs.modules.website.base.Site;
import org.aspcfs.modules.website.base.Tab;
import org.aspcfs.utils.web.PagedListInfo;

public class TabList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int siteId = -1;
    private int enabled = -1;
    private int afterPosition = -1;
    private int beforePosition = -1;
    private int position = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public int getAfterPosition() {
        return this.afterPosition;
    }

    public void setAfterPosition(int tmp) {
        this.afterPosition = tmp;
    }

    public void setAfterPosition(String tmp) {
        this.afterPosition = Integer.parseInt(tmp);
    }

    public int getBeforePosition() {
        return this.beforePosition;
    }

    public void setBeforePosition(int tmp) {
        this.beforePosition = tmp;
    }

    public void setBeforePosition(String tmp) {
        this.beforePosition = Integer.parseInt(tmp);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int tmp) {
        this.position = tmp;
    }

    public void setPosition(String tmp) {
        this.position = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            Tab thisTab = this.getObject(rs);
            this.add(thisTab);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM web_tab WHERE tab_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("tab_position", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY tab_position ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("wt.* FROM web_tab wt WHERE tab_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) throws SQLException {
        if (this.id != -1) {
            sqlFilter.append("AND tab_id = ? ");
        }
        if (this.siteId != -1) {
            sqlFilter.append("AND site_id = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
        if (this.afterPosition > -1) {
            sqlFilter.append("AND tab_position > ? ");
        }
        if (this.beforePosition > -1) {
            sqlFilter.append("AND tab_position < ? ");
        }
        if (this.position > -1) {
            sqlFilter.append("AND tab_position = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id != -1) {
            pst.setInt(++i, this.id);
        }
        if (this.siteId != -1) {
            pst.setInt(++i, this.siteId);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        if (this.afterPosition > -1) {
            pst.setInt(++i, this.afterPosition);
        }
        if (this.beforePosition > -1) {
            pst.setInt(++i, this.beforePosition);
        }
        if (this.position > -1) {
            pst.setInt(++i, this.position);
        }
        return i;
    }

    public Tab getObject(ResultSet rs) throws SQLException {
        return new Tab(rs);
    }

    public void delete(Connection db) throws SQLException {
        for (Tab thisTab : this) {
            thisTab.delete(db);
        }
    }

    public static int queryDefault(Connection db, int tmpSiteId, int mode) throws SQLException {
        int tabId = -1;
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT tab_id  FROM web_tab  WHERE site_id = ? " + (mode == Site.PORTAL_MODE ? "AND enabled = ? " : "") + " ORDER BY tab_position ");
        int i = 0;
        pst.setInt(++i, tmpSiteId);
        if (mode == Site.PORTAL_MODE) {
            pst.setBoolean(++i, true);
        }
        if ((rs = pst.executeQuery()).next()) {
            tabId = rs.getInt("tab_id");
        }
        rs.close();
        pst.close();
        return tabId;
    }

    public static void updateRelatedTabs(Connection db, int currentId, int adjacentId, int siteId, boolean changeAdjacentPosition, boolean addition) throws SQLException {
        if (addition) {
            PreparedStatement pst = db.prepareStatement("UPDATE web_tab SET tab_position = tab_position + 1 WHERE tab_id <> ? AND site_id = ? AND " + (changeAdjacentPosition ? "tab_position >= " : "tab_position > ") + "(SELECT tab_position FROM web_tab WHERE tab_id = ?) ");
            pst.setInt(1, currentId);
            pst.setInt(2, siteId);
            pst.setInt(3, adjacentId);
            pst.executeUpdate();
            pst.close();
        } else {
            PreparedStatement pst = db.prepareStatement("UPDATE web_tab SET tab_position = tab_position - 1 WHERE site_id = ? AND tab_position > (SELECT tab_position FROM web_tab WHERE tab_id = ?) ");
            pst.setInt(1, siteId);
            pst.setInt(2, currentId);
            pst.executeUpdate();
            pst.close();
        }
    }

    public static boolean queryEnabled(Connection db, int tabId) throws SQLException {
        boolean enabled = false;
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT enabled  FROM web_tab  WHERE tab_id = ?  AND enabled = ? ");
        int i = 0;
        pst.setInt(++i, tabId);
        pst.setBoolean(++i, true);
        rs = pst.executeQuery();
        if (rs.next()) {
            enabled = true;
        }
        rs.close();
        pst.close();
        return enabled;
    }
}

