/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Template
extends GenericBean {
    private String filename = null;
    private String locale = null;
    private String name = null;
    private double version = 0.0;
    private String vendor = null;
    private String description = null;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private int layout = -1;
    private int style = -1;

    public Template() {
    }

    public Template(ZipFile zipFile) throws IOException {
        this.filename = zipFile.getName().substring(zipFile.getName().lastIndexOf(System.getProperty("file.separator")) + 1, zipFile.getName().lastIndexOf(".zip"));
        ZipEntry zipEntry = zipFile.getEntry("website/MANIFEST.MF");
        if (zipEntry == null) {
            zipEntry = zipFile.getEntry("website\\MANIFEST.MF");
        }
        InputStream manifestStream = zipFile.getInputStream(zipEntry);
        byte[] manifest = new byte[manifestStream.available()];
        int numRead = 0;
        for (int offset = 0; offset < manifest.length && (numRead = manifestStream.read(manifest, offset, manifest.length - offset)) >= 0; offset += numRead) {
        }
        manifestStream.close();
        String manifestAsString = new String(manifest);
        String[] manifestItem = manifestAsString.split("\n");
        for (int count = 0; count < manifestItem.length; ++count) {
            String value;
            if (manifestItem[count].indexOf("Name") != -1) {
                value = manifestItem[count].split(":")[1];
                this.name = value.trim();
            }
            if (manifestItem[count].indexOf("Description") != -1) {
                value = manifestItem[count].split(":")[1];
                this.description = value.trim();
            }
            if (manifestItem[count].indexOf("Layout") != -1) {
                try {
                    value = manifestItem[count].split(":")[1];
                    this.layout = Integer.parseInt(value.trim());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (manifestItem[count].indexOf("Style") == -1) continue;
            try {
                value = manifestItem[count].split(":")[1];
                this.style = Integer.parseInt(value.trim());
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getVersion() {
        return this.version;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setModified(Timestamp modified) {
        this.modified = modified;
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int layout) {
        this.layout = layout;
    }

    public boolean hasLayout() {
        return this.layout > -1;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public boolean hasStyle() {
        return this.style > -1;
    }
}

