/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class WebProductAccessLog
extends GenericBean {
    private int productId = -1;
    private int siteLogId = -1;
    private Timestamp entered = null;

    public WebProductAccessLog() {
    }

    public WebProductAccessLog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setSiteLogId(int tmp) {
        this.siteLogId = tmp;
    }

    public void setSiteLogId(String tmp) {
        this.siteLogId = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getProductId() {
        return this.productId;
    }

    public int getSiteLogId() {
        return this.siteLogId;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public boolean insert(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_product_access_log (product_id , site_log_id ) VALUES (?,?)");
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.productId);
        DatabaseUtils.setInt(pst, ++i, this.siteLogId);
        pst.execute();
        pst.close();
        return true;
    }

    public static PreparedStatement prepareInsert(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_product_access_log (product_id , site_log_id ) VALUES (?,?)");
        return pst;
    }

    public boolean insertData(PreparedStatement pst) throws SQLException {
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.productId);
        DatabaseUtils.setInt(pst, ++i, this.siteLogId);
        pst.execute();
        return true;
    }

    public static boolean closeInsert(PreparedStatement pst) throws SQLException {
        pst.close();
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.productId = rs.getInt("product_id");
        this.siteLogId = rs.getInt("site_log_id");
        this.entered = rs.getTimestamp("entered");
    }
}

