/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class WebProductEmailLog
extends GenericBean {
    private int productId = -1;
    private String emailsTo = null;
    private String fromName = null;
    private String comments = null;
    private int siteLogId = -1;
    private Timestamp entered = null;

    public WebProductEmailLog() {
    }

    public WebProductEmailLog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setEmailsTo(String tmp) {
        this.emailsTo = tmp;
    }

    public void setFromName(String tmp) {
        this.fromName = tmp;
    }

    public void setComments(String tmp) {
        this.comments = tmp;
    }

    public void setSiteLogId(int tmp) {
        this.siteLogId = tmp;
    }

    public void setSiteLogId(String tmp) {
        this.siteLogId = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getProductId() {
        return this.productId;
    }

    public String getEmailsTo() {
        return this.emailsTo;
    }

    public String getFromName() {
        return this.fromName;
    }

    public String getComments() {
        return this.comments;
    }

    public int getSiteLogId() {
        return this.siteLogId;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public boolean insert(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_product_email_log (product_id , emails_to , from_name , comments , site_log_id ) VALUES (?,?,?,?,?)");
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.productId);
        pst.setString(++i, this.emailsTo);
        pst.setString(++i, this.fromName);
        pst.setString(++i, this.comments);
        DatabaseUtils.setInt(pst, ++i, this.siteLogId);
        pst.execute();
        pst.close();
        return true;
    }

    public static PreparedStatement prepareInsert(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("INSERT INTO web_product_email_log (product_id , emails_to , from_name , comments , site_log_id ) VALUES (?,?,?,?,?)");
        return pst;
    }

    public boolean insertData(PreparedStatement pst) throws SQLException {
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.productId);
        pst.setString(++i, this.emailsTo);
        pst.setString(++i, this.fromName);
        pst.setString(++i, this.comments);
        DatabaseUtils.setInt(pst, ++i, this.siteLogId);
        pst.execute();
        return true;
    }

    public static void closeInsert(PreparedStatement pst) throws SQLException {
        pst.close();
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.productId = DatabaseUtils.getInt(rs, "product_id");
        this.emailsTo = rs.getString("emails_to");
        this.fromName = rs.getString("from_name");
        this.comments = rs.getString("comments");
        this.siteLogId = DatabaseUtils.getInt(rs, "site_log_id");
        this.entered = rs.getTimestamp("entered");
    }
}

