/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.framework;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.portlet.PortletException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.driver.core.PortalEnvironment;
import org.apache.pluto.driver.core.PortalServletRequest;
import org.apache.pluto.driver.core.PortalServletResponse;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.website.base.Icelet;
import org.aspcfs.modules.website.base.Page;
import org.aspcfs.modules.website.base.PageRow;
import org.aspcfs.modules.website.base.PageVersion;
import org.aspcfs.modules.website.base.RowColumn;
import org.aspcfs.modules.website.base.Site;
import org.aspcfs.modules.website.base.Tab;
import org.aspcfs.modules.website.framework.IceletRegistryService;
import org.quartz.Scheduler;

public class IceletManager {
    private PortletContainer container = null;
    private IceletRegistryService registryService = new IceletRegistryService();

    public IceletManager() {
    }

    public IceletManager(ServletContext context) {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("IceletManager-> Initializing the container");
        }
        this.container = (PortletContainer)context.getAttribute("PortletContainer");
        if (System.getProperty("DEBUG") != null) {
            System.out.println("IceletManager-> Initializing the registry service");
        }
        this.registryService.init(context);
    }

    public static synchronized IceletManager getManager(ActionContext actionContext) {
        ServletContext context = actionContext.getServletContext();
        IceletManager manager = (IceletManager)context.getAttribute("iceletManager");
        if (manager == null || !manager.isConfigured()) {
            context.setAttribute("ContextPath", (Object)actionContext.getRequest().getContextPath());
            manager = new IceletManager(context);
            context.setAttribute("iceletManager", (Object)manager);
        }
        return manager;
    }

    public boolean isConfigured() {
        return this.container != null;
    }

    public static void destroy(ServletContext context) {
        IceletManager manager = (IceletManager)context.getAttribute("iceletManager");
        if (manager != null) {
            manager = null;
            context.removeAttribute("iceletManager");
        }
    }

    public boolean prepare(ActionContext context, Site site, int tabId, int pageId, Connection db) throws Exception {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("IceletManager-> Preparing portlets...");
        }
        PortalEnvironment portalEnvironment = new PortalEnvironment(context.getRequest(), context.getResponse());
        PortalURL portalURL = portalEnvironment.getRequestedPortalURL();
        String actionWindowId = portalURL.getActionWindow();
        Tab tab = site.getTabToDisplay();
        Page page = site.getTabToDisplay().getThisPageToBuild();
        boolean result = false;
        PageVersion pageVersion = page.getPageVersionToView();
        for (PageRow pageRow : pageVersion.getPageRowList()) {
            for (RowColumn rowColumn : pageRow.getRowColumnList()) {
                HashMap subColumns = new HashMap();
                rowColumn.buildSubColumns(subColumns);
                if (rowColumn.getIcelet() != null) {
                    result = this.buildIceletDetails(context, db, rowColumn, portalURL, portalEnvironment, actionWindowId);
                    if (!result) continue;
                    return true;
                }
                if (subColumns.size() <= 0) continue;
                Iterator iter = subColumns.keySet().iterator();
                while (iter.hasNext()) {
                    RowColumn subRowColumn = (RowColumn)((Object)subColumns.get(iter.next()));
                    if (subRowColumn.getIcelet() == null || !(result = this.buildIceletDetails(context, db, subRowColumn, portalURL, portalEnvironment, actionWindowId))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean buildIceletDetails(ActionContext context, Connection db, RowColumn rowColumn, PortalURL portalURL, PortalEnvironment portalEnvironment, String actionWindowId) throws Exception {
        block9: {
            Icelet thisIcelet = rowColumn.getIcelet();
            PortletWindowConfig windowConfig = this.registryService.getPortlet(rowColumn.getId() + "." + thisIcelet.getConfiguratorClass());
            PortletWindowImpl portletWindow = new PortletWindowImpl(windowConfig, portalURL, rowColumn.getId());
            if (actionWindowId != null) {
                if (actionWindowId.equals(portletWindow.getId().getStringId())) {
                    try {
                        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
                        context.getRequest().setAttribute("applicationPrefs", (Object)prefs);
                        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
                        context.getRequest().setAttribute("connectionElement", (Object)ce);
                        SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getSession().getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
                        context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
                        context.getRequest().setAttribute("connection", (Object)db);
                        Scheduler scheduler = (Scheduler)context.getServletContext().getAttribute("Scheduler");
                        context.getRequest().setAttribute("scheduler", (Object)scheduler);
                        UserBean userBean = (UserBean)((Object)context.getRequest().getSession().getAttribute("User"));
                        context.getRequest().setAttribute("userBean", (Object)userBean);
                        this.container.doAction((PortletWindow)portletWindow, context.getRequest(), context.getResponse());
                    }
                    catch (PortletContainerException ex) {
                        throw new ServletException((Throwable)ex);
                    }
                    catch (PortletException ex) {
                        throw new ServletException((Throwable)ex);
                    }
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("IceletManager-> Action request processed.");
                    }
                    return true;
                }
            } else {
                try {
                    PortalServletRequest portalRequest = new PortalServletRequest(context.getRequest(), (PortletWindow)portletWindow);
                    ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
                    portalRequest.setAttribute("connectionElement", (Object)ce);
                    SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getSession().getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
                    portalRequest.setAttribute("systemStatus", (Object)systemStatus);
                    ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
                    portalRequest.setAttribute("applicationPrefs", (Object)prefs);
                    portalRequest.setAttribute("connection", (Object)db);
                    Scheduler scheduler = (Scheduler)context.getServletContext().getAttribute("Scheduler");
                    portalRequest.setAttribute("scheduler", (Object)scheduler);
                    UserBean userBean = (UserBean)((Object)context.getRequest().getSession().getAttribute("User"));
                    portalRequest.setAttribute("userBean", (Object)userBean);
                    PortalServletResponse portalResponse = new PortalServletResponse(context.getResponse());
                    this.container.doRender((PortletWindow)portletWindow, (HttpServletRequest)portalRequest, (HttpServletResponse)portalResponse);
                    context.getRequest().setAttribute("portal_response_" + rowColumn.getId(), (Object)portalResponse);
                }
                catch (Exception e) {
                    if (System.getProperty("DEBUG") == null) break block9;
                    System.out.println("JspClass-> editor_site: Error loading icelet: " + e.getMessage());
                    e.printStackTrace(System.out);
                }
            }
        }
        return false;
    }

    public PortletContainer getContainer() {
        return this.container;
    }

    public IceletRegistryService getRegistryService() {
        return this.registryService;
    }
}

