/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.framework;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.pluto.driver.config.DriverConfigurationException;
import org.apache.pluto.driver.services.portal.PortletApplicationConfig;
import org.apache.pluto.driver.services.portal.PortletRegistryService;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.services.portal.admin.DriverAdministrationException;
import org.apache.pluto.driver.services.portal.admin.PortletRegistryAdminService;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class IceletRegistryService
implements PortletRegistryService,
PortletRegistryAdminService {
    private PortletApplicationConfig app = null;
    private ServletContext servletContext = null;

    public void init(ServletContext context) throws DriverConfigurationException {
        this.servletContext = context;
        if (this.app == null) {
            this.app = new PortletApplicationConfig();
            String contextPath = (String)context.getAttribute("ContextPath");
            if (contextPath == null) {
                contextPath = "";
            }
            this.app.setContextPath(contextPath + "/PlutoInvoker");
            if (System.getProperty("DEBUG") != null) {
                System.out.println("IceletRegistryService-> app contextPath: " + this.app.getContextPath());
            }
            try {
                InputStream in = context.getResourceAsStream("WEB-INF/portlet.xml");
                StringBuffer text = new StringBuffer();
                byte[] b = new byte[1];
                while (in.read(b) != -1) {
                    text.append(new String(b));
                }
                in.close();
                XMLUtils xml = new XMLUtils(text.toString());
                ArrayList portlets = new ArrayList();
                XMLUtils.getAllChildren(xml.getDocumentElement(), "portlet", portlets);
                for (Element thisPortlet : portlets) {
                    PortletWindowConfig portletWindowConfig = new PortletWindowConfig();
                    portletWindowConfig.setPortletName(XMLUtils.getNodeText(XMLUtils.getFirstElement(thisPortlet, "portlet-name")));
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("IceletRegistryService-> Adding portlet: " + portletWindowConfig.getPortletName());
                    }
                    this.app.addPortlet(portletWindowConfig);
                }
            }
            catch (Exception e) {
                throw new DriverConfigurationException((Throwable)e);
            }
        }
    }

    public void destroy() throws DriverConfigurationException {
        this.app = null;
        this.servletContext = null;
    }

    public Collection getPortlets() {
        return this.app.getPortlets();
    }

    public Set getPortletApplications() {
        return new HashSet(this.app.getPortlets());
    }

    public PortletApplicationConfig getPortletApplication(String string) {
        return this.app;
    }

    public PortletWindowConfig getPortlet(String id) {
        if (id == null) {
            return null;
        }
        String uniqueId = this.getContextFromPortletId(id);
        String portlet = this.getPortletNameFromPortletId(id);
        if (this.app == null) {
            return null;
        }
        PortletWindowConfig thisPortlet = this.app.getPortlet(portlet);
        return thisPortlet;
    }

    public void addPortletApplication(String contextPath) throws DriverConfigurationException {
        if (contextPath == null) {
            throw new IllegalArgumentException("Portlet application context path cannot be null.");
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("IceletRegistryService-> addPortletApplication: " + contextPath);
        }
        try {
            PortletApplicationConfig portletAppConfig = new PortletApplicationConfig();
            portletAppConfig.setContextPath(contextPath);
            ServletContext portletAppServletContext = this.servletContext.getContext(contextPath);
            if (portletAppServletContext == null) {
                throw new DriverAdministrationException("Unable to locate servlet context: " + contextPath + ": ensure that crossContext support is enabled " + "and the portlet application has been deployed.");
            }
        }
        catch (Exception ex) {
            throw new DriverConfigurationException("Unable to add portlet application from " + contextPath, (Throwable)ex);
        }
    }

    private String getContextFromPortletId(String portletId) {
        int idx = portletId.indexOf(".");
        if (idx < 0) {
            return null;
        }
        return portletId.substring(0, idx);
    }

    private String getPortletNameFromPortletId(String portletId) {
        int idx = portletId.indexOf(".");
        if (idx < 0) {
            return null;
        }
        return portletId.substring(idx + 1);
    }
}

