/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.icelet;

import com.zeroio.iteam.base.FileItem;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationEmailAddress;
import org.aspcfs.modules.accounts.base.OrganizationEmailAddressList;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactAddress;
import org.aspcfs.modules.contacts.base.ContactAddressList;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddressList;
import org.aspcfs.modules.login.beans.LoginBean;
import org.aspcfs.modules.orders.base.CreditCard;
import org.aspcfs.modules.orders.base.CreditCardList;
import org.aspcfs.modules.orders.base.Order;
import org.aspcfs.modules.orders.base.OrderAddress;
import org.aspcfs.modules.orders.base.OrderProduct;
import org.aspcfs.modules.orders.base.PaymentCreditCard;
import org.aspcfs.modules.quotes.base.QuoteProductBean;
import org.aspcfs.modules.website.utils.PortletUtils;
import org.aspcfs.utils.LoginUtils;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.CountrySelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.StateSelect;

public class CartPortlet
extends GenericPortlet {
    public static final String fs = System.getProperty("file.separator");
    public static String EMAIL_TO = "6062311";
    public static String EMAIL_SUBJECT = "6062312";
    public static String MESSAGE_TO_REVIEWER = "6062313";
    public static String MESSAGE_TO_REQUESTER = "6062314";
    public static String QUOTE_SENT_MESSAGE = "6071314";
    public static String CART_EMPTY_MESSAGE = "6071313";
    public static String INCLUDE_ORDER = "6080315";
    public static String WEB_CUSTOMER_ROLE = "6080316";
    public static String ACCOUNT_CREATE_WELCOME_MESSAGE = "6080317";
    public static String ACCOUNT_CREATE_THANKYOU_MESSAGE = "6080318";
    public static String ORDER_THANKYOU_MESSAGE = "6080319";
    public static String ORDER_ERROR_MESSAGE = "6080320";
    private static final String VIEW_PAGE1 = "/portlets/cart/cart.jsp";
    private static final String VIEW_PAGE2 = "/portlets/cart/cart_sent.jsp";
    private static final String VIEW_PAGE3 = "/portlets/cart/create_account.jsp";
    private static final String VIEW_PAGE4 = "/portlets/cart/add_address.jsp";
    private static final String VIEW_PAGE5 = "/portlets/cart/modify_address.jsp";
    private static final String VIEW_PAGE6 = "/portlets/cart/address_list.jsp";
    private static final String VIEW_PAGE7 = "/portlets/cart/modify_credit_card.jsp";
    private static final String VIEW_PAGE8 = "/portlets/cart/credit_card_list.jsp";
    private static final String VIEW_PAGE9 = "/portlets/cart/confirm_order.jsp";
    private static final String VIEW_PAGE10 = "/portlets/cart/order_confirmation_status.jsp";
    private static final String VIEW_PAGE11 = "/portlets/cart/create_account_success.jsp";
    private static final String VIEW_PAGE12 = "/portlets/cart/cart_quote_request.jsp";
    private static final String VIEW_PAGE13 = "/portlets/cart/customer_login.jsp";
    private static final String VIEW_PAGE14 = "/portlets/cart/state_list.jsp";
    private static final String VIEW_PAGE15 = "/portlets/cart/forgot_password.jsp";
    private static final String VIEW_PAGE16 = "/portlets/cart/password_repare.jsp";

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("CartPortlet-> PortletMode: " + request.getPortletMode());
        }
        String viewType = request.getParameter("viewType");
        if (request.getPortletMode() == PortletMode.VIEW) {
            if ("email".equals(viewType)) {
                request.setAttribute("QUOTE_SENT_MESSAGE", (Object)request.getPreferences().getValue(QUOTE_SENT_MESSAGE, "Your quote has been sent."));
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE2);
                requestDispatcher.include(request, response);
            } else if ("createAccount".equals(viewType)) {
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE3);
                requestDispatcher.include(request, response);
            } else if ("addAddress".equals(viewType)) {
                this.modifyAddress(request, response);
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE4);
                requestDispatcher.include(request, response);
            } else if ("modifyAddress".equals(viewType)) {
                this.modifyAddress(request, response);
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE5);
                requestDispatcher.include(request, response);
            } else if ("modifyCard".equals(viewType)) {
                this.modifyCreditCard(request, response);
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE7);
                requestDispatcher.include(request, response);
            } else if ("cardList".equals(viewType)) {
                this.modifyCreditCard(request, response);
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE8);
                requestDispatcher.include(request, response);
            } else if ("confirmOrder".equals(viewType)) {
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE9);
                requestDispatcher.include(request, response);
            } else if ("confirmOrderStatus".equals(viewType)) {
                if (request.getParameter("error") != null) {
                    request.setAttribute("ORDER_ERROR_MESSAGE", (Object)request.getPreferences().getValue(ORDER_ERROR_MESSAGE, "Your order can not be processed."));
                } else {
                    request.setAttribute("ORDER_THANKYOU_MESSAGE", (Object)request.getPreferences().getValue(ORDER_THANKYOU_MESSAGE, "Your order has been processed successfully."));
                }
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE10);
                requestDispatcher.include(request, response);
            } else if ("createAccountSuccess".equals(viewType)) {
                PortletRequestDispatcher requestDispatcher;
                if (request.getParameter("error") != null) {
                    request.setAttribute("error", (Object)request.getParameter("error"));
                    request.setAttribute("nameFirst", (Object)request.getParameter("nameFirst"));
                    request.setAttribute("nameLast", (Object)request.getParameter("nameLast"));
                    request.setAttribute("emailaddress", (Object)request.getParameter("emailaddress"));
                    request.setAttribute("orgName", (Object)request.getParameter("orgName"));
                    requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE3);
                } else {
                    request.setAttribute("ACCOUNT_CREATE_THANKYOU_MESSAGE", (Object)request.getPreferences().getValue(ACCOUNT_CREATE_THANKYOU_MESSAGE, "Your account has been create."));
                    requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE11);
                }
                requestDispatcher.include(request, response);
            } else if ("requestQuote".equals(viewType)) {
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE12);
                requestDispatcher.include(request, response);
            } else if ("customerLogin".equals(viewType)) {
                PortletRequestDispatcher requestDispatcher;
                if (((HttpServletRequest)request).getSession().getAttribute("WebUser") != null) {
                    this.associateAddress(request, response);
                    requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE6);
                } else {
                    requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE13);
                }
                requestDispatcher.include(request, response);
            } else if ("addressList".equals(viewType)) {
                this.associateAddress(request, response);
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE6);
                requestDispatcher.include(request, response);
            } else if ("loginFailed".equals(viewType)) {
                request.setAttribute("LoginFailedMessage", (Object)request.getParameter("LoginFailedMessage"));
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE13);
                requestDispatcher.include(request, response);
            } else if ("selectState".equals(viewType)) {
                this.states(request, response);
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE14);
                requestDispatcher.include(request, response);
            } else if ("forgotPassword".equals(viewType)) {
                request.setAttribute("username", (Object)request.getParameter("username"));
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE15);
                requestDispatcher.include(request, response);
            } else if ("passwordRepare".equals(viewType)) {
                request.setAttribute("result", (Object)request.getParameter("result"));
                if ("newPasswordSent".equals(request.getParameter("result"))) {
                    PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE16);
                    requestDispatcher.include(request, response);
                } else {
                    PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE15);
                    requestDispatcher.include(request, response);
                }
            } else {
                request.setAttribute("CART_EMPTY_MESSAGE", (Object)request.getPreferences().getValue(CART_EMPTY_MESSAGE, "Your cart is empty."));
                request.setAttribute("INCLUDE_ORDER", (Object)request.getPreferences().getValue(INCLUDE_ORDER, "false"));
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE1);
                requestDispatcher.include(request, response);
            }
        } else if (request.getPortletMode() == new PortletMode("config")) {
            PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE2);
            requestDispatcher.include(request, response);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) {
        if (request.getParameter("login") != null) {
            if (((HttpServletRequest)request).getSession().getAttribute("WebUser") != null) {
                response.setRenderParameter("viewType", "addressList");
            } else {
                this.siteLogin(request, response);
            }
        } else if (request.getParameter("requestQuote") != null) {
            this.requestQuote(request, response);
        } else if (request.getParameter("save") != null) {
            this.saveCart(request, response);
            if (request.getParameter("returnStr") != null && "confirmOrder".equals(request.getParameter("returnStr"))) {
                response.setRenderParameter("viewType", "confirmOrder");
            }
        } else if (request.getParameter("clear") != null) {
            this.clearCart(request, response);
        } else if (request.getParameter("email") != null) {
            this.emailCart(request, response);
        } else if (request.getParameter("checkout") != null) {
            this.createAccount(request, response);
        } else if (request.getParameter("forgotPassword") != null) {
            this.passwordRepare(request, response);
        } else if (request.getParameter("selectAddress") != null) {
            this.saveAddressPreference(request, response);
            if (request.getParameter("returnStr") != null && "confirmOrder".equals(request.getParameter("returnStr"))) {
                response.setRenderParameter("viewType", "confirmOrder");
            } else {
                response.setRenderParameter("viewType", "cardList");
            }
        } else if (request.getParameter("deleteAddress") != null) {
            this.deleteAddresses(request, response);
            response.setRenderParameter("viewType", "addressList");
        } else if (request.getParameter("createAccount") != null) {
            try {
                this.saveAccount(request, response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            response.setRenderParameter("viewType", "createAccountSuccess");
        } else if (request.getParameter("updateAddress") != null) {
            try {
                this.updateAddress(request, response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            response.setRenderParameter("viewType", "addressList");
        } else if (request.getParameter("updateCreditCard") != null) {
            try {
                this.updateCreditCard(request, response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            response.setRenderParameter("viewType", "cardList");
        } else if (request.getParameter("confirmOrder") != null) {
            try {
                this.associateCard(request, response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            response.setRenderParameter("viewType", "confirmOrder");
        } else if (request.getParameter("deleteCard") != null) {
            this.deleteCard(request, response);
            response.setRenderParameter("viewType", "cardList");
        } else if (request.getParameter("confirmOrderStatus") != null) {
            this.confirmOrder(request, response);
            if (request.getParameter("error") != null) {
                response.setRenderParameter("error", request.getParameter("error"));
            }
            response.setRenderParameter("viewType", "confirmOrderStatus");
        } else if (request.getParameter("cancelOrder") != null) {
            this.cancelOrder(request, response);
        }
    }

    private void passwordRepare(ActionRequest request, ActionResponse response) {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        String username = request.getParameter("username");
        User user = new User();
        try {
            if (user.exists(db, username)) {
                String password = user.generateRandomPassword(db);
                this.sendNewPassword(request, response, username, password);
                response.setRenderParameter("result", "newPasswordSent");
            } else {
                response.setRenderParameter("result", "userNotExists");
            }
            response.setRenderParameter("viewType", "passwordRepare");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void sendNewPassword(ActionRequest request, ActionResponse response, String email, String password) {
        HashMap cartBean = (HashMap)((HttpServletRequest)request).getSession().getAttribute("CartBean");
        if (cartBean != null && cartBean.size() > 0) {
            SMTPMessage mail = new SMTPMessage();
            mail.setHost(PortletUtils.getApplicationPrefs((PortletRequest)request, "MAILSERVER"));
            mail.setType("text/html");
            mail.addTo(email);
            mail.setSubject("New Password");
            StringBuffer body = new StringBuffer();
            body.append("Your new password is: ");
            body.append(password);
            mail.setBody(body.toString());
            if (mail.send() == 2) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("CartPortlet-> Send error: " + mail.getErrorMsg() + "<br><br>");
                }
                System.err.println(mail.getErrorMsg());
            }
        }
    }

    private void deleteCard(ActionRequest request, ActionResponse response) {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        try {
            if (request.getParameter("deleteCard") != null) {
                String[] deleteIds = request.getParameterValues("deleteCardId");
                CreditCard card = new CreditCard();
                if (deleteIds != null) {
                    for (int i = 0; i < deleteIds.length; ++i) {
                        card.setId(deleteIds[i]);
                        card.delete(db);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteAddresses(ActionRequest request, ActionResponse response) {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        try {
            if (request.getParameter("deleteAddress") != null) {
                String[] deleteIds = request.getParameterValues("deleteAddressId");
                ContactAddress adr = new ContactAddress();
                if (deleteIds != null) {
                    for (int i = 0; i < deleteIds.length; ++i) {
                        adr.setId(deleteIds[i]);
                        adr.delete(db);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void siteLogin(ActionRequest request, ActionResponse response) {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        LoginBean login = new LoginBean();
        login.setUsername(request.getParameter("username"));
        login.setPassword(request.getParameter("password"));
        try {
            LoginUtils userUtil = new LoginUtils(db, login);
            if (userUtil.isPortalUserValid(db)) {
                User user = new User(db, userUtil.getUserId());
                ((HttpServletRequest)request).getSession().setAttribute("WebUser", (Object)user);
                response.setRenderParameter("viewType", "addressList");
            } else {
                response.setRenderParameter("LoginFailedMessage", "".equals(login.getMessage()) ? "Login Failed" : login.getMessage());
                response.setRenderParameter("viewType", "loginFailed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void requestQuote(ActionRequest request, ActionResponse response) {
        response.setRenderParameter("viewType", "requestQuote");
    }

    private void clearCart(ActionRequest request, ActionResponse response) {
        if (((HttpServletRequest)request).getSession().getAttribute("CartBean") != null) {
            ((HttpServletRequest)request).getSession().removeAttribute("CartBean");
        }
    }

    private void saveAccount(ActionRequest request, ActionResponse response) throws Exception {
        block9: {
            Connection db = PortletUtils.getConnection((PortletRequest)request);
            boolean inserted = false;
            User thisUser = new User();
            thisUser.setUsername(request.getParameter("emailaddress"));
            thisUser.setPassword1(request.getParameter("password"));
            thisUser.setPassword2(request.getParameter("confirmPassword"));
            if (!thisUser.isDuplicate(db)) {
                Contact thisContact = new Contact();
                AccessTypeList accessTypes = PortletUtils.getSystemStatus((PortletRequest)request).getAccessTypeList(db, 626030331);
                thisContact.setAccessType(accessTypes.getDefaultItem());
                thisContact.setNameFirst(request.getParameter("nameFirst"));
                thisContact.setNameLast(request.getParameter("nameLast"));
                String emailAddress = request.getParameter("emailaddress");
                if (emailAddress != null && !"".equals(emailAddress)) {
                    LookupList emailTypeList = new LookupList(db, "lookup_contactemail_types");
                    ContactEmailAddress email = new ContactEmailAddress();
                    email.setType(emailTypeList.getDefaultElementCode());
                    email.setEmail(emailAddress);
                    thisContact.setEmailAddressList(new ContactEmailAddressList());
                    thisContact.getEmailAddressList().add(email);
                }
                thisContact.setEnteredBy(0);
                thisContact.setModifiedBy(0);
                thisContact.insert(db);
                ApplicationPrefs prefs = PortletUtils.getApplicationPrefs((PortletRequest)request);
                String roleId = request.getPreferences().getValue(WEB_CUSTOMER_ROLE, "1");
                thisUser.setContactId(thisContact.getId());
                thisUser.setRoleId(Integer.parseInt(roleId));
                thisUser.setEnteredBy(0);
                thisUser.setModifiedBy(0);
                thisUser.setTimeZone(prefs.get("SYSTEM.TIMEZONE"));
                thisUser.setCurrency(prefs.get("SYSTEM.CURRENCY"));
                thisUser.setLanguage(prefs.get("SYSTEM.LANGUAGE"));
                boolean userInserted = thisUser.insert(db);
                if (userInserted) {
                    Organization account = new Organization();
                    account.setName(request.getParameter("orgName"));
                    account.setNameFirst(request.getParameter("nameFirst"));
                    account.setNameLast(request.getParameter("nameLast"));
                    emailAddress = request.getParameter("emailaddress");
                    if (emailAddress != null && !"".equals(emailAddress)) {
                        LookupList emailTypeList = new LookupList(db, "lookup_contactemail_types");
                        OrganizationEmailAddress email = new OrganizationEmailAddress();
                        email.setType(emailTypeList.getDefaultElementCode());
                        email.setEmail(emailAddress);
                        account.setEmailAddressList(new OrganizationEmailAddressList());
                        account.getEmailAddressList().add(email);
                    }
                    account.setEnteredBy(thisUser.getId());
                    account.setModifiedBy(thisUser.getId());
                    account.setOwner(thisUser.getId());
                    account.setInsertPrimaryContact(false);
                    inserted = account.insert(db);
                    if (inserted) {
                        thisContact.setOrgId(account.getId());
                        thisContact.setOrgName(account.getName());
                        thisContact.setModifiedBy(thisUser.getId());
                        thisContact.update(db);
                    }
                    this.sendCreateAccountNotification(request, response, thisUser.getUsername());
                    LoginBean login = new LoginBean();
                    login.setUsername(request.getParameter("emailaddress"));
                    login.setPassword(request.getParameter("password"));
                    try {
                        LoginUtils userUtil = new LoginUtils(db, login);
                        if (userUtil.isPortalUserValid(db)) {
                            User user = new User(db, userUtil.getUserId());
                            ((HttpServletRequest)request).getSession().setAttribute("WebUser", (Object)user);
                            break block9;
                        }
                        response.setRenderParameter("LoginFailedMessage", "".equals(login.getMessage()) ? "Login Failed" : login.getMessage());
                        response.setRenderParameter("viewType", "loginFailed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                response.setRenderParameter("error", "Name is duplicate.");
                response.setRenderParameter("nameFirst", request.getParameter("nameFirst"));
                response.setRenderParameter("nameLast", request.getParameter("nameLast"));
                response.setRenderParameter("emailaddress", request.getParameter("emailaddress"));
                response.setRenderParameter("orgName", request.getParameter("nameFirst"));
            }
        }
    }

    private void sendCreateAccountNotification(ActionRequest request, ActionResponse response, String email) {
        SMTPMessage mail = new SMTPMessage();
        mail.setHost(PortletUtils.getApplicationPrefs((PortletRequest)request, "MAILSERVER"));
        mail.setType("text/html");
        mail.addTo(email);
        mail.setSubject("New account");
        StringBuffer body = new StringBuffer();
        body.append(request.getPreferences().getValue(ACCOUNT_CREATE_WELCOME_MESSAGE, "Welcome to our website. You have just created new account"));
        mail.setBody(body.toString());
        if (mail.send() == 2) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("CartPortlet-> Send error: " + mail.getErrorMsg() + "<br><br>");
            }
            System.err.println(mail.getErrorMsg());
        }
    }

    private void createAccount(ActionRequest request, ActionResponse response) {
        response.setRenderParameter("viewType", "createAccount");
    }

    private void modifyAddress(RenderRequest request, RenderResponse response) {
        SystemStatus systemStatus = PortletUtils.getSystemStatus((PortletRequest)request);
        ApplicationPrefs prefs = PortletUtils.getApplicationPrefs((PortletRequest)request);
        StateSelect stateSelect = new StateSelect(systemStatus, prefs.get("SYSTEM.COUNTRY"));
        stateSelect.setPreviousStates(new HashMap());
        CountrySelect countrySelect = new CountrySelect(systemStatus);
        request.setAttribute("StateSelect", (Object)stateSelect);
        request.setAttribute("CountrySelect", (Object)countrySelect);
        request.setAttribute("applicationPrefs", (Object)prefs);
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        try {
            LookupList addrTypeList = new LookupList(db, "lookup_contactaddress_types");
            request.setAttribute("typeList", (Object)addrTypeList);
            ContactAddress thisAddress = new ContactAddress();
            if (request.getParameter("addressId") != null) {
                thisAddress = new ContactAddress(db, Integer.parseInt(request.getParameter("addressId")));
            }
            request.setAttribute("addressItem", (Object)thisAddress);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateAddress(ActionRequest request, ActionResponse response) {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        User user = (User)((Object)((HttpServletRequest)request).getSession().getAttribute("WebUser"));
        ContactAddress address = new ContactAddress();
        try {
            address.setStreetAddressLine1(request.getParameter("address1"));
            address.setStreetAddressLine2(request.getParameter("address2"));
            address.setStreetAddressLine3(request.getParameter("address3"));
            address.setStreetAddressLine4(request.getParameter("address4"));
            address.setCity(request.getParameter("city"));
            address.setType(request.getParameter("type"));
            address.setState(request.getParameter("state1"));
            address.setOtherState(request.getParameter("state2"));
            address.setCountry(request.getParameter("countryId"));
            address.setContactId(user.getContactId());
            address.setEnabled(true);
            if (request.getParameter("addressId") == null || "-1".equals(request.getParameter("addressId"))) {
                address.setEnteredBy(user.getId());
                address.setModifiedBy(user.getId());
                address.insert(db);
            } else {
                address.setId(request.getParameter("addressId"));
                address.setModifiedBy(user.getId());
                address.update(db, user.getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void modifyCreditCard(RenderRequest request, RenderResponse response) {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        User user = (User)((Object)((HttpServletRequest)request).getSession().getAttribute("WebUser"));
        try {
            LookupList cardTypeList = new LookupList(db, "lookup_creditcard_types");
            request.setAttribute("cardTypeList", (Object)cardTypeList);
            CreditCard thisCard = new CreditCard();
            if (request.getParameter("cardId") != null && !"-1".equals(request.getParameter("cardId"))) {
                thisCard = new CreditCard(db, Integer.parseInt(request.getParameter("cardId")));
            }
            CreditCardList cardList = new CreditCardList();
            cardList.setEnteredBy(user.getId());
            cardList.buildList(db);
            request.setAttribute("creditCard", (Object)thisCard);
            request.setAttribute("creditCardList", (Object)cardList);
            request.setAttribute("return", (Object)request.getParameter("return"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateCreditCard(ActionRequest request, ActionResponse response) {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        User user = (User)((Object)((HttpServletRequest)request).getSession().getAttribute("WebUser"));
        CreditCard card = new CreditCard();
        try {
            card.setCardType(request.getParameter("cardType"));
            card.setCardNumber(request.getParameter("cardNumber"));
            card.setNameOnCard(request.getParameter("nameOnCard"));
            card.setExpirationMonth(request.getParameter("expirationMonth"));
            card.setExpirationYear(request.getParameter("expirationYear"));
            if (request.getParameter("cardId") == null || "-1".equals(request.getParameter("cardId"))) {
                card.setEnteredBy(user.getId());
                card.setModifiedBy(user.getId());
                card.insert(db);
            } else {
                card.setId(request.getParameter("cardId"));
                card.setModifiedBy(user.getId());
                card.update(db);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void associateCard(ActionRequest request, ActionResponse response) {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        String useInOrder = request.getParameter("useInOrder");
        CreditCard card = null;
        try {
            if (useInOrder != null && !"".equals(useInOrder) && !"-1".equals(useInOrder)) {
                card = new CreditCard(db, Integer.parseInt(useInOrder));
                ((HttpServletRequest)request).getSession().setAttribute("creditCardInOrder", (Object)card);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void associateAddress(RenderRequest request, RenderResponse response) {
        User user = (User)((Object)((HttpServletRequest)request).getSession().getAttribute("WebUser"));
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        try {
            ContactAddressList thisList = new ContactAddressList();
            thisList.setContactId(user.getContactId());
            thisList.buildList(db);
            request.setAttribute("addressList", (Object)thisList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute("returnStr", (Object)request.getParameter("returnStr"));
    }

    private void saveAddressPreference(ActionRequest request, ActionResponse response) {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        String billing = request.getParameter("billing");
        String shipping = request.getParameter("shipping");
        ContactAddress address = new ContactAddress();
        try {
            if (billing != null && !"".equals(billing) && !"-1".equals(billing)) {
                address = new ContactAddress(db, Integer.parseInt(billing));
                ((HttpServletRequest)request).getSession().setAttribute("billingAddress", (Object)address);
            }
            if (shipping != null && !"".equals(shipping) && !"-1".equals(shipping)) {
                address = new ContactAddress(db, Integer.parseInt(shipping));
                ((HttpServletRequest)request).getSession().setAttribute("shippingAddress", (Object)address);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute("returnStr", (Object)request.getParameter("returnStr"));
    }

    private void confirmOrder(ActionRequest request, ActionResponse response) {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        User user = (User)((Object)((HttpServletRequest)request).getSession().getAttribute("WebUser"));
        HashMap cartBean = (HashMap)((HttpServletRequest)request).getSession().getAttribute("CartBean");
        ContactAddress billingAddress = (ContactAddress)((HttpServletRequest)request).getSession().getAttribute("billingAddress");
        OrderAddress orderBillingAddress = new OrderAddress();
        ContactAddress shippingAddress = (ContactAddress)((HttpServletRequest)request).getSession().getAttribute("shippingAddress");
        OrderAddress orderShippingAddress = new OrderAddress();
        CreditCard card = (CreditCard)((Object)((HttpServletRequest)request).getSession().getAttribute("creditCardInOrder"));
        Order order = new Order();
        try {
            order.setBillingContactId(user.getId());
            order.setOrgId(0);
            order.setOrderedBy(user.getId());
            order.setEnteredBy(user.getId());
            order.setModifiedBy(user.getId());
            boolean inserted = order.insert(db);
            if (inserted) {
                if (cartBean.size() > 0) {
                    for (String productId : cartBean.keySet()) {
                        QuoteProductBean quoteProductBean = (QuoteProductBean)((Object)cartBean.get(productId));
                        OrderProduct orderProduct = new OrderProduct();
                        orderProduct.setProductId(quoteProductBean.getProduct().getId());
                        orderProduct.setQuantity(quoteProductBean.getQuantity());
                        orderProduct.setModifiedBy(user.getId());
                        orderProduct.setEnteredBy(user.getId());
                        orderProduct.setStatusId(1);
                        orderProduct.setOrderId(order.getId());
                        orderProduct.insert(db);
                    }
                }
                PaymentCreditCard pCard = new PaymentCreditCard();
                pCard.setCardNumber(card.getCardNumber());
                pCard.setCardSecurityCode(card.getCardSecurityCode());
                pCard.setCardType(card.getCardType());
                pCard.setCompanyNameOnCard(card.getCompanyNameOnCard());
                pCard.setExpirationMonth(card.getExpirationMonth());
                pCard.setExpirationYear(card.getExpirationYear());
                pCard.setNameOnCard(card.getNameOnCard());
                pCard.setOrderId(order.getId());
                pCard.setModifiedBy(user.getId());
                pCard.setEnteredBy(user.getId());
                pCard.insert(db);
                BeanUtils.copyProperties((Object)billingAddress, (Object)orderBillingAddress);
                orderBillingAddress.setOrderId(order.getId());
                orderBillingAddress.setModifiedBy(user.getId());
                orderBillingAddress.setEnteredBy(user.getId());
                orderBillingAddress.insert(db);
                BeanUtils.copyProperties((Object)orderShippingAddress, (Object)shippingAddress);
                orderShippingAddress.setOrderId(order.getId());
                orderShippingAddress.setModifiedBy(user.getId());
                orderShippingAddress.setEnteredBy(user.getId());
                orderShippingAddress.insert(db);
                this.clearCart(request, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("error", (Object)e.getMessage());
        }
    }

    private void cancelOrder(ActionRequest request, ActionResponse response) {
        this.clearCart(request, response);
        if (((HttpServletRequest)request).getSession().getAttribute("billingAddress") != null) {
            ((HttpServletRequest)request).getSession().removeAttribute("billingAddress");
        }
        if (((HttpServletRequest)request).getSession().getAttribute("shippingAddress") != null) {
            ((HttpServletRequest)request).getSession().removeAttribute("shippingAddress");
        }
        if (((HttpServletRequest)request).getSession().getAttribute("creditCardInOrder") != null) {
            ((HttpServletRequest)request).getSession().removeAttribute("CreditCardInOrder");
        }
    }

    private void emailCart(ActionRequest request, ActionResponse response) {
        String userName = request.getParameter("userName");
        String userEmail = request.getParameter("userEmail");
        HashMap cartBean = (HashMap)((HttpServletRequest)request).getSession().getAttribute("CartBean");
        if (cartBean != null && cartBean.size() > 0) {
            SMTPMessage mailToReviewer = new SMTPMessage();
            mailToReviewer.setHost(PortletUtils.getApplicationPrefs((PortletRequest)request, "MAILSERVER"));
            mailToReviewer.setType("text/html");
            mailToReviewer.addTo(request.getPreferences().getValue(EMAIL_TO, "-1"));
            mailToReviewer.setFrom(PortletUtils.getApplicationPrefs((PortletRequest)request, "EMAILADDRESS"));
            mailToReviewer.addReplyTo(userEmail);
            mailToReviewer.setSubject(request.getPreferences().getValue(EMAIL_SUBJECT, "Quote request"));
            Template template = new Template();
            template.setText(request.getPreferences().getValue(MESSAGE_TO_REVIEWER, userName + " has requested a quote for the following items:"));
            template.addParseElement("${quoteRequester.name}", userName);
            String messageHeader = template.getParsedText();
            this.getMailBody(cartBean, mailToReviewer, request, messageHeader);
            if (mailToReviewer.send() == 2) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("CartPortlet-> Send message to reviewer error: " + mailToReviewer.getErrorMsg());
                }
                System.err.println(mailToReviewer.getErrorMsg());
            } else if (System.getProperty("DEBUG") != null) {
                System.out.println("CartPortlet -> Sending message to reviewer...");
            }
            SMTPMessage mailToRequester = new SMTPMessage();
            mailToRequester.setHost(PortletUtils.getApplicationPrefs((PortletRequest)request, "MAILSERVER"));
            mailToRequester.setType("text/html");
            mailToRequester.setFrom(PortletUtils.getApplicationPrefs((PortletRequest)request, "EMAILADDRESS"));
            mailToRequester.addTo(userEmail);
            mailToRequester.setSubject(request.getPreferences().getValue(EMAIL_SUBJECT, "Quote request"));
            template = new Template();
            template.setText(request.getPreferences().getValue(MESSAGE_TO_REQUESTER, userName + " has requested a quote for the following items:"));
            template.addParseElement("${quoteReviewer.email}", request.getPreferences().getValue(EMAIL_TO, "-1"));
            messageHeader = template.getParsedText();
            this.getMailBody(cartBean, mailToRequester, request, messageHeader);
            if (mailToRequester.send() == 2) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("CartPortlet-> Send  message to requester error: " + mailToRequester.getErrorMsg());
                }
                System.err.println(mailToRequester.getErrorMsg());
            } else {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("CartPortlet -> Sending message to requester...");
                }
                ((HttpServletRequest)request).getSession().removeAttribute("CartBean");
                response.setRenderParameter("viewType", "email");
            }
        }
    }

    private void getMailBody(HashMap cartBean, SMTPMessage mail, ActionRequest request, String message) {
        StringBuffer body = new StringBuffer();
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        body.append(message);
        body.append("<table>");
        Iterator iterator = cartBean.keySet().iterator();
        body.append("<tr>");
        body.append("<th width=\"140\">Image</th>");
        body.append("<th width=\"140\">Name</th>");
        body.append("<th width=\"140\">Quantity</th>");
        body.append("</tr>");
        while (iterator.hasNext()) {
            String productId = (String)iterator.next();
            QuoteProductBean element = (QuoteProductBean)((Object)cartBean.get(productId));
            body.append("<tr>");
            body.append("<td width=\"140\">");
            try {
                if (element.getProduct().getLargeImageId() != -1) {
                    FileItem fileItem = new FileItem(db, element.getProduct().getLargeImageId());
                    fileItem.setDirectory(PortletUtils.getDbNamePath((PortletRequest)request) + "products" + fs);
                    String imagePath = fileItem.getFullFilePath();
                    mail.addImage("productImage" + productId, "file:///" + imagePath);
                    body.append("<img src=\"cid:productImage" + productId + "\" border=\"0\"><BR>");
                } else {
                    body.append("Image not available");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            body.append("</td>");
            body.append("<td>");
            body.append("<div>");
            body.append(element.getProduct().getName());
            body.append("</div>");
            body.append("</td>");
            body.append("<td width=\"10\">");
            body.append(element.getQuantity());
            body.append("</td>");
            body.append("</tr>");
        }
        body.append("</table>");
        body.append("<br/>");
        body.append(request.getParameter("comments"));
        mail.setBody(body.toString());
    }

    private void saveCart(ActionRequest request, ActionResponse response) {
        HashMap cartBean = (HashMap)((HttpServletRequest)request).getSession().getAttribute("CartBean");
        String[] deleteIds = request.getParameterValues("quoteProductId");
        if (deleteIds != null) {
            for (int i = 0; i < deleteIds.length; ++i) {
                cartBean.remove(deleteIds[i]);
            }
        }
        if (cartBean.size() > 0) {
            for (String productId : cartBean.keySet()) {
                QuoteProductBean quoteProductBean = (QuoteProductBean)((Object)cartBean.get(productId));
                String item = request.getParameter("quantity_" + productId);
                quoteProductBean.setQuantity(StringUtils.getIntegerNumber(item));
            }
        } else {
            ((HttpServletRequest)request).getSession().removeAttribute("CartBean");
        }
        request.setAttribute("returnStr", (Object)request.getParameter("returnStr"));
    }

    public void states(RenderRequest request, RenderResponse response) {
        SystemStatus systemStatus = PortletUtils.getSystemStatus((PortletRequest)request);
        String country = request.getParameter("countryId");
        StateSelect stateSelect = new StateSelect(systemStatus, country);
        request.setAttribute("stateSelect", (Object)stateSelect.getHtmlSelectObj(country));
        request.setAttribute("obj", (Object)"state1");
    }
}

