/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.icelet;

import java.io.IOException;
import java.sql.Connection;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddressList;
import org.aspcfs.modules.website.utils.PortletUtils;
import org.aspcfs.utils.web.LookupList;

public class ContactFormPortlet
extends GenericPortlet {
    public static final String INTRODUCTION = "6022302";
    public static final String THANKYOU = "6022303";
    public static final String SHOW_EMAIL = "6022304";
    public static final String EMAIL_REQUIRED = "6022305";
    public static final String LEAD_SOURCE = "2006051911";
    private static final String VIEW_PAGE1 = "/portlets/contact_form/contact_form.jsp";
    private static final String VIEW_PAGE2 = "/portlets/contact_form/contact_form_submitted.jsp";

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String verified = request.getParameter("verified");
        if (verified == null) {
            request.setAttribute("nameFirst", request.getPortletSession().getAttribute("nameFirst"));
            request.setAttribute("introduction", (Object)request.getPreferences().getValue(INTRODUCTION, "To contact us, please fill out the following form..."));
            request.setAttribute("showEmail", (Object)request.getPreferences().getValue(SHOW_EMAIL, "true"));
            request.setAttribute("emailRequired", (Object)request.getPreferences().getValue(EMAIL_REQUIRED, "true"));
            request.setAttribute("source", (Object)request.getPreferences().getValue(LEAD_SOURCE, "-1"));
            PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE1);
            requestDispatcher.include(request, response);
        } else {
            request.setAttribute("nameFirst", request.getPortletSession().getAttribute("nameFirst"));
            request.setAttribute("thankyou", (Object)request.getPreferences().getValue(THANKYOU, "Thank you, we will contact you soon."));
            PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE2);
            requestDispatcher.include(request, response);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        try {
            this.insertLead(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        response.setRenderParameter("verified", "true");
        request.getPortletSession().setAttribute("nameFirst", (Object)request.getParameter("nameFirst"));
    }

    private void insertLead(ActionRequest request, ActionResponse response) throws Exception {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        AccessTypeList accessTypeList = new AccessTypeList(db, 626030330);
        Contact lead = new Contact();
        lead.setAccessType(accessTypeList.getCode(626030334));
        lead.setIsLead(true);
        lead.setLeadStatus(1);
        lead.setNameFirst(request.getParameter("nameFirst"));
        lead.setNameLast(request.getParameter("nameLast"));
        lead.setOrgName(request.getParameter("orgName"));
        lead.setComments(request.getParameter("comments"));
        lead.setSource(request.getParameter("source"));
        lead.setEnteredBy(0);
        lead.setModifiedBy(0);
        String emailAddress = request.getParameter("email1address");
        if (emailAddress != null && !"".equals(emailAddress)) {
            LookupList emailTypeList = new LookupList(db, "lookup_contactemail_types");
            ContactEmailAddress email = new ContactEmailAddress();
            email.setType(emailTypeList.getDefaultElementCode());
            email.setEmail(emailAddress);
            lead.setEmailAddressList(new ContactEmailAddressList());
            lead.getEmailAddressList().add(email);
        }
        lead.insert(db);
    }
}

