/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.icelet;

import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.aspcfs.modules.website.base.PortfolioCategory;
import org.aspcfs.modules.website.base.PortfolioCategoryList;
import org.aspcfs.modules.website.base.PortfolioItem;
import org.aspcfs.modules.website.base.PortfolioItemList;
import org.aspcfs.modules.website.utils.PortletUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class PortfolioPortlet
extends GenericPortlet {
    private static final String VIEW_PAGE1 = "/portlets/portfolio/portfolio_summary.jsp";
    private static final String VIEW_PAGE2 = "/portlets/portfolio/portfolio_item.jsp";
    public static final String CATEGORY = "6040316";

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
    }

    public void init() throws PortletException {
        super.init();
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            String viewType;
            if (System.getProperty("DEBUG") != null) {
                System.out.println("PortfolioPortlet-> PortletMode: " + request.getPortletMode());
            }
            if ("details".equals(viewType = request.getParameter("viewType"))) {
                this.buildPortfolioItem(request, response);
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE2);
                requestDispatcher.include(request, response);
            } else {
                this.buildPortfolioList(request, response);
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE1);
                requestDispatcher.include(request, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Exception in PortfolioPortlet");
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
    }

    private void buildPortfolioItem(RenderRequest request, RenderResponse response) throws Exception {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        PagedListInfo portfolioItemListInfo = PortletUtils.getPagedListInfo((PortletRequest)request, response, "portfolioItemListInfo");
        portfolioItemListInfo.setMode(2);
        portfolioItemListInfo.setCurrentOffset(request.getParameter("offset"));
        HashMap<String, String[]> renderParams = new HashMap<String, String[]>();
        renderParams.put("viewType", new String[]{"details"});
        renderParams.put("itemId", new String[]{request.getParameter("itemId")});
        renderParams.put("categoryId", new String[]{request.getParameter("categoryId")});
        renderParams.put("offset", new String[]{request.getParameter("offset")});
        portfolioItemListInfo.setRenderParameters(renderParams);
        PortfolioItemList portfolioItemList = new PortfolioItemList();
        portfolioItemList.setPagedListInfo(portfolioItemListInfo);
        portfolioItemList.setCategoryId(request.getParameter("categoryId"));
        portfolioItemList.setEnabledOnly(1);
        portfolioItemList.buildList(db);
        if (portfolioItemList.size() > 0) {
            request.setAttribute("portfolioItem", (Object)((PortfolioItem)((Object)portfolioItemList.get(0))));
        }
    }

    private void buildPortfolioList(RenderRequest request, RenderResponse response) throws Exception {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        String preferredCategoryId = request.getPreferences().getValue(CATEGORY, "-1");
        request.setAttribute("preferredCategoryId", (Object)preferredCategoryId);
        PortfolioCategoryList portfolioCategoryList = new PortfolioCategoryList();
        portfolioCategoryList.setParentId(preferredCategoryId);
        if (StringUtils.hasText(request.getParameter("categoryId"))) {
            portfolioCategoryList.setParentId(request.getParameter("categoryId"));
        }
        portfolioCategoryList.setEnabledOnly(1);
        portfolioCategoryList.buildList(db);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("PortfolioPortlet.doView() + portfolioCategoryList.size()  ==> " + portfolioCategoryList.size());
        }
        request.setAttribute("portfolioCategoryList", (Object)portfolioCategoryList);
        PortfolioCategory parentCategory = null;
        parentCategory = portfolioCategoryList.getParentId() != -1 ? new PortfolioCategory(db, portfolioCategoryList.getParentId()) : new PortfolioCategory();
        request.setAttribute("parentCategory", (Object)parentCategory);
        PagedListInfo portfolioItemListInfo = PortletUtils.getPagedListInfo((PortletRequest)request, response, "portfolioItemListInfo");
        portfolioItemListInfo.setMode(1);
        HashMap<String, String[]> renderParams = new HashMap<String, String[]>();
        renderParams.put("viewType", new String[]{"list"});
        renderParams.put("categoryId", new String[]{String.valueOf(portfolioCategoryList.getParentId())});
        portfolioItemListInfo.setRenderParameters(renderParams);
        PortfolioItemList portfolioItemList = new PortfolioItemList();
        portfolioItemList.setPagedListInfo(portfolioItemListInfo);
        portfolioItemList.setCategoryId(preferredCategoryId);
        if (StringUtils.hasText(request.getParameter("categoryId"))) {
            portfolioItemList.setCategoryId(request.getParameter("categoryId"));
        }
        portfolioItemList.buildList(db);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("PortfolioPortlet.doView() + portfolioItemList.size()  ==> " + portfolioItemList.size());
        }
        request.setAttribute("portfolioItemList", (Object)portfolioItemList);
    }
}

