/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.icelet;

import com.zeroio.iteam.base.FileItem;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogList;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.modules.products.base.ProductCategoryList;
import org.aspcfs.modules.products.base.ProductEmailFormatter;
import org.aspcfs.modules.quotes.base.QuoteProductBean;
import org.aspcfs.modules.website.base.WebProductAccessLog;
import org.aspcfs.modules.website.utils.PortletUtils;
import org.aspcfs.servlets.url.base.URLMap;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ProductCatalogPortlet
extends GenericPortlet {
    private static final String VIEW_PAGE1 = "/portlets/products/products_summary.jsp";
    private static final String VIEW_PAGE2 = "/portlets/products/product.jsp";
    private static final String VIEW_PAGE3 = "/portlets/products/products_search.jsp";
    private static final String VIEW_PAGE4 = "/portlets/products/products_summary.jsp";
    private static final String VIEW_PAGE5 = "/portlets/products/product_does_not_exist.jsp";
    public static final String CATEGORY = "6050816";
    public static final String SHOW_SKU = "6051001";
    public static final String ADD_QUOTE = "6062310";
    public static final String SKU_TEXT = "6051002";
    public static final String SHOW_PRICE = "6051003";
    public static final String PRICE_TEXT = "6051004";
    public static final String SHOW_PRICE_SAVINGS = "6051005";
    public static final String ORIGINAL_PRICE_TEXT = "6051007";
    public static final String PRICE_SAVINGS_TEXT = "6051006";
    public static final String PRODUCT_SEARCH = "6060610";
    public static final String PRODUCT_SEARCH_AS_DEFAULT = "6060611";
    public static final String ADDED_TO_QUOTE_MESSAGE = "6071315";
    public static final String INCLUDE_EMAIL = "6060717";
    public static final String SITE_URL = "6060718";
    public static final String EMAIL_SUBJECT = "6060719";
    public static final String EMAIL_BODY = "6071316";
    public static final String fs = System.getProperty("file.separator");

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
    }

    public void init() throws PortletException {
        super.init();
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ProductCatalogPortlet-> PortletMode: " + request.getPortletMode());
            }
            String viewType = request.getParameter("viewType");
            boolean isSearchAsDefault = DatabaseUtils.parseBoolean(request.getPreferences().getValue(PRODUCT_SEARCH_AS_DEFAULT, "false"));
            request.setAttribute("SHOW_PRICE", (Object)request.getPreferences().getValue(SHOW_PRICE, "true"));
            if ("details".equals(viewType)) {
                boolean productExists = this.buildProduct(request, response);
                if (productExists) {
                    PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE2);
                    requestDispatcher.include(request, response);
                } else {
                    PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE5);
                    requestDispatcher.include(request, response);
                }
            } else if ("summary".equals(viewType)) {
                this.buildProductCategoryList(request, response);
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher("/portlets/products/products_summary.jsp");
                requestDispatcher.include(request, response);
            } else if ("searchResult".equals(viewType)) {
                this.buildSearchResult(request, response);
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher("/portlets/products/products_summary.jsp");
                requestDispatcher.include(request, response);
            } else if ("search".equals(viewType) || isSearchAsDefault && viewType == null) {
                this.buildSearch(request, response);
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher(VIEW_PAGE3);
                requestDispatcher.include(request, response);
            } else {
                this.buildProductCategoryList(request, response);
                PortletRequestDispatcher requestDispatcher = this.getPortletContext().getRequestDispatcher("/portlets/products/products_summary.jsp");
                requestDispatcher.include(request, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Exception in ProductCatalogPortlet");
        }
    }

    private void buildSearch(RenderRequest request, RenderResponse response) {
        ProductCategory productCategory = new ProductCategory();
        PagedListInfo productCatalogListInfo = PortletUtils.getPagedListInfo((PortletRequest)request, response, "productCatalogListInfo");
        String timeZone = PortletUtils.getApplicationPrefs((PortletRequest)request, "SYSTEM.TIMEZONE");
        String preferredCategoryId = request.getPreferences().getValue(CATEGORY, "-1");
        productCategory.setId(preferredCategoryId);
        request.setAttribute("productCategory", (Object)productCategory);
        request.setAttribute("searchProductCatalogListInfo", (Object)productCatalogListInfo);
        request.setAttribute("searchcodeGroupKeywords", (Object)productCatalogListInfo.getSearchOptionValue("searchcodeGroupKeywords"));
        request.setAttribute("searchSku", (Object)productCatalogListInfo.getSearchOptionValue("searchSku"));
        request.setAttribute("searchcodePriceRangeMin", (Object)productCatalogListInfo.getSearchOptionValue("searchcodePriceRangeMin"));
        request.setAttribute("searchcodePriceRangeMax", (Object)productCatalogListInfo.getSearchOptionValue("searchcodePriceRangeMax"));
        request.setAttribute("searchCategoryListIds", (Object)productCatalogListInfo.getSearchOptionValue("searchCategoryListIds"));
        request.setAttribute("searchCategoryNames", (Object)productCatalogListInfo.getSearchOptionValue("searchCategoryNames"));
        request.setAttribute("searchcodeDateAfter", (Object)productCatalogListInfo.getSearchOptionValue("searchcodeDateAfter"));
        request.setAttribute("searchItems", (Object)Integer.toString(productCatalogListInfo.getItemsPerPage()));
        request.setAttribute("timeZone", (Object)timeZone);
        request.getPortletSession().removeAttribute("productCatalogListInfo");
    }

    private void prepare(RenderRequest request, RenderResponse response) throws Exception {
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String action = request.getParameter("actionType");
        if ("search".equals(action)) {
            try {
                this.prepareSearchResult(request, response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            response.setRenderParameter("viewType", "searchResult");
        }
        if ("sendEmail".equals(action)) {
            try {
                this.sendEmail(request, response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            response.setRenderParameter("viewType", "details");
            response.setRenderParameter("productId", request.getParameter("productId"));
            response.setRenderParameter("categoryId", request.getParameter("categoryId"));
            response.setRenderParameter("page", request.getParameter("page"));
            response.setRenderParameter("offset", request.getParameter("offset"));
            response.setRenderParameter("searchResults", request.getParameter("searchResults"));
        }
        if ("quote".equals(action)) {
            try {
                this.addQuote(request, response);
                response.setRenderParameter("viewType", "details");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addQuote(ActionRequest request, ActionResponse response) throws NumberFormatException, SQLException {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        String productId = request.getParameter("forwardproductId");
        HashMap quotes = new HashMap();
        QuoteProductBean quote = new QuoteProductBean();
        if (((HttpServletRequest)request).getSession().getAttribute("CartBean") != null) {
            quotes = (HashMap)((HttpServletRequest)request).getSession().getAttribute("CartBean");
        }
        if (productId != null) {
            ProductCatalog productCatalog = new ProductCatalog(db, Integer.parseInt(productId));
            quote.setProduct(productCatalog);
            quote.setQuantity(1);
            quotes.put(productId, quote);
        }
        ((HttpServletRequest)request).getSession().setAttribute("CartBean", (Object)quotes);
        this.forwardParameters(request, response);
    }

    private void forwardParameters(ActionRequest request, ActionResponse response) {
        HashMap parameters = (HashMap)request.getParameterMap();
        for (String tempKey : parameters.keySet()) {
            if (!tempKey.startsWith("forward")) continue;
            response.setRenderParameter(tempKey.substring(7), request.getParameter(tempKey));
        }
    }

    private boolean buildProduct(RenderRequest request, RenderResponse response) throws Exception {
        request.setAttribute("SHOW_SKU", (Object)request.getPreferences().getValue(SHOW_SKU, "true"));
        request.setAttribute("SKU_TEXT", (Object)request.getPreferences().getValue(SKU_TEXT, "Item #"));
        request.setAttribute("PRICE_TEXT", (Object)request.getPreferences().getValue(PRICE_TEXT, ""));
        request.setAttribute("SHOW_PRICE_SAVINGS", (Object)request.getPreferences().getValue(SHOW_PRICE_SAVINGS, "true"));
        request.setAttribute("ORIGINAL_PRICE_TEXT", (Object)request.getPreferences().getValue(ORIGINAL_PRICE_TEXT, "Original Price:"));
        request.setAttribute("PRICE_SAVINGS_TEXT", (Object)request.getPreferences().getValue(PRICE_SAVINGS_TEXT, "Instant Savings:"));
        request.setAttribute("PRODUCT_SEARCH", (Object)request.getPreferences().getValue(PRODUCT_SEARCH, "false"));
        request.setAttribute("INCLUDE_EMAIL", (Object)request.getPreferences().getValue(INCLUDE_EMAIL, "false"));
        request.setAttribute("ADD_QUOTE", (Object)request.getPreferences().getValue(ADD_QUOTE, "false"));
        request.setAttribute("EMAIL_SUBJECT", (Object)request.getPreferences().getValue(EMAIL_SUBJECT, "A product from our catalog"));
        request.setAttribute("ADDED_TO_QUOTE_MESSAGE", (Object)request.getPreferences().getValue(ADDED_TO_QUOTE_MESSAGE, "This product has been added to the quote."));
        StringBuffer completeProductURL = new StringBuffer();
        completeProductURL.append(((HttpServletRequest)request).getRequestURL());
        if (((HttpServletRequest)request).getQueryString() != null) {
            completeProductURL.append("?");
            completeProductURL.append(((HttpServletRequest)request).getQueryString());
            if (((HttpServletRequest)request).getQueryString().indexOf("&reset=true") == -1) {
                completeProductURL.append("&reset=true");
            }
        }
        request.setAttribute("productURL", (Object)completeProductURL.toString());
        if (((HttpServletRequest)request).getQueryString().indexOf("&reset=true") > -1) {
            request.getPortletSession().removeAttribute("productCatalogListInfo");
        }
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        boolean checkProductId = false;
        PagedListInfo tmpInfo = (PagedListInfo)request.getPortletSession().getAttribute("productCatalogListInfo");
        if (tmpInfo == null || tmpInfo.getId() == null) {
            checkProductId = true;
        }
        PagedListInfo productCatalogListInfo = PortletUtils.getPagedListInfo((PortletRequest)request, response, "productCatalogListInfo", false);
        String offset = request.getParameter("offset");
        ProductCatalogList productCatalogList = new ProductCatalogList();
        if (checkProductId) {
            productCatalogList.setId(request.getParameter("productId"));
        }
        productCatalogListInfo.setMode(2);
        productCatalogListInfo.setCurrentOffset(offset);
        HashMap<String, String[]> renderParams = new HashMap<String, String[]>();
        renderParams.put("viewType", new String[]{"details"});
        renderParams.put("productId", new String[]{request.getParameter("productId")});
        renderParams.put("categoryId", new String[]{request.getParameter("categoryId")});
        renderParams.put("offset", new String[]{offset});
        renderParams.put("page", new String[]{request.getParameter("page")});
        renderParams.put("searchResults", new String[]{request.getParameter("searchResults")});
        request.setAttribute("searchResults", (Object)request.getParameter("searchResults"));
        request.setAttribute("page", (Object)request.getParameter("page"));
        request.setAttribute("offset", (Object)offset);
        request.setAttribute("parentOffset", (Object)request.getParameter("parentOffset"));
        productCatalogListInfo.setRenderParameters(renderParams);
        String preferredCategoryId = request.getPreferences().getValue(CATEGORY, "-1");
        request.setAttribute("preferredCategoryId", (Object)preferredCategoryId);
        if ("true".equals(request.getAttribute("SHOW_PRICE"))) {
            productCatalogList.setBuildActivePrice(true);
        }
        if (!"true".equals(request.getParameter("searchResults"))) {
            productCatalogList.setCategoryId(request.getParameter("categoryId"));
            if (productCatalogList.getCategoryId() == -1) {
                productCatalogList.setHasCategories(0);
            }
        } else {
            ProductCategoryList productCategoryList = new ProductCategoryList();
            String searchCategoryListIds = productCatalogListInfo.getSearchOptionValue("searchCategoryListIds");
            productCategoryList = searchCategoryListIds.equals("") || searchCategoryListIds == null ? productCategoryList.buildListFromIds(db, preferredCategoryId) : productCategoryList.buildListFromIds(db, searchCategoryListIds);
            ProductCategoryList.buildHierarchy(db, productCategoryList);
            productCategoryList.buildCompleteHierarchy();
            productCatalogListInfo.setSearchCriteria(productCatalogList, (HttpServletRequest)request, PortletUtils.getSystemStatus((PortletRequest)request), null);
            productCatalogList.setProductCategoryList(productCategoryList);
            if (productCatalogList.getCategoryId() == -1) {
                productCatalogList.setHasCategories(-1);
            }
        }
        productCatalogList.setPagedListInfo(productCatalogListInfo);
        productCatalogList.buildList(db);
        request.setAttribute("productCatalogList", (Object)productCatalogList);
        ProductCatalog productCatalog = null;
        if (productCatalogList.size() > 0) {
            productCatalog = (ProductCatalog)((Object)productCatalogList.get(0));
            if (checkProductId && productCatalog.getId() != Integer.parseInt(request.getParameter("productId"))) {
                return false;
            }
            request.setAttribute("productCatalog", (Object)productCatalog);
        }
        ProductCategory parentCategory = null;
        parentCategory = Integer.parseInt(request.getParameter("categoryId")) != -1 ? new ProductCategory(db, Integer.parseInt(request.getParameter("categoryId"))) : new ProductCategory();
        request.setAttribute("parentCategory", (Object)parentCategory);
        request.setAttribute("previousPage", request.getPortletSession().getAttribute("previousPage"));
        UserBean userBean = PortletUtils.getUser((PortletRequest)request);
        if (productCatalog != null && userBean.getUserId() == -2) {
            WebProductAccessLog webProductAccessLog = new WebProductAccessLog();
            webProductAccessLog.setSiteLogId(Integer.parseInt(userBean.getSessionId()));
            webProductAccessLog.setProductId(productCatalog.getId());
            PortletUtils.addLogItem((PortletRequest)request, "webProductAccessLog", (Object)webProductAccessLog);
        }
        return true;
    }

    private void buildProductCategoryList(RenderRequest request, RenderResponse response) throws Exception {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        String preferredCategoryId = request.getPreferences().getValue(CATEGORY, "-1");
        request.setAttribute("preferredCategoryId", (Object)preferredCategoryId);
        ProductCategoryList productCategoryList = new ProductCategoryList();
        productCategoryList.setParentId(preferredCategoryId);
        if (StringUtils.hasText(request.getParameter("categoryId"))) {
            productCategoryList.setParentId(request.getParameter("categoryId"));
        }
        if (productCategoryList.getParentId() == -1) {
            productCategoryList.setTopOnly(1);
        }
        productCategoryList.buildList(db);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ProductCatalogPortlet.doView() + productCategoryList.size()  ==> " + productCategoryList.size());
        }
        request.setAttribute("productCategoryList", (Object)productCategoryList);
        ProductCategory parentCategory = null;
        parentCategory = productCategoryList.getParentId() != -1 ? new ProductCategory(db, productCategoryList.getParentId()) : new ProductCategory();
        request.setAttribute("parentCategory", (Object)parentCategory);
        this.setProductCatalogOffset(String.valueOf(parentCategory.getId()), request.getParameter("parentOffset"), request.getPortletSession());
        PagedListInfo productCatalogListInfo = PortletUtils.getPagedListInfo((PortletRequest)request, response, "productCatalogListInfo");
        productCatalogListInfo.setMode(1);
        HashMap<String, String[]> renderParams = new HashMap<String, String[]>();
        renderParams.put("viewType", new String[]{"list"});
        renderParams.put("categoryId", new String[]{String.valueOf(productCategoryList.getParentId())});
        productCatalogListInfo.setRenderParameters(renderParams);
        ProductCatalogList productCatalogList = new ProductCatalogList();
        productCatalogList.setPagedListInfo(productCatalogListInfo);
        productCatalogList.setCategoryId(preferredCategoryId);
        if (StringUtils.hasText(request.getParameter("categoryId"))) {
            productCatalogList.setCategoryId(request.getParameter("categoryId"));
        }
        if (productCatalogList.getCategoryId() == -1) {
            productCatalogList.setHasCategories(0);
        }
        if ("true".equals(request.getAttribute("SHOW_PRICE"))) {
            productCatalogList.setBuildActivePrice(true);
        }
        productCatalogList.buildList(db);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ProductCatalogPortlet.doView() + productCatalogList.size()  ==> " + productCatalogList.size());
        }
        request.getPortletSession().setAttribute("previousPage", (Object)"summary");
        request.setAttribute("parentOffset", (Object)this.getProductCatalogOffset(request.getParameter("categoryId"), request.getPortletSession()));
        request.setAttribute("productCatalogList", (Object)productCatalogList);
        request.setAttribute("PRODUCT_SEARCH", (Object)request.getPreferences().getValue(PRODUCT_SEARCH, "false"));
    }

    private void buildSearchResult(RenderRequest request, RenderResponse response) throws Exception {
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        String preferredCategoryId = request.getPreferences().getValue(CATEGORY, "-1");
        PagedListInfo productCatalogListInfo = PortletUtils.getPagedListInfo((PortletRequest)request, response, "productCatalogListInfo");
        productCatalogListInfo.setMode(1);
        productCatalogListInfo.setItemsPerPage(request.getParameter("items"));
        HashMap<String, String[]> renderParams = new HashMap<String, String[]>();
        renderParams.put("viewType", new String[]{"searchResult"});
        productCatalogListInfo.setRenderParameters(renderParams);
        ProductCatalogList productCatalogList = new ProductCatalogList();
        ProductCategoryList productCategoryList = new ProductCategoryList();
        String searchCategoryListIds = productCatalogListInfo.getSearchOptionValue("searchCategoryListIds");
        productCategoryList = searchCategoryListIds.equals("") || searchCategoryListIds == null ? productCategoryList.buildListFromIds(db, preferredCategoryId) : productCategoryList.buildListFromIds(db, searchCategoryListIds);
        ProductCategoryList.buildHierarchy(db, productCategoryList);
        productCategoryList.buildCompleteHierarchy();
        productCatalogList.setProductCategoryList(productCategoryList);
        productCatalogList.setPagedListInfo(productCatalogListInfo);
        productCatalogListInfo.setSearchCriteria(productCatalogList, (HttpServletRequest)request, PortletUtils.getSystemStatus((PortletRequest)request), null);
        if (productCatalogList.getCategoryId() == -1) {
            productCatalogList.setHasCategories(-1);
        }
        if ("true".equals(request.getAttribute("SHOW_PRICE"))) {
            productCatalogList.setBuildActivePrice(true);
        }
        productCatalogList.buildList(db);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ProductCatalogPortlet.doView() + productCatalogList.size()  ==> " + productCatalogList.size());
        }
        request.getPortletSession().setAttribute("previousPage", (Object)"searchResult");
        request.setAttribute("productCatalogList", (Object)productCatalogList);
        request.setAttribute("searchResults", (Object)"true");
        request.setAttribute("PRODUCT_SEARCH", (Object)request.getPreferences().getValue(PRODUCT_SEARCH, "false"));
    }

    private void prepareSearchResult(ActionRequest request, ActionResponse response) throws Exception {
        this.forwardParameters(request, response);
        response.setRenderParameter("viewType", "searchResult");
    }

    private void sendEmail(ActionRequest request, ActionResponse response) throws Exception {
        if (System.getProperty("DEBUG") != null) {
            System.out.println(request.getParameter("yourName"));
            System.out.println(request.getParameter("yourEmailAddress"));
            System.out.println(request.getParameter("yourFriendsAddress"));
            System.out.println(request.getParameter("emailSubject"));
            System.out.println(request.getParameter("comments"));
            System.out.println(request.getParameter("productId"));
            System.out.println(request.getParameter("viewType"));
            System.out.println(PortletUtils.getApplicationPrefs((PortletRequest)request, "SYSTEM.LANGUAGE"));
            System.out.println(request.getParameter("requestURL"));
        }
        Connection db = PortletUtils.getConnection((PortletRequest)request);
        URL url = new URL(request.getParameter("productURL"));
        String friendlyURL = null;
        URLMap urlMap = new URLMap();
        urlMap.setUrl(url.getFile());
        try {
            urlMap.insert(db);
            friendlyURL = urlMap.getURLAlias();
        }
        catch (SQLException e) {
            friendlyURL = url.getFile();
        }
        friendlyURL = url.getProtocol() + "://" + PortletUtils.getApplicationPrefs((PortletRequest)request, "WEBSERVER.URL") + friendlyURL;
        ProductEmailFormatter productEmailFormatter = new ProductEmailFormatter();
        productEmailFormatter.setSiteURL(PortletUtils.getApplicationPrefs((PortletRequest)request, "WEBSERVER.URL"));
        productEmailFormatter.setProductURL(friendlyURL);
        productEmailFormatter.setFromName(request.getParameter("yourName"));
        productEmailFormatter.setShowSku(request.getPreferences().getValue(SHOW_SKU, "false"));
        productEmailFormatter.setSkuText(request.getPreferences().getValue(SKU_TEXT, "Sku:"));
        productEmailFormatter.setShowPrice(request.getPreferences().getValue(SHOW_PRICE_SAVINGS, "false"));
        productEmailFormatter.setPriceText(request.getPreferences().getValue(PRICE_TEXT, "Price:"));
        productEmailFormatter.setShowPriceSavings(request.getPreferences().getValue(SHOW_PRICE_SAVINGS, "false"));
        productEmailFormatter.setPriceSavingsText(request.getPreferences().getValue(PRICE_SAVINGS_TEXT, "Price Savings:"));
        productEmailFormatter.setOriginalPriceText(request.getPreferences().getValue(ORIGINAL_PRICE_TEXT, "Original Price:"));
        String systemLanguage = PortletUtils.getApplicationPrefs((PortletRequest)request, "SYSTEM.LANGUAGE");
        Locale locale = new Locale(systemLanguage.split("_")[0], systemLanguage.split("_")[1]);
        productEmailFormatter.setLocale(locale);
        String productId = request.getParameter("productId");
        ProductCatalog productCatalog = new ProductCatalog();
        productCatalog.setBuildPriceList(true);
        productCatalog.setBuildActivePrice(true);
        productCatalog.queryRecord(db, Integer.parseInt(productId));
        productCatalog.setComments(request.getParameter("comments"));
        FileItem imageItem = null;
        if (productCatalog.getLargeImageId() != -1) {
            imageItem = new FileItem(db, productCatalog.getLargeImageId());
        }
        SMTPMessage mail = new SMTPMessage();
        mail.setHost(PortletUtils.getApplicationPrefs((PortletRequest)request, "MAILSERVER"));
        mail.setFrom(request.getParameter("yourEmailAddress"));
        mail.setType("text/html");
        mail.setTo(request.getParameter("yourFriendsAddress"));
        if (imageItem != null) {
            imageItem.setDirectory(PortletUtils.getDbNamePath((PortletRequest)request) + "products" + fs);
            String imagePath = imageItem.getFullFilePath();
            mail.addImage("productImage", "file:///" + imagePath);
            if (System.getProperty("DEBUG") != null) {
                System.out.println(imagePath);
                File file = new File(imagePath);
                if (file.isFile()) {
                    System.out.println(" FILE EXISTS ");
                }
            }
        }
        String productInformation = productEmailFormatter.getProductInformation(productCatalog, request.getPreferences().getValue(EMAIL_BODY, ""));
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ProductCatalogPortlet-> Product Information: " + productInformation);
        }
        mail.setSubject(request.getPreferences().getValue(EMAIL_SUBJECT, request.getParameter("emailSubject")));
        mail.setBody(productInformation);
        int mailReturn = mail.send();
        if (mailReturn == 2) {
            System.err.println(mail.getErrorMsg());
        }
    }

    private void setProductCatalogOffset(String categogoryId, String offset, PortletSession portletSession) {
        HashMap catalogOffset = portletSession.getAttribute("ProductCatalogOffset") != null ? (HashMap)portletSession.getAttribute("ProductCatalogOffset") : new HashMap();
        catalogOffset.put(categogoryId, offset);
        portletSession.setAttribute("ProductCatalogOffset", (Object)catalogOffset);
    }

    private String getProductCatalogOffset(String categogoryId, PortletSession portletSession) {
        if (portletSession.getAttribute("ProductCatalogOffset") == null) {
            return "0";
        }
        HashMap catalogOffset = (HashMap)portletSession.getAttribute("ProductCatalogOffset");
        if (catalogOffset.containsKey(categogoryId)) {
            return (String)catalogOffset.get(categogoryId);
        }
        return "0";
    }
}

