/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.utils;

import com.darkhorseventures.database.ConnectionElement;
import java.io.IOException;
import java.sql.Connection;
import java.util.Vector;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.utils.web.PagedListInfo;
import org.quartz.Scheduler;

public class PortletUtils {
    public static final String fs = System.getProperty("file.separator");

    public static Connection getConnection(PortletRequest request) {
        return (Connection)request.getAttribute("connection");
    }

    public static synchronized boolean addLogItem(PortletRequest request, String type, Object item) throws IOException {
        if (item == null) {
            return false;
        }
        Scheduler scheduler = (Scheduler)request.getAttribute("scheduler");
        try {
            ((Vector)scheduler.getContext().get((Object)type)).add(item);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("PortletUtils-> Scheduler failed: " + e.getMessage());
        }
        return true;
    }

    public static SystemStatus getSystemStatus(PortletRequest request) {
        return (SystemStatus)request.getAttribute("systemStatus");
    }

    public static ApplicationPrefs getApplicationPrefs(PortletRequest request) {
        ApplicationPrefs prefs = (ApplicationPrefs)request.getAttribute("applicationPrefs");
        if (prefs != null) {
            return prefs;
        }
        return null;
    }

    public static String getApplicationPrefs(PortletRequest request, String param) {
        ApplicationPrefs prefs = PortletUtils.getApplicationPrefs(request);
        if (prefs != null) {
            return prefs.get(param);
        }
        return null;
    }

    public static String getDbNamePath(PortletRequest request) {
        String fileLibraryPath = PortletUtils.getApplicationPrefs(request, "FILELIBRARY");
        if (fileLibraryPath != null) {
            return fileLibraryPath + PortletUtils.getDbName(request) + fs;
        }
        return null;
    }

    public static String getDbName(PortletRequest request) {
        ConnectionElement ce = (ConnectionElement)request.getAttribute("connectionElement");
        if (ce != null) {
            return ce.getDbName();
        }
        return null;
    }

    public static PagedListInfo getPagedListInfo(PortletRequest request, RenderResponse response, String viewName) {
        return PortletUtils.getPagedListInfo(request, response, viewName, true);
    }

    public static PagedListInfo getPagedListInfo(PortletRequest request, RenderResponse response, String viewName, boolean setParams) {
        PagedListInfo tmpInfo = (PagedListInfo)request.getPortletSession().getAttribute(viewName);
        if (tmpInfo == null || tmpInfo.getId() == null) {
            tmpInfo = new PagedListInfo();
            tmpInfo.setId(viewName);
            tmpInfo.setNamespace(response.getNamespace());
            request.getPortletSession().setAttribute(viewName, (Object)tmpInfo);
        }
        if (setParams) {
            tmpInfo.setParameters((HttpServletRequest)request);
        }
        return tmpInfo;
    }

    public static UserBean getUser(PortletRequest request) {
        return (UserBean)((Object)request.getAttribute("userBean"));
    }
}

