/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.utils;

import com.zeroio.iteam.base.FileItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.website.base.IceletProperty;
import org.aspcfs.modules.website.base.IceletPropertyMap;
import org.aspcfs.modules.website.base.Layout;
import org.aspcfs.modules.website.base.Page;
import org.aspcfs.modules.website.base.PageGroup;
import org.aspcfs.modules.website.base.PageGroupList;
import org.aspcfs.modules.website.base.PageList;
import org.aspcfs.modules.website.base.PageRow;
import org.aspcfs.modules.website.base.PageRowList;
import org.aspcfs.modules.website.base.PageVersion;
import org.aspcfs.modules.website.base.PageVersionList;
import org.aspcfs.modules.website.base.RowColumn;
import org.aspcfs.modules.website.base.RowColumnList;
import org.aspcfs.modules.website.base.Site;
import org.aspcfs.modules.website.base.Style;
import org.aspcfs.modules.website.base.Tab;
import org.aspcfs.modules.website.base.TabBanner;
import org.aspcfs.modules.website.base.TabList;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SiteExporter {
    private Site site = null;
    private Layout layout = null;
    private Style style = null;
    private int imageCounter = 0;
    private ArrayList imageIds = null;
    private String fileLibraryPath = null;

    public SiteExporter() {
    }

    public SiteExporter(String tmpSiteId, String filePath, Connection db) throws Exception {
        this.imageIds = new ArrayList();
        this.readSiteFromDatabase(db, Integer.parseInt(tmpSiteId));
        Document d = this.buildXMLContent(filePath);
        String manifest = this.prepareManifest(filePath, db);
        this.preparePackage(filePath, d, manifest, db);
    }

    private void readSiteFromDatabase(Connection db, int tmpSiteId) throws Exception {
        this.site = new Site(db, tmpSiteId);
        if (this.site.getLayoutId() != -1) {
            this.layout = new Layout(db, this.site.getLayoutId());
        }
        if (this.site.getStyleId() != -1) {
            this.style = new Style(db, this.site.getStyleId());
        }
        this.site.buildTabList(db);
        for (Tab tab : this.site.getTabList()) {
            tab.buildTabBanner(db);
            tab.setMode(Site.EDIT_MODE);
            tab.buildPageGroupList(db);
            for (PageGroup pageGroup : tab.getPageGroupList()) {
                pageGroup.setMode(Site.EDIT_MODE);
                pageGroup.buildPageList(db);
                for (Page page : pageGroup.getPageList()) {
                    page.buildTabBanner(db);
                    page.buildPageVersionList(db);
                    for (PageVersion pageVersion : page.getPageVersionList()) {
                        pageVersion.setMode(Site.EDIT_MODE);
                        pageVersion.buildPageRowList(db);
                        for (PageRow pageRow : pageVersion.getPageRowList()) {
                            pageRow.buildRowColumnList(db);
                            for (RowColumn rowColumn : pageRow.getRowColumnList()) {
                                rowColumn.buildIcelet(db);
                                rowColumn.buildIceletPropertyMap(db);
                            }
                        }
                    }
                }
            }
        }
    }

    private Document buildXMLContent(String filePath) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = db.newDocument();
        Element siteElement = d.createElement("site");
        siteElement.setAttribute("name", this.site.getName());
        siteElement.setAttribute("enabled", String.valueOf(this.site.getEnabled()));
        Element siteInternalDescriptionElement = d.createElement("internalDescription");
        if (this.site.getInternalDescription() != null) {
            siteInternalDescriptionElement.appendChild(d.createTextNode(XMLUtils.toXMLValue(this.site.getInternalDescription())));
        }
        siteElement.appendChild(siteInternalDescriptionElement);
        TabList tabList = this.site.getTabList();
        for (Tab tab : tabList) {
            Element tabElement = d.createElement("tab");
            tabElement.setAttribute("displayText", tab.getDisplayText());
            tabElement.setAttribute("enabled", String.valueOf(tab.getEnabled()));
            Element tabInternalDescriptionElement = d.createElement("internalDescription");
            if (tab.getInternalDescription() != null) {
                tabInternalDescriptionElement.appendChild(d.createTextNode(XMLUtils.toXMLValue(tab.getInternalDescription())));
            }
            tabElement.appendChild(tabInternalDescriptionElement);
            TabBanner tabBannerForTab = tab.getTabBanner();
            Element tabBannerForTabElement = d.createElement("tabBanner");
            tabElement.appendChild(tabBannerForTabElement);
            PageGroupList pageGroupList = tab.getPageGroupList();
            for (PageGroup pageGroup : pageGroupList) {
                Element pageGroupElement = d.createElement("pageGroup");
                pageGroupElement.setAttribute("name", XMLUtils.toXMLValue(pageGroup.getName()));
                Element pageGroupInternalDescriptionElement = d.createElement("internalDescription");
                if (pageGroup.getInternalDescription() != null) {
                    pageGroupInternalDescriptionElement.appendChild(d.createTextNode(XMLUtils.toXMLValue(pageGroup.getInternalDescription())));
                }
                pageGroupElement.appendChild(pageGroupInternalDescriptionElement);
                PageList pageList = pageGroup.getPageList();
                for (Page page : pageList) {
                    Element pageElement = d.createElement("page");
                    pageElement.setAttribute("name", XMLUtils.toXMLValue(page.getName()));
                    pageElement.setAttribute("enabled", String.valueOf(page.getEnabled()));
                    TabBanner tabBannerForPage = page.getTabBanner();
                    Element tabBannerForPageElement = d.createElement("tabBanner");
                    pageElement.appendChild(tabBannerForPageElement);
                    PageVersionList pageVersionList = page.getPageVersionList();
                    for (PageVersion pageVersion : pageVersionList) {
                        Element pageVersionElement = d.createElement("pageVersion");
                        if (pageVersion.getVersionNumber() != -1) {
                            pageVersionElement.setAttribute("versionNumber", String.valueOf(pageVersion.getVersionNumber()));
                        } else {
                            pageVersionElement.setAttribute("versionNumber", "");
                        }
                        StringBuffer type = new StringBuffer();
                        boolean isActive = false;
                        if (page.getActivePageVersionId() == pageVersion.getId()) {
                            type.append("active");
                            isActive = true;
                        }
                        if (page.getConstructionPageVersionId() == pageVersion.getId()) {
                            if (isActive) {
                                type.append(",");
                            }
                            type.append("construction");
                        }
                        pageVersionElement.setAttribute("type", type.toString());
                        Element pageVersionInternalDescriptionElement = d.createElement("internalDescription");
                        if (pageVersion.getInternalDescription() != null) {
                            pageVersionInternalDescriptionElement.appendChild(d.createTextNode(XMLUtils.toXMLValue(pageVersion.getInternalDescription())));
                        }
                        pageVersionElement.appendChild(pageVersionInternalDescriptionElement);
                        Element pageVersionNotesElement = d.createElement("notes");
                        if (pageVersion.getNotes() != null) {
                            pageVersionNotesElement.appendChild(d.createTextNode(XMLUtils.toXMLValue(pageVersion.getNotes())));
                        }
                        pageVersionElement.appendChild(pageVersionNotesElement);
                        PageRowList pageRowList = pageVersion.getPageRowList();
                        for (PageRow pageRow : pageRowList) {
                            Element pageRowElement = d.createElement("row");
                            pageRowElement.setAttribute("enabled", String.valueOf(pageRow.getEnabled()));
                            RowColumnList rowColumnList = pageRow.getRowColumnList();
                            for (RowColumn rowColumn : rowColumnList) {
                                Element rowColumnElement = d.createElement("column");
                                rowColumnElement.setAttribute("enabled", String.valueOf(rowColumn.getEnabled()));
                                if (rowColumn.getWidth() != -1) {
                                    rowColumnElement.setAttribute("width", String.valueOf(rowColumn.getWidth()));
                                } else {
                                    rowColumnElement.setAttribute("width", "");
                                }
                                if (rowColumn.getIcelet() != null) {
                                    rowColumnElement.setAttribute("iceletClass", XMLUtils.toXMLValue(rowColumn.getIcelet().getConfiguratorClass()));
                                } else {
                                    rowColumnElement.setAttribute("iceletClass", "");
                                }
                                IceletPropertyMap iceletPropertyMap = rowColumn.getIceletPropertyMap();
                                Set iceletPropertySet = iceletPropertyMap.keySet();
                                for (Integer key : iceletPropertySet) {
                                    String tmpPropertyValue;
                                    IceletProperty iceletProperty = (IceletProperty)((Object)iceletPropertyMap.get(key));
                                    Element propertyElement = d.createElement("property");
                                    propertyElement.setAttribute("constant", String.valueOf(iceletProperty.getTypeConstant()));
                                    String valueToStore = tmpPropertyValue = StringUtils.replace(iceletProperty.getValue(), "&", "&amp;");
                                    if (iceletProperty.getValue().indexOf("<img") != -1) {
                                        valueToStore = this.replaceTags(tmpPropertyValue);
                                    }
                                    propertyElement.appendChild(d.createTextNode(XMLUtils.toXMLValue(valueToStore)));
                                    rowColumnElement.appendChild(propertyElement);
                                }
                                pageRowElement.appendChild(rowColumnElement);
                            }
                            pageVersionElement.appendChild(pageRowElement);
                        }
                        pageElement.appendChild(pageVersionElement);
                    }
                    pageGroupElement.appendChild(pageElement);
                }
                tabElement.appendChild(pageGroupElement);
            }
            siteElement.appendChild(tabElement);
        }
        d.appendChild(siteElement);
        return d;
    }

    private String prepareManifest(String filePath, Connection db) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Manifest-Version: 1");
        Organization myOrg = new Organization(db, 0);
        stringBuffer.append("\nCreated-By: " + myOrg.getName());
        stringBuffer.append("\nDescription: " + this.site.getName());
        Timestamp timestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        stringBuffer.append("\nCreated: " + timestamp.toString());
        stringBuffer.append("\nModified: " + timestamp.toString());
        stringBuffer.append("\nLayout: " + this.layout.getName());
        stringBuffer.append("\nStyle: " + this.style.getName());
        return stringBuffer.toString();
    }

    private void preparePackage(String filePath, Document d, String manifest, Connection db) throws Exception {
        String fs = System.getProperty("file.separator");
        Random generator = new Random(Calendar.getInstance().getTimeInMillis());
        int directory = generator.nextInt(100000) + 1;
        String tmpFilePath = filePath + fs + directory + fs + "website";
        String tmpParentFilePath = filePath + fs + directory;
        String resourcesPath = tmpFilePath + fs + "resources";
        String imagesPath = resourcesPath + fs + "images";
        String layoutPath = resourcesPath + fs + "layout";
        String stylePath = resourcesPath + fs + "style";
        boolean success = new File(tmpFilePath).mkdirs();
        if (success && (success = new File(resourcesPath).mkdir()) && (success = new File(imagesPath).mkdir()) && (success = new File(layoutPath).mkdir())) {
            success = new File(stylePath).mkdir();
        }
        if (!success) {
            throw new Exception("Could not create package");
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(new File(tmpFilePath + fs + "content.xml"));
        DOMSource source = new DOMSource(d);
        transformer.transform(source, result);
        BufferedWriter out = new BufferedWriter(new FileWriter(tmpFilePath + fs + "MANIFEST.MF"));
        out.write(manifest);
        out.close();
        String sourceLayoutPath = filePath + fs + "layout_" + this.layout.getId() + ".jsp";
        FileUtils.copyFile(new File(sourceLayoutPath), new File(layoutPath + fs + "layout.jsp"), true);
        String sourceLayoutThumbnailPath = filePath + fs + "images" + fs + "layout_" + this.layout.getId() + ".jpg";
        FileUtils.copyFile(new File(sourceLayoutThumbnailPath), new File(layoutPath + fs + "layout.jpg"), true);
        String sourceStylePath = filePath + fs + "css" + fs + "style_" + this.style.getId() + ".css";
        FileUtils.copyFile(new File(sourceStylePath), new File(stylePath + fs + "style.css"), true);
        String sourceStyleThumbnailPath = filePath + fs + "images" + fs + "style_" + this.style.getId() + ".jpg";
        FileUtils.copyFile(new File(sourceStyleThumbnailPath), new File(stylePath + fs + "style.jpg"), true);
        if (this.imageIds.size() > 0) {
            Iterator imageIdIterator = this.imageIds.iterator();
            int tmpCounter = 0;
            while (imageIdIterator.hasNext()) {
                int imageId = Integer.parseInt((String)imageIdIterator.next());
                FileItem fileItem = new FileItem(db, imageId, 45, 1);
                if (this.fileLibraryPath == null) {
                    this.fileLibraryPath = filePath + "/WEB-INF/fileLibrary/cdb_actionplans/accounts/";
                }
                String sourceCompleteImagefilePath = this.fileLibraryPath + DateUtils.getDatePath(fileItem.getModified()) + fileItem.getFilename();
                String extension = "";
                if (fileItem.getClientFilename().indexOf(".") != -1) {
                    extension = fileItem.getClientFilename().substring(fileItem.getClientFilename().indexOf("."));
                }
                String imageFilePath = imagesPath + fs + tmpCounter + extension;
                FileUtils.copyFile(new File(sourceCompleteImagefilePath), new File(imageFilePath), true);
                ++tmpCounter;
            }
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(filePath + fs + "website.zip"));
        zipOutputStream.setLevel(-1);
        this.zipAllFiles(new File(tmpFilePath), zipOutputStream);
        zipOutputStream.close();
        FileUtils.deleteDirectory(new File(tmpParentFilePath));
    }

    private void zipAllFiles(File dir, ZipOutputStream out) throws Exception {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                this.zipAllFiles(new File(dir, children[i]), out);
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(dir);
            byte[] buffer = new byte[in.available()];
            String dirPath = dir.getPath();
            String pathInZip = "";
            String[] paths = dir.getPath().split("website");
            if (paths.length != 2) {
                throw new Exception("Could not create package");
            }
            pathInZip = "website" + paths[1];
            out.putNextEntry(new ZipEntry(pathInZip));
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.closeEntry();
            in.close();
        }
    }

    private String replaceTags(String htmlString) throws Exception {
        XMLUtils html = new XMLUtils(htmlString);
        Element htmlElement = html.getDocumentElement();
        this.replaceImgTags(htmlElement);
        return XMLUtils.toString(htmlElement);
    }

    private void replaceImgTags(Node node) {
        String[] srcParameters;
        Element e;
        String srcAttributeValue;
        if (node.getNodeType() == 1 && node.getNodeName().equals("img") && (srcAttributeValue = (e = (Element)node).getAttribute("src")).indexOf("id=") != -1 && (srcParameters = e.getAttribute("src").split("&")).length > 0) {
            for (String paramAndValue : srcParameters) {
                String param = paramAndValue.split("=")[0];
                if (!param.equals("id")) continue;
                String value = paramAndValue.split("=")[1];
                this.imageIds.add(value);
                e.setAttribute("src", "TEMP_" + this.imageCounter + ".jpg");
                ++this.imageCounter;
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.replaceImgTags(child);
        }
    }

    public void setFileLibraryPath(String tmp) {
        this.fileLibraryPath = tmp;
    }

    public Site getSite() {
        return this.site;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Style getStyle() {
        return this.style;
    }

    public int getImageCounter() {
        return this.imageCounter;
    }

    public ArrayList getImageIds() {
        return this.imageIds;
    }

    public String getFileLibraryPath() {
        return this.fileLibraryPath;
    }
}

