/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.website.utils;

import com.zeroio.iteam.base.FileItem;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.aspcfs.modules.website.base.IceletList;
import org.aspcfs.modules.website.base.IceletProperty;
import org.aspcfs.modules.website.base.IceletPropertyMap;
import org.aspcfs.modules.website.base.Layout;
import org.aspcfs.modules.website.base.LayoutList;
import org.aspcfs.modules.website.base.Page;
import org.aspcfs.modules.website.base.PageGroup;
import org.aspcfs.modules.website.base.PageGroupList;
import org.aspcfs.modules.website.base.PageList;
import org.aspcfs.modules.website.base.PageRow;
import org.aspcfs.modules.website.base.PageRowList;
import org.aspcfs.modules.website.base.PageVersion;
import org.aspcfs.modules.website.base.PageVersionList;
import org.aspcfs.modules.website.base.RowColumn;
import org.aspcfs.modules.website.base.RowColumnList;
import org.aspcfs.modules.website.base.Site;
import org.aspcfs.modules.website.base.Style;
import org.aspcfs.modules.website.base.StyleList;
import org.aspcfs.modules.website.base.Tab;
import org.aspcfs.modules.website.base.TabBanner;
import org.aspcfs.modules.website.base.TabBannerList;
import org.aspcfs.modules.website.base.TabList;
import org.aspcfs.modules.website.base.Template;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.XMLUtils;
import org.aspcfs.utils.ZipUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SiteImporter {
    private Site site = null;
    private Layout layout = null;
    private Style style = null;
    private String zipfilePath = null;
    private String webappPath = null;
    private String fileLibraryPath = null;
    private int userId = -1;

    public SiteImporter() {
    }

    public SiteImporter(String tmpFilePath, String tmpWebappPath, Connection db) throws Exception {
        this.userId = 0;
        this.zipfilePath = tmpFilePath;
        this.webappPath = tmpWebappPath;
        this.readWebsiteFromZIP();
        this.insertWebSite(db);
    }

    public SiteImporter(String tmpFilePath, String tmpWebappPath, Connection db, int thisUserId) throws Exception {
        this.zipfilePath = tmpFilePath;
        this.webappPath = tmpWebappPath;
        this.userId = thisUserId;
        this.readWebsiteFromZIP();
        this.insertWebSite(db);
    }

    private void readWebsiteFromZIP() throws Exception {
        this.readManifest();
        this.readContents();
    }

    private void readManifest() throws Exception {
        String fs = System.getProperty("file.separator");
        ZipFile zipFile = new ZipFile(this.zipfilePath);
        Template template = new Template(zipFile);
        this.layout = new Layout();
        if (template.hasLayout()) {
            this.layout.setConstant(template.getLayout());
            this.layout.setName(String.valueOf(template.getLayout()));
            this.layout.setCustom(false);
        } else {
            this.layout.setName("custom");
            this.layout.setJsp("standard" + fs + "layout" + fs + "layout.jsp");
            this.layout.setThumbnail(this.zipfilePath + "|website" + fs + "resources" + fs + "layout" + fs + "layout.jpg");
            this.layout.setCustom(true);
        }
        this.style = new Style();
        if (template.hasStyle()) {
            this.style.setConstant(template.getStyle());
            this.style.setName(String.valueOf(template.getStyle()));
            this.style.setCustom(false);
        } else {
            this.style.setName("custom");
            this.style.setCss("standard" + fs + "layout" + fs + "style.css");
            this.style.setThumbnail(this.zipfilePath + "|website" + fs + "resources" + fs + "style" + fs + "style.jpg");
            this.style.setCustom(true);
        }
        zipFile.close();
    }

    private void readContents() throws Exception {
        String fs = System.getProperty("file.separator");
        ZipFile zipFile = new ZipFile(this.zipfilePath);
        ZipEntry zipEntry = zipFile.getEntry("website/content.xml");
        if (zipEntry == null) {
            zipEntry = zipFile.getEntry("website\\content.xml");
        }
        InputStream xmlStream = zipFile.getInputStream(zipEntry);
        byte[] contents = new byte[xmlStream.available()];
        int numRead = 0;
        for (int offset = 0; offset < contents.length && (numRead = xmlStream.read(contents, offset, contents.length - offset)) >= 0; offset += numRead) {
        }
        xmlStream.close();
        zipFile.close();
        XMLUtils xml = new XMLUtils(new String(contents));
        this.site = new Site();
        Element siteElement = xml.getDocumentElement();
        Element siteDescriptionElement = XMLUtils.getFirstChild(siteElement, "internalDescription");
        this.site.setName(siteElement.getAttribute("name"));
        this.site.setInternalDescription(XMLUtils.getNodeText(siteDescriptionElement));
        this.site.setEnabled(siteElement.getAttribute("enabled"));
        ArrayList tabElementList = new ArrayList();
        TabList tabList = new TabList();
        XMLUtils.getAllChildren(siteElement, "tab", tabElementList);
        Iterator tabIterator = tabElementList.iterator();
        while (tabIterator.hasNext()) {
            Tab tab = new Tab();
            Element tabElement = (Element)tabIterator.next();
            Element tabDescriptionElement = XMLUtils.getFirstChild(tabElement, "internalDescription");
            tab.setDisplayText(tabElement.getAttribute("displayText"));
            tab.setInternalDescription(XMLUtils.getNodeText(tabDescriptionElement));
            tab.setEnabled(tabElement.getAttribute("enabled"));
            ArrayList tabBannerForTabElementList = new ArrayList();
            TabBannerList tabBannerForTabList = new TabBannerList();
            XMLUtils.getAllChildren(tabElement, "tabBanner", tabBannerForTabElementList);
            Iterator tabBannerForTabIterator = tabBannerForTabElementList.iterator();
            if (tabBannerForTabIterator.hasNext()) {
                TabBanner tabBanner = new TabBanner();
                Element tabBannerElement = (Element)tabBannerForTabIterator.next();
                try {
                    tabBanner.setImageId(tabBannerElement.getAttribute("image"));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                tab.setTabBanner(tabBanner);
            }
            ArrayList pageGroupElementList = new ArrayList();
            PageGroupList pageGroupList = new PageGroupList();
            XMLUtils.getAllChildren(tabElement, "pageGroup", pageGroupElementList);
            Iterator pageGroupIterator = pageGroupElementList.iterator();
            while (pageGroupIterator.hasNext()) {
                PageGroup pageGroup = new PageGroup();
                Element pageGroupElement = (Element)pageGroupIterator.next();
                Element pageGroupDescriptionElement = XMLUtils.getFirstChild(pageGroupElement, "internalDescription");
                pageGroup.setInternalDescription(XMLUtils.getNodeText(pageGroupDescriptionElement));
                ArrayList pageElementList = new ArrayList();
                PageList pageList = new PageList();
                XMLUtils.getAllChildren(pageGroupElement, "page", pageElementList);
                Iterator pageIterator = pageElementList.iterator();
                while (pageIterator.hasNext()) {
                    Page page = new Page();
                    Element pageElement = (Element)pageIterator.next();
                    page.setName(pageElement.getAttribute("name"));
                    page.setEnabled(pageElement.getAttribute("enabled"));
                    ArrayList tabBannerElementList = new ArrayList();
                    TabBannerList tabBannerList = new TabBannerList();
                    XMLUtils.getAllChildren(pageElement, "tabBanner", tabBannerElementList);
                    Iterator tabBannerIterator = tabBannerElementList.iterator();
                    if (tabBannerIterator.hasNext()) {
                        TabBanner tabBanner = new TabBanner();
                        Element tabBannerElement = (Element)tabBannerIterator.next();
                        try {
                            tabBanner.setImageId(tabBannerElement.getAttribute("image"));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        page.setTabBanner(tabBanner);
                    }
                    ArrayList pageVersionElementList = new ArrayList();
                    PageVersionList pageVersionList = new PageVersionList();
                    XMLUtils.getAllChildren(pageElement, "pageVersion", pageVersionElementList);
                    Iterator pageVersionIterator = pageVersionElementList.iterator();
                    while (pageVersionIterator.hasNext()) {
                        PageVersion pageVersion = new PageVersion();
                        Element pageVersionElement = (Element)pageVersionIterator.next();
                        Element pageVersionDescriptionElement = XMLUtils.getFirstChild(pageVersionElement, "internalDescription");
                        Element pageVersionNotesElement = XMLUtils.getFirstChild(pageVersionElement, "notes");
                        pageVersion.setVersionNumber(pageVersionElement.getAttribute("versionNumber"));
                        pageVersion.setInternalDescription(XMLUtils.getNodeText(pageVersionDescriptionElement));
                        pageVersion.setNotes(XMLUtils.getNodeText(pageVersionNotesElement));
                        String typeAttribute = pageVersionElement.getAttribute("type");
                        if (typeAttribute != null) {
                            if (typeAttribute.indexOf("active") != -1) {
                                pageVersion.setIsActive(true);
                            }
                            if (typeAttribute.indexOf("construction") != -1) {
                                pageVersion.setIsConstruction(true);
                            }
                        }
                        ArrayList pageRowElementList = new ArrayList();
                        PageRowList pageRowList = new PageRowList();
                        XMLUtils.getAllChildren(pageVersionElement, "row", pageRowElementList);
                        Iterator pageRowIterator = pageRowElementList.iterator();
                        while (pageRowIterator.hasNext()) {
                            PageRow pageRow = new PageRow();
                            Element pageRowElement = (Element)pageRowIterator.next();
                            pageRow.setEnabled(pageRowElement.getAttribute("enabled"));
                            ArrayList rowColumnElementList = new ArrayList();
                            RowColumnList rowColumnList = new RowColumnList();
                            XMLUtils.getAllChildren(pageRowElement, "column", rowColumnElementList);
                            Iterator rowColumnIterator = rowColumnElementList.iterator();
                            while (rowColumnIterator.hasNext()) {
                                RowColumn rowColumn = new RowColumn();
                                Element rowColumnElement = (Element)rowColumnIterator.next();
                                rowColumn.setEnabled(rowColumnElement.getAttribute("enabled"));
                                try {
                                    rowColumn.setWidth(rowColumnElement.getAttribute("width"));
                                }
                                catch (NumberFormatException e) {
                                    // empty catch block
                                }
                                rowColumn.setIceletConfiguratorClass(rowColumnElement.getAttribute("iceletClass"));
                                ArrayList propertyElementList = new ArrayList();
                                IceletPropertyMap iceletPropertyMap = new IceletPropertyMap();
                                XMLUtils.getAllChildren(rowColumnElement, "property", propertyElementList);
                                Iterator propertyIterator = propertyElementList.iterator();
                                while (propertyIterator.hasNext()) {
                                    IceletProperty iceletProperty = new IceletProperty();
                                    Element iceletPropertyElement = (Element)propertyIterator.next();
                                    try {
                                        iceletProperty.setTypeConstant(iceletPropertyElement.getAttribute("constant"));
                                        iceletProperty.setValue(XMLUtils.toString(XMLUtils.getNodeText(iceletPropertyElement)));
                                        iceletPropertyMap.put(new Integer(iceletProperty.getTypeConstant()), iceletProperty);
                                    }
                                    catch (NumberFormatException e) {}
                                }
                                rowColumn.setIceletPropertyMap(iceletPropertyMap);
                                rowColumnList.add(rowColumn);
                            }
                            pageRow.setRowColumnList(rowColumnList);
                            pageRowList.add(pageRow);
                        }
                        pageVersion.setPageRowList(pageRowList);
                        pageVersionList.add(pageVersion);
                    }
                    page.setPageVersionList(pageVersionList);
                    pageList.add(page);
                }
                pageGroup.setPageList(pageList);
                pageGroupList.add(pageGroup);
            }
            tab.setPageGroupList(pageGroupList);
            tabList.add(tab);
        }
        this.site.setTabList(tabList);
    }

    private void insertWebSite(Connection db) throws Exception {
        boolean autoCommit = db.getAutoCommit();
        try {
            if (autoCommit) {
                db.setAutoCommit(false);
            }
            LayoutList layoutList = new LayoutList();
            if (this.layout.getConstant() != -1) {
                layoutList.setConstant(this.layout.getConstant());
                layoutList.buildList(db);
                if (layoutList.size() > 0) {
                    this.layout = (Layout)((Object)layoutList.get(0));
                }
            } else {
                this.layout.insert(db);
            }
            StyleList styleList = new StyleList();
            if (this.style.getConstant() != -1) {
                styleList.setConstant(this.style.getConstant());
                styleList.buildList(db);
                if (styleList.size() > 0) {
                    this.style = (Style)((Object)styleList.get(0));
                }
            } else {
                this.style.setLayoutId(this.layout.getId());
                this.style.insert(db);
            }
            IceletList iceletList = new IceletList();
            iceletList.buildList(db);
            this.site.setEnteredBy(this.userId);
            this.site.setModifiedBy(this.userId);
            this.site.setLayoutId(this.layout.getId());
            this.site.setStyleId(this.style.getId());
            this.site.insert(db);
            TabList tabList = this.site.getTabList();
            Iterator tabIterator = tabList.iterator();
            int tabPosition = 0;
            while (tabIterator.hasNext()) {
                Tab tab = (Tab)((Object)tabIterator.next());
                tab.setEnteredBy(this.userId);
                tab.setModifiedBy(this.userId);
                tab.setSiteId(this.site.getId());
                tab.setPosition(tabPosition);
                tab.insert(db);
                ++tabPosition;
                TabBanner tabBannerForTab = tab.getTabBanner();
                if (tabBannerForTab != null) {
                    tabBannerForTab.setTabId(tab.getId());
                    tabBannerForTab.setEnteredBy(this.userId);
                    tabBannerForTab.setModifiedBy(this.userId);
                    tabBannerForTab.insert(db);
                }
                PageGroupList pageGroupList = tab.getPageGroupList();
                Iterator pageGroupIterator = pageGroupList.iterator();
                int pageGroupPosition = 0;
                while (pageGroupIterator.hasNext()) {
                    PageGroup pageGroup = (PageGroup)((Object)pageGroupIterator.next());
                    pageGroup.setEnteredBy(this.userId);
                    pageGroup.setModifiedBy(this.userId);
                    pageGroup.setTabId(tab.getId());
                    pageGroup.setPosition(pageGroupPosition);
                    pageGroup.insert(db);
                    ++pageGroupPosition;
                    PageList pageList = pageGroup.getPageList();
                    Iterator pageIterator = pageList.iterator();
                    int pagePosition = 0;
                    while (pageIterator.hasNext()) {
                        Page page = (Page)((Object)pageIterator.next());
                        page.setEnteredBy(this.userId);
                        page.setModifiedBy(this.userId);
                        page.setPageGroupId(pageGroup.getId());
                        page.setPosition(pagePosition);
                        ++pagePosition;
                        TabBanner tabBannerForPage = page.getTabBanner();
                        if (tabBannerForPage != null) {
                            tabBannerForPage.setTabId(tab.getId());
                            tabBannerForPage.setEnteredBy(this.userId);
                            tabBannerForPage.setModifiedBy(this.userId);
                            tabBannerForPage.setTabId(tab.getId());
                            tabBannerForPage.insert(db);
                            page.setTabBannerId(tabBannerForPage.getId());
                        }
                        page.insert(db);
                        PageVersionList pageVersionList = page.getPageVersionList();
                        Iterator pageVersionIterator = pageVersionList.iterator();
                        int parentPageVersionId = -1;
                        while (pageVersionIterator.hasNext()) {
                            PageVersion pageVersion = (PageVersion)((Object)pageVersionIterator.next());
                            pageVersion.setEnteredBy(this.userId);
                            pageVersion.setModifiedBy(this.userId);
                            pageVersion.setPageId(page.getId());
                            pageVersion.setParentPageVersionId(parentPageVersionId);
                            pageVersion.insert(db);
                            parentPageVersionId = pageVersion.getId();
                            if (pageVersion.getIsActive() || pageVersion.getIsConstruction()) {
                                if (pageVersion.getIsActive()) {
                                    page.setActivePageVersionId(pageVersion.getId());
                                }
                                if (pageVersion.getIsConstruction()) {
                                    page.setConstructionPageVersionId(pageVersion.getId());
                                    if (page.getActivePageVersionId() == -1) {
                                        page.setActivePageVersionId(pageVersion.getId());
                                    }
                                }
                            }
                            page.setOverride(true);
                            page.update(db);
                            PageRowList pageRowList = pageVersion.getPageRowList();
                            Iterator pageRowIterator = pageRowList.iterator();
                            int pageRowPosition = 0;
                            while (pageRowIterator.hasNext()) {
                                PageRow pageRow = (PageRow)((Object)pageRowIterator.next());
                                pageRow.setEnteredBy(this.userId);
                                pageRow.setModifiedBy(this.userId);
                                pageRow.setPageVersionId(pageVersion.getId());
                                pageRow.setPosition(pageRowPosition);
                                pageRow.insert(db);
                                ++pageRowPosition;
                                RowColumnList rowColumnList = pageRow.getRowColumnList();
                                Iterator rowColumnIterator = rowColumnList.iterator();
                                int rowColumnPosition = 0;
                                while (rowColumnIterator.hasNext()) {
                                    RowColumn rowColumn = (RowColumn)((Object)rowColumnIterator.next());
                                    rowColumn.setEnteredBy(this.userId);
                                    rowColumn.setModifiedBy(this.userId);
                                    rowColumn.setPageRowId(pageRow.getId());
                                    rowColumn.setPosition(rowColumnPosition);
                                    rowColumn.setIceletId(iceletList.getIdFromConfiguratorClass(rowColumn.getIceletConfiguratorClass()));
                                    rowColumn.insert(db);
                                    ++rowColumnPosition;
                                    IceletPropertyMap iceletPropertyMap = rowColumn.getIceletPropertyMap();
                                    Set iceletPropertySet = iceletPropertyMap.keySet();
                                    for (Integer key : iceletPropertySet) {
                                        IceletProperty iceletProperty = (IceletProperty)((Object)iceletPropertyMap.get(key));
                                        if (iceletProperty.getValue().indexOf("<img") != -1) {
                                            iceletProperty.setValue(this.replaceTags(iceletProperty.getValue(), pageRow.getId(), db));
                                        }
                                        iceletProperty.setEnteredBy(this.userId);
                                        iceletProperty.setModifiedBy(this.userId);
                                        iceletProperty.setRowColumnId(rowColumn.getId());
                                        iceletProperty.insert(db);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (autoCommit) {
                db.commit();
            }
        }
        catch (Exception e) {
            if (autoCommit) {
                db.rollback();
            }
            throw new Exception("SiteImporter-> Error: " + e.getMessage());
        }
        finally {
            if (autoCommit) {
                db.setAutoCommit(true);
            }
        }
    }

    private void copyLayoutAndStyle(Connection db) throws Exception {
        String zipEntry;
        ZipFile zipFile = new ZipFile(this.zipfilePath);
        String fs = System.getProperty("file.separator");
        String layoutDestinationPath = this.webappPath + fs + "layout_" + this.layout.getId() + ".jsp";
        String layoutThumbnailDestinationPath = this.webappPath + fs + "images" + fs + "layout_" + this.layout.getId() + ".jpg";
        String styleDestinationPath = this.webappPath + fs + "css" + fs + "style_" + this.style.getId() + ".css";
        String styleThumbnailDestinationPath = this.webappPath + fs + "images" + fs + "style_" + this.style.getId() + ".jpg";
        if (this.layout.getConstant() == -1) {
            zipEntry = "website/resources/layout/layout.jsp";
            ZipUtils.extract(zipFile, zipEntry, layoutDestinationPath);
            zipEntry = "website/resources/layout/layout.jpg";
            ZipUtils.extract(zipFile, zipEntry, layoutThumbnailDestinationPath);
        }
        this.layout.setJsp(layoutDestinationPath);
        this.layout.setThumbnail(layoutThumbnailDestinationPath);
        this.layout.update(db);
        if (this.style.getConstant() == -1) {
            zipEntry = "website/resources/style/style.css";
            ZipUtils.extract(zipFile, zipEntry, styleDestinationPath);
            zipEntry = "website/resources/style/style.jpg";
            ZipUtils.extract(zipFile, zipEntry, styleThumbnailDestinationPath);
        }
        this.style.setCss(styleDestinationPath);
        this.style.setThumbnail(styleThumbnailDestinationPath);
        this.style.update(db);
        zipFile.close();
    }

    private String replaceTags(String htmlString, int pageRowId, Connection db) throws Exception {
        XMLUtils html = new XMLUtils(htmlString);
        Element htmlElement = html.getDocumentElement();
        this.replaceImgTags(htmlElement, pageRowId, db);
        return XMLUtils.toString(htmlElement);
    }

    private void replaceImgTags(Node node, int pageRowId, Connection db) throws Exception {
        String[] srcParameters;
        Element e;
        String srcAttributeValue;
        if (node.getNodeType() == 1 && node.getNodeName().equals("img") && (srcAttributeValue = (e = (Element)node).getAttribute("src")).indexOf("id=") != -1 && (srcParameters = e.getAttribute("src").split("_")).length > 0) {
            String value = srcParameters[1];
            int imageId = this.copyImage(db, value);
            String attributeValue = "ProcessFileItemImage.do?command=StreamImage&path=website&row=" + pageRowId + "&id=" + imageId;
            e.setAttribute("src", attributeValue);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.replaceImgTags(child, pageRowId, db);
        }
    }

    private int copyImage(Connection db, String imageName) throws Exception {
        String fs = System.getProperty("file.separator");
        FileItem thisItem = new FileItem();
        thisItem.setLinkModuleId(2006051216);
        thisItem.setLinkItemId(0);
        thisItem.setEnteredBy(0);
        thisItem.setModifiedBy(0);
        thisItem.setSubject(imageName);
        thisItem.setClientFilename(imageName);
        thisItem.setFilename(imageName);
        thisItem.setVersion(1.0);
        if (thisItem.insert(db)) {
            int imageId = thisItem.getId();
            ZipFile zipFile = new ZipFile(this.zipfilePath);
            ZipEntry zipEntry = zipFile.getEntry("website/resources/images/" + imageName);
            if (zipEntry == null) {
                zipEntry = zipFile.getEntry("website\\resources\\images\\" + imageName);
            }
            InputStream imageStream = zipFile.getInputStream(zipEntry);
            byte[] image = new byte[imageStream.available()];
            int numRead = 0;
            for (int offset = 0; offset < image.length && (numRead = imageStream.read(image, offset, image.length - offset)) >= 0; offset += numRead) {
            }
            imageStream.close();
            zipFile.close();
            if (this.fileLibraryPath == null) {
                this.fileLibraryPath = this.webappPath + "/WEB-INF/fileLibrary/cdb_actionplans/accounts/";
            }
            String completeImagefilePath = this.fileLibraryPath + DateUtils.getDatePath(new Timestamp(Calendar.getInstance().getTimeInMillis())) + thisItem.getFilename();
            boolean success = new File(this.fileLibraryPath + DateUtils.getDatePath(new Timestamp(Calendar.getInstance().getTimeInMillis()))).mkdirs();
            System.out.println("IMAGE PATH IN THE FILE LIBRARY ==> " + completeImagefilePath);
            if (success) {
                FileUtils.copyBytesToFile(image, new File(completeImagefilePath), true);
            }
            return imageId;
        }
        return -1;
    }

    public void setZipfilePath(String tmp) {
        this.zipfilePath = tmp;
    }

    public void setWebappPath(String tmp) {
        this.webappPath = tmp;
    }

    public void setFileLibraryPath(String tmp) {
        this.fileLibraryPath = tmp;
    }

    public String getZipfilePath() {
        return this.zipfilePath;
    }

    public String getWebappPath() {
        return this.webappPath;
    }

    public String getFileLibraryPath() {
        return this.fileLibraryPath;
    }

    public Site getSite() {
        return this.site;
    }
}

