/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.servlets.url.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class URLMap
extends GenericBean {
    private static final long serialVersionUID = -5854362050325558717L;
    private int id = -1;
    private long timeInMillis = -1L;
    private String url = null;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public long getTimeInMillis() {
        return this.timeInMillis;
    }

    public void setTimeInMillis(long timeInMillis) {
        this.timeInMillis = timeInMillis;
    }

    public void setTimeInMillis(String tmp) {
        this.timeInMillis = Long.parseLong(tmp);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public URLMap() {
    }

    public URLMap(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public URLMap(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid URL MAP Number");
        }
        try {
            PreparedStatement pst = db.prepareStatement("SELECT urlmp.* FROM url_map urlmp WHERE urlmp.url_id = ? ");
            pst.setInt(1, id);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                this.buildRecord(rs);
            }
            rs.close();
            pst.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getId() == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("url_id"));
        this.setTimeInMillis(rs.getLong("time_in_millis"));
        this.setUrl(rs.getString("url"));
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "url_map_url_id_seq");
            StringBuffer sql = new StringBuffer();
            sql.append(" INSERT INTO url_map (");
            if (this.id > -1) {
                sql.append(" url_id,");
            }
            sql.append(" url, time_in_millis )");
            sql.append("VALUES(");
            if (this.id > -1) {
                sql.append(" ?,");
            }
            sql.append(" ?, ? )");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.getId());
            }
            pst.setString(++i, this.getUrl());
            if (this.timeInMillis == -1L) {
                this.timeInMillis = System.currentTimeMillis();
            }
            pst.setLong(++i, this.getTimeInMillis());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "url_map_url_id_seq", this.id);
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public String getURLAlias() {
        return "/url/" + new Long(this.timeInMillis).toString() + "/" + new Integer(this.id).toString();
    }
}

