/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.taglib;

import com.darkhorseventures.database.ConnectionElement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.utils.DatabaseUtils;

public class DateTimeHandler
extends TagSupport
implements TryCatchFinally {
    private Timestamp timestamp = null;
    private boolean dateOnly = false;
    private boolean timeOnly = false;
    private int timeFormat = 1;
    private int dateFormat = 3;
    private String pattern = null;
    private String defaultValue = "";

    public void doCatch(Throwable throwable) throws Throwable {
    }

    public void doFinally() {
        this.timestamp = null;
        this.dateOnly = false;
        this.timeOnly = false;
        this.timeFormat = 1;
        this.dateFormat = 3;
        this.pattern = null;
        this.defaultValue = "";
    }

    public void setTimestamp(Timestamp tmp) {
        this.timestamp = tmp;
    }

    public void setTimestamp(Date tmp) {
        this.timestamp = new Timestamp(tmp.getTime());
    }

    public void setTimestamp(java.sql.Date tmp) {
        this.timestamp = new Timestamp(tmp.getTime());
    }

    public void setTimestamp(String tmp) {
        this.timestamp = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setDefault(String tmp) {
        this.defaultValue = tmp;
    }

    public void setDateOnly(boolean dateOnly) {
        this.dateOnly = dateOnly;
    }

    public void setTimeOnly(String timeOnly) {
        this.timeOnly = "true".equals(timeOnly);
    }

    public void setTimeOnly(boolean timeOnly) {
        this.timeOnly = timeOnly;
    }

    public boolean getTimeOnly() {
        return this.timeOnly;
    }

    public void setDateOnly(String dateOnly) {
        this.dateOnly = "true".equals(dateOnly);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setTimeFormat(int timeFormat) {
        this.timeFormat = timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = Integer.parseInt(timeFormat);
    }

    public void setDateFormat(int dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = Integer.parseInt(dateFormat);
    }

    public int doStartTag() throws JspException {
        try {
            if (this.timestamp != null && !"".equals(this.timestamp)) {
                String timeZone = null;
                UserBean userBean = (UserBean)((Object)this.pageContext.getSession().getAttribute("User"));
                if (userBean != null) {
                    ConnectionElement ce = (ConnectionElement)this.pageContext.getSession().getAttribute("ConnectionElement");
                    SystemStatus systemStatus = (SystemStatus)((Hashtable)this.pageContext.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
                    User thisUser = systemStatus.getUser(userBean.getUserId());
                    timeZone = thisUser.getTimeZone();
                }
                SimpleDateFormat formatter = null;
                formatter = this.dateOnly ? (SimpleDateFormat)SimpleDateFormat.getDateInstance(this.dateFormat) : (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(this.dateFormat, this.timeFormat);
                if (this.pattern != null) {
                    formatter.applyPattern(this.pattern);
                } else if (this.dateOnly) {
                    formatter.applyPattern("M/d/yyyy");
                } else if (this.timeOnly) {
                    formatter.applyPattern("h:mm a");
                }
                if (timeZone != null) {
                    TimeZone tz = TimeZone.getTimeZone(timeZone);
                    formatter.setTimeZone(tz);
                }
                this.pageContext.getOut().write(formatter.format(this.timestamp));
            } else {
                this.pageContext.getOut().write(this.defaultValue);
            }
        }
        catch (Exception e) {
            System.err.println("EXCEPTION: DateTimeHandler-> Timestamp " + this.timestamp + " could not be formatted for userbean session");
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }
}

