/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.taglib;

import com.darkhorseventures.database.ConnectionElement;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.documents.base.DocumentStore;
import org.aspcfs.modules.documents.base.DocumentStoreTeamMember;
import org.aspcfs.utils.web.LookupList;

public class DocumentsPermissionHandler
extends TagSupport
implements TryCatchFinally {
    private String permission = null;
    private String includeIf = "all";

    public void doCatch(Throwable throwable) throws Throwable {
    }

    public void doFinally() {
        this.permission = null;
        this.includeIf = "all";
    }

    public void setName(String tmp) {
        this.permission = tmp;
    }

    public void setIf(String tmp) {
        this.includeIf = tmp;
    }

    public int doStartTag() throws JspException {
        try {
            DocumentStoreTeamMember thisMember = (DocumentStoreTeamMember)this.pageContext.getRequest().getAttribute("currentMember");
            DocumentStore thisDocumentStore = (DocumentStore)((Object)this.pageContext.getRequest().getAttribute("documentStore"));
            if (thisMember == null || thisDocumentStore == null) {
                return 0;
            }
            if (thisMember.getRoleId() == 1 && "all".equals(this.includeIf)) {
                return 1;
            }
            boolean doCheck = true;
            int code = -1;
            int roleId = -1;
            StringTokenizer st = new StringTokenizer(this.permission, ",");
            while (st.hasMoreTokens() || doCheck) {
                doCheck = false;
                code = st.hasMoreTokens() ? thisDocumentStore.getAccessUserLevel(st.nextToken()) : thisDocumentStore.getAccessUserLevel(this.permission);
                roleId = this.getRoleId(code);
                if (code == -1 || roleId == -1) {
                    return 0;
                }
                if ("none".equals(this.includeIf)) {
                    if (thisMember.getRoleId() > roleId) continue;
                    return 0;
                }
                if ("any".equals(this.includeIf)) {
                    if (thisMember.getRoleId() > roleId) continue;
                    return 1;
                }
                if (thisMember.getRoleId() <= roleId) continue;
                return 0;
            }
            if ("none".equals(this.includeIf)) {
                return 1;
            }
            if ("any".equals(this.includeIf)) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            System.out.println("Permission Error: " + e.getMessage());
            return 0;
        }
    }

    protected int getRoleId(int userlevel) {
        SystemStatus thisSystem;
        Hashtable systemStatus;
        ConnectionElement ce = (ConnectionElement)this.pageContext.getSession().getAttribute("ConnectionElement");
        if (ce != null && (systemStatus = (Hashtable)this.pageContext.getServletContext().getAttribute("SystemStatus")) != null && (thisSystem = (SystemStatus)systemStatus.get(ce.getUrl())) != null) {
            Connection db = null;
            try {
                LookupList roleList = thisSystem.getLookupList(db, "lookup_document_store_role");
                if (roleList != null) {
                    return roleList.getLevelFromId(userlevel);
                }
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }
}

