/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.taglib;

import com.darkhorseventures.database.ConnectionElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;

public class LabelHandler
extends TagSupport
implements TryCatchFinally {
    private String labelName = null;
    private HashMap params = null;
    private boolean mainMenuItem = false;
    private boolean subMenuItem = false;

    public void doCatch(Throwable throwable) throws Throwable {
    }

    public void doFinally() {
        this.labelName = null;
        this.params = null;
        this.mainMenuItem = false;
        this.subMenuItem = false;
    }

    public final void setName(String tmp) {
        this.labelName = tmp;
    }

    public final void setMainMenuItem(boolean tmp) {
        this.mainMenuItem = tmp;
    }

    public final void setSubMenuItem(boolean tmp) {
        this.subMenuItem = tmp;
    }

    public void setParam(String tmp) {
        this.params = new HashMap();
        StringTokenizer tokens = new StringTokenizer(tmp, "|");
        while (tokens.hasMoreTokens()) {
            String pair = tokens.nextToken();
            String param = pair.substring(0, pair.indexOf("="));
            String value = pair.substring(pair.indexOf("=") + 1);
            this.params.put("${" + param + "}", value);
        }
    }

    public final int doStartTag() {
        String newLabel = null;
        ConnectionElement ce = (ConnectionElement)this.pageContext.getSession().getAttribute("ConnectionElement");
        if (ce == null) {
            ApplicationPrefs prefs = (ApplicationPrefs)this.pageContext.getServletContext().getAttribute("applicationPrefs");
            if (prefs != null) {
                newLabel = prefs.getLabel(this.labelName, prefs.get("SYSTEM.LANGUAGE"));
            }
        } else {
            SystemStatus systemStatus = (SystemStatus)((Hashtable)this.pageContext.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
            if (systemStatus == null) {
                System.out.println("LabelHandler-> SystemStatus is null");
            }
            if (systemStatus != null) {
                newLabel = this.mainMenuItem ? systemStatus.getMenuProperty(this.labelName, "page_title") : (this.subMenuItem ? systemStatus.getSubMenuProperty(this.labelName) : systemStatus.getLabel(this.labelName));
            }
        }
        if (newLabel != null && this.params != null && this.params.size() > 0) {
            Template labelText = new Template(newLabel);
            labelText.setParseElements(this.params);
            newLabel = labelText.getParsedText();
        }
        if (newLabel != null) {
            try {
                this.pageContext.getOut().write(StringUtils.toHtmlChars(newLabel));
                return 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 1;
    }
}

