/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.taglib;

import com.darkhorseventures.database.ConnectionElement;
import java.util.HashMap;
import java.util.Hashtable;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.PagedListInfo;

public class PagedListControlHandler
extends TagSupport
implements TryCatchFinally {
    private String name = "controlProperties";
    private String object = null;
    private String bgColor = null;
    private String fontColor = "#666666";
    private String tdClass = null;
    private boolean showForm = true;
    private boolean resetList = true;
    private boolean abbreviate = false;
    private boolean enableJScript = false;
    private String form = "0";

    public void doCatch(Throwable throwable) throws Throwable {
    }

    public void doFinally() {
        this.name = "controlProperties";
        this.object = null;
        this.bgColor = null;
        this.fontColor = "#666666";
        this.tdClass = null;
        this.showForm = true;
        this.resetList = true;
        this.abbreviate = false;
        this.enableJScript = false;
        this.form = "0";
    }

    public final void setName(String tmp) {
        this.name = tmp;
    }

    public final void setObject(String tmp) {
        this.object = tmp;
    }

    public final void setBgColor(String tmp) {
        this.bgColor = tmp;
    }

    public final void setFontColor(String tmp) {
        this.fontColor = tmp;
    }

    public final void setTdClass(String tmp) {
        this.tdClass = tmp;
    }

    public void setShowForm(String showForm) {
        this.showForm = "true".equalsIgnoreCase(showForm);
    }

    public void setResetList(String resetList) {
        this.resetList = "true".equalsIgnoreCase(resetList);
    }

    public boolean getAbbreviate() {
        return this.abbreviate;
    }

    public void setAbbreviate(boolean abbreviate) {
        this.abbreviate = abbreviate;
    }

    public void setEnableJScript(boolean enableJScript) {
        this.enableJScript = enableJScript;
    }

    public void setEnableJScript(String tmp) {
        this.enableJScript = DatabaseUtils.parseBoolean(tmp);
    }

    public void setForm(String form) {
        this.form = form;
    }

    public final int doStartTag() {
        return 1;
    }

    public int doEndTag() {
        ApplicationPrefs prefs = (ApplicationPrefs)this.pageContext.getServletContext().getAttribute("applicationPrefs");
        ConnectionElement ce = (ConnectionElement)this.pageContext.getSession().getAttribute("ConnectionElement");
        SystemStatus systemStatus = null;
        if (ce != null) {
            Hashtable statusList = (Hashtable)this.pageContext.getServletContext().getAttribute("SystemStatus");
            systemStatus = (SystemStatus)statusList.get(ce.getUrl());
        }
        try {
            PortletRequest renderRequest;
            PagedListInfo pagedListInfo = (PagedListInfo)this.pageContext.getSession().getAttribute(this.object);
            if (pagedListInfo == null && (renderRequest = (PortletRequest)this.pageContext.getRequest().getAttribute("javax.portlet.request")) != null) {
                pagedListInfo = (PagedListInfo)renderRequest.getPortletSession().getAttribute(this.object);
            }
            RenderResponse renderResponse = (RenderResponse)this.pageContext.getRequest().getAttribute("javax.portlet.response");
            if (pagedListInfo != null) {
                pagedListInfo.setShowForm(this.showForm);
                pagedListInfo.setResetList(this.resetList);
                pagedListInfo.setEnableJScript(this.enableJScript);
                JspWriter out = this.pageContext.getOut();
                String batchHTML = (String)this.getValue("batchHTML");
                if (this.enableJScript) {
                    out.write("<SCRIPT LANGUAGE=\"JavaScript\" TYPE=\"text/javascript\" SRC=\"javascript/pageListInfo.js\"></SCRIPT>");
                }
                out.write("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">");
                out.write(pagedListInfo.getListPropertiesHeader(this.name));
                out.write("<tr>");
                out.write("<td valign=\"middle\" align=\"center\"" + (this.bgColor != null ? " bgColor=\"" + this.bgColor + "\"" : "") + (this.tdClass != null ? " class=\"" + this.tdClass + "\"" : "") + " width=\"100%\">");
                out.write("<input type=\"hidden\" name=\"offset\" value=\"\">");
                out.write("<input type=\"hidden\" name=\"pagedListInfoId\" value=\"" + this.object + "\">");
                if (systemStatus != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("${pagedListInfo.numericalPageEntry}", "" + pagedListInfo.getNumericalPageEntry());
                    map.put("${pagedListInfo.numberOfPages}", pagedListInfo.getNumberOfPages() == 0 ? "1" : String.valueOf(pagedListInfo.getNumberOfPages()));
                    out.write("[" + pagedListInfo.getPreviousPageLink("<font class='underline'>" + systemStatus.getLabel("label.previous") + "</font>", systemStatus.getLabel("label.previous"), this.form, renderResponse) + "|" + pagedListInfo.getNextPageLink("<font class='underline'>" + systemStatus.getLabel("label.next") + "</font>", systemStatus.getLabel("label.next"), this.form, renderResponse) + "] ");
                    out.write("<font color=\"" + this.fontColor + "\">");
                    if (!this.abbreviate) {
                        map.put("${pagedListInfo.itemsPerPageEntry}", pagedListInfo.getItemsPerPageEntry(systemStatus.getLabel("quotes.all", "All")));
                        out.write(this.getLabel(map, systemStatus.getLabel("pagedListInfo.pagedListControlHandler.notAbbreviation")));
                    } else {
                        out.write(this.getLabel(map, systemStatus.getLabel("pagedListInfo.pagedListControlHandler.abbreviation")));
                        out.write("&nbsp;&nbsp;");
                    }
                    out.write("<input type=\"submit\" value=\"" + systemStatus.getLabel("button.go") + "\">");
                } else {
                    out.write("[" + pagedListInfo.getPreviousPageLink("<font class='underline'>Previous</font>", "Previous", this.form, renderResponse) + "|" + pagedListInfo.getNextPageLink("<font class='underline'>Next</font>", "Next", this.form, renderResponse) + "] ");
                    out.write("<font color=\"" + this.fontColor + "\">");
                    out.write("Page " + pagedListInfo.getNumericalPageEntry() + " ");
                    if (!this.abbreviate) {
                        out.write("of " + (pagedListInfo.getNumberOfPages() == 0 ? "1" : String.valueOf(pagedListInfo.getNumberOfPages())) + ", ");
                        String quotesAll = prefs.getLabel("quotes.all", prefs.get("SYSTEM.LANGUAGE"));
                        if (quotesAll == null) {
                            quotesAll = "All";
                        }
                        out.write("Items per page: " + pagedListInfo.getItemsPerPageEntry(quotesAll + " "));
                    } else {
                        out.write("of " + (pagedListInfo.getNumberOfPages() == 0 ? "1" : String.valueOf(pagedListInfo.getNumberOfPages())));
                        out.write("&nbsp;&nbsp;");
                    }
                    out.write("<input type=\"submit\" value=\"go\">");
                }
                out.write("</font>");
                out.write("</td>");
                out.write("</tr>");
                if (batchHTML != null) {
                    out.write("<tr><td valign=\"middle\" align=\"center\"" + (this.bgColor != null ? " bgColor=\"" + this.bgColor + "\"" : "") + (this.tdClass != null ? " class=\"" + this.tdClass + "\"" : "") + " nowrap>");
                    out.write(batchHTML);
                    out.write("</td></tr>");
                }
                out.write(pagedListInfo.getListPropertiesFooter());
                out.write("</table>");
            } else {
                System.out.println("PagedListControlHandler-> Control not found in request: " + this.object);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return 6;
    }

    public String getLabel(HashMap map, String input) {
        Template template = new Template(input);
        template.setParseElements(map);
        return template.getParsedText();
    }
}

