/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.taglib;

import com.darkhorseventures.database.ConnectionElement;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;

public class ProductCategoryHierarchyHandler
extends TagSupport
implements TryCatchFinally {
    private boolean showLastLink = false;
    private boolean displayJS = false;
    private String link = null;

    public void doCatch(Throwable throwable) throws Throwable {
    }

    public void doFinally() {
        this.showLastLink = false;
        this.displayJS = false;
        this.link = null;
    }

    public void setDisplayJS(boolean tmp) {
        this.displayJS = tmp;
    }

    public void setDisplayJS(String tmp) {
        this.displayJS = DatabaseUtils.parseBoolean(tmp);
    }

    public void setShowLastLink(boolean tmp) {
        this.showLastLink = tmp;
    }

    public void setShowLastLink(String tmp) {
        this.showLastLink = DatabaseUtils.parseBoolean(tmp);
    }

    public void setLink(String tmp) {
        this.link = tmp;
    }

    public int doStartTag() throws JspException {
        try {
            SystemStatus thisSystem = null;
            ConnectionElement ce = (ConnectionElement)this.pageContext.getSession().getAttribute("ConnectionElement");
            if (ce != null) {
                thisSystem = (SystemStatus)((Hashtable)this.pageContext.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
            }
            this.pageContext.getOut().write("<img border=\"0\" src=\"images/icons/stock_home-16.gif\" align=\"absmiddle\"> ");
            LinkedHashMap categoryLevels = (LinkedHashMap)this.pageContext.getRequest().getAttribute("categoryLevels");
            if (categoryLevels == null) {
                if (this.showLastLink) {
                    if (this.displayJS) {
                        this.pageContext.getOut().write("<a href=\"javascript:submitForm('-1');\">");
                    } else {
                        this.pageContext.getOut().write("<a href=\"" + this.link + "&categoryId=-1\">");
                    }
                }
                if (thisSystem != null) {
                    this.pageContext.getOut().write(thisSystem.getLabel("product.category.topCategories"));
                } else {
                    this.pageContext.getOut().write("Top Categories");
                }
                if (this.showLastLink) {
                    this.pageContext.getOut().write("</a>");
                }
            } else {
                Object[] hierarchy = categoryLevels.keySet().toArray();
                if (hierarchy.length > 0) {
                    String categoryId = this.pageContext.getRequest().getParameter("categoryId");
                    if (this.displayJS) {
                        this.pageContext.getOut().write("<a href=\"javascript:submitForm('-1')\">");
                    } else {
                        this.pageContext.getOut().write("<a href=\"" + this.link + "&categoryId=-1\">");
                    }
                    if (thisSystem != null) {
                        this.pageContext.getOut().write(thisSystem.getLabel("product.category.topCategories"));
                    } else {
                        this.pageContext.getOut().write("Top Categories");
                    }
                    this.pageContext.getOut().write("</a>");
                    this.pageContext.getOut().write(" > ");
                    for (int i = hierarchy.length - 1; i >= 0; --i) {
                        Integer thisId = (Integer)hierarchy[i];
                        String[] sa = (String[])categoryLevels.get(thisId);
                        String name = sa[0];
                        if (i > 0 || this.showLastLink) {
                            if (this.displayJS) {
                                this.pageContext.getOut().write("<a href=\"javascript:submitForm('" + thisId + "');\">");
                            } else {
                                this.pageContext.getOut().write("<a href=\"" + this.link + "&categoryId=" + thisId + "\">");
                            }
                        }
                        this.pageContext.getOut().write(StringUtils.toHtml(name));
                        if (i > 0 || this.showLastLink) {
                            this.pageContext.getOut().write("</a>");
                        }
                        if (i <= 0) continue;
                        this.pageContext.getOut().write(" > ");
                    }
                } else {
                    if (this.showLastLink) {
                        if (this.displayJS) {
                            this.pageContext.getOut().write("<a href=\"javascript:submitForm('-1');\">");
                        } else {
                            this.pageContext.getOut().write("<a href=\"" + this.link + "&categoryId=-1\">");
                        }
                    }
                    if (thisSystem != null) {
                        this.pageContext.getOut().write(thisSystem.getLabel("product.category.topCategories"));
                    } else {
                        this.pageContext.getOut().write("Top Categories");
                    }
                    if (this.showLastLink) {
                        this.pageContext.getOut().write("</a>");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new JspException("ProductCategoryHierarchyHandler Error: " + e.getMessage());
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }
}

