/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.taglib;

import java.io.File;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.aspcfs.utils.SVGUtils;
import org.aspcfs.utils.StringUtils;

public class SVGTextHandler
extends TagSupport {
    private static final String fs = System.getProperty("file.separator");
    private String template = null;
    private String text = null;
    private static final String allowed = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-.";

    public void setTemplate(String tmp) {
        this.template = tmp;
    }

    public void setText(String tmp) {
        this.text = tmp;
    }

    private static String toSafeName(String str) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            if (allowed.indexOf(str.charAt(i)) > -1) {
                sb.append(str.charAt(i));
                continue;
            }
            sb.append("_");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion(ServletContext context, String svgPath) {
        String version;
        HashMap<String, String> svgMap = (HashMap<String, String>)context.getAttribute("svgTextHandlerMap");
        if (svgMap == null) {
            SVGTextHandler sVGTextHandler = this;
            synchronized (sVGTextHandler) {
                svgMap = (HashMap)context.getAttribute("svgTextHandlerMap");
                if (svgMap == null) {
                    svgMap = new HashMap<String, String>();
                    context.setAttribute("svgTextHandlerMap", svgMap);
                }
            }
        }
        if ((version = (String)svgMap.get(this.template)) == null) {
            SVGTextHandler sVGTextHandler = this;
            synchronized (sVGTextHandler) {
                version = (String)svgMap.get(this.template);
                if (version == null) {
                    try {
                        String tmp = StringUtils.loadText(svgPath + this.template + ".version");
                        version = "_" + tmp.substring(0, tmp.indexOf(System.getProperty("line.separator")));
                    }
                    catch (Exception e) {
                        version = "";
                    }
                }
                svgMap.put(this.template, version);
            }
        }
        return version;
    }

    public int doStartTag() throws JspException {
        try {
            File SVGFile;
            String path = this.pageContext.getServletContext().getRealPath("/");
            String templateName = StringUtils.replace(this.template, " ", "_");
            String textName = SVGTextHandler.toSafeName(this.text);
            String version = this.getVersion(this.pageContext.getServletContext(), path + "WEB-INF" + fs + "svg" + fs);
            String imageFilename = templateName + "_" + textName + version + ".jpg";
            String templateFilename = this.template + ".svg";
            File imageFile = new File(path + "svg" + fs + imageFilename);
            if (!imageFile.exists() && (SVGFile = new File(path + "WEB-INF" + fs + "svg" + fs + templateFilename)).exists()) {
                SVGUtils svg = new SVGUtils(SVGFile.toURL().toString());
                svg.setText(this.text);
                File imageDirectory = new File(path + "svg");
                if (!imageDirectory.exists()) {
                    imageDirectory.mkdir();
                }
                svg.saveAsJPEG(imageFile);
            }
            this.pageContext.getOut().write("<img src=\"svg/" + imageFilename + "\" border=\"0\"/>");
        }
        catch (Exception e) {
            System.err.println("EXCEPTION: SVGTextHandler-> " + e.getMessage());
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }
}

