/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.aspcfs.controller.ApplicationPrefs;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AppUtils {
    public static boolean loadConfig(String filename, Map config) {
        if (filename.endsWith(".xml")) {
            File file = new File(filename);
            if (file == null) {
                System.err.println("AppUtils-> Configuration file not found: " + filename);
                return false;
            }
            try {
                Document document = AppUtils.parseDocument(file);
                config.clear();
                NodeList tags = document.getElementsByTagName("init-param");
                for (int i = 0; i < tags.getLength(); ++i) {
                    Element tag = (Element)tags.item(i);
                    NodeList params = tag.getChildNodes();
                    String name = null;
                    String value = null;
                    for (int j = 0; j < params.getLength(); ++j) {
                        Node param = params.item(j);
                        if (!param.hasChildNodes()) continue;
                        NodeList children = param.getChildNodes();
                        Node thisNode = children.item(0);
                        if (param.getNodeName().equals("param-name")) {
                            name = thisNode.getNodeValue();
                        }
                        if (!param.getNodeName().equals("param-value")) continue;
                        value = thisNode.getNodeValue();
                    }
                    if (value == null) {
                        value = "";
                    }
                    config.put(name, value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        ApplicationPrefs prefs = new ApplicationPrefs();
        prefs.load(filename + "build.properties");
        if (!prefs.has("FILELIBRARY")) {
            prefs.add("FILELIBRARY", filename);
        }
        config.putAll(prefs.getPrefs());
        return true;
    }

    private static Document parseDocument(File file) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(file);
        return document;
    }
}

