/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import javax.servlet.ServletContext;
import net.sf.asterisk.manager.ManagerConnection;
import net.sf.asterisk.manager.ManagerEventHandler;
import net.sf.asterisk.manager.event.DialEvent;
import net.sf.asterisk.manager.event.ManagerEvent;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.base.PhoneNumber;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactInstantMessageAddressList;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.modules.contacts.base.ContactPhoneNumberList;
import org.aspcfs.utils.XMPPManager;
import org.aspcfs.utils.formatter.PhoneNumberFormatter;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Presence;

public class AsteriskListener
extends Thread
implements ManagerEventHandler {
    private ManagerConnection managerConnection = null;
    private ServletContext servletContext = null;
    private SystemStatus systemStatus = null;
    private ApplicationPrefs applicationPrefs = null;
    private boolean shouldRun = true;

    public void setManagerConnection(ManagerConnection managerConnection) {
        this.managerConnection = managerConnection;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setSystemStatus(SystemStatus systemStatus) {
        this.systemStatus = systemStatus;
    }

    public void setApplicationPrefs(ApplicationPrefs applicationPrefs) {
        this.applicationPrefs = applicationPrefs;
    }

    public void setShouldRun(boolean shouldRun) {
        this.shouldRun = shouldRun;
    }

    public void run() {
        System.out.println("AsteriskListener-> Registering events");
        this.managerConnection.addEventHandler((ManagerEventHandler)this);
        try {
            while (this.shouldRun) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            System.out.println("AsteriskListener-> " + e.getMessage());
            this.shouldRun = false;
        }
        this.shouldRun = false;
        this.managerConnection.removeEventHandler((ManagerEventHandler)this);
        System.out.println("AsteriskListener-> Exiting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ManagerEvent event) {
        if (!this.shouldRun) {
            return;
        }
        String eventClass = event.getClass().getName();
        if ("net.sf.asterisk.manager.event.DialEvent".equals(eventClass)) {
            if (!"true".equals(this.applicationPrefs.get("XMPP.ENABLED"))) {
                return;
            }
            DialEvent thisEvent = (DialEvent)event;
            String channel = thisEvent.getDestination();
            String callerId = thisEvent.getCallerId();
            String extension = "";
            if (channel == null || callerId == null) {
                return;
            }
            if (channel.length() > 4 && (extension = channel.substring(4)).indexOf("-") > -1) {
                extension = extension.substring(0, extension.lastIndexOf("-"));
            }
            if (extension.equals("")) {
                return;
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("AsteriskListener-> " + eventClass);
                System.out.println("Caller Id: " + thisEvent.getCallerId());
                System.out.println("Caller Id Name: " + thisEvent.getCallerIdName());
                System.out.println("Channel: " + channel);
                System.out.println("Extension: " + extension);
            }
            ConnectionPool cp = (ConnectionPool)this.servletContext.getAttribute("ConnectionPool");
            Connection db = null;
            boolean connected = true;
            try {
                Presence presence;
                db = cp.getConnection(this.systemStatus.getConnectionElement());
                ContactPhoneNumberList userPhoneList = new ContactPhoneNumberList();
                userPhoneList.setExtension(extension);
                userPhoneList.setUsersOnly(true);
                userPhoneList.buildList(db);
                if (userPhoneList.size() != 1) {
                    return;
                }
                Contact user = new Contact(db, ((ContactPhoneNumber)userPhoneList.get(0)).getContactId());
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("AsteriskListener-> User found: " + user.getNameFirstLast());
                }
                ContactInstantMessageAddressList userIMList = new ContactInstantMessageAddressList();
                userIMList.setContactId(user.getId());
                userIMList.setServiceName("Jabber");
                userIMList.buildList(db);
                if (userIMList.size() == 0) {
                    return;
                }
                String imAddress = userIMList.getPrimaryInstantMessageAddress();
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("AsteriskListener-> IM TO: " + imAddress);
                }
                PhoneNumber phoneNumber = new PhoneNumber();
                phoneNumber.setNumber(callerId);
                PhoneNumberFormatter.format(phoneNumber);
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("AsteriskListener-> Looking up: " + phoneNumber.getNumber());
                }
                ContactPhoneNumberList phoneList = new ContactPhoneNumberList();
                phoneList.setNumber(phoneNumber.getNumber());
                phoneList.buildList(db);
                if (phoneList.size() == 0) {
                    return;
                }
                Contact contact = new Contact(db, ((ContactPhoneNumber)phoneList.get(0)).getContactId());
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("AsteriskListener-> Contact: " + contact.getNameFirstLast());
                }
                cp.free(db);
                connected = false;
                XMPPConnection xmpp = XMPPManager.verifyConnection(this.systemStatus, this.applicationPrefs);
                if (xmpp == null) {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("AsteriskListener-> No Connection");
                    }
                    return;
                }
                Roster roster = xmpp.getRoster();
                RosterEntry entry = roster.getEntry(imAddress);
                if (entry == null) {
                    roster.createEntry(imAddress, String.valueOf(user.getId()), null);
                }
                if ((presence = roster.getPresence(imAddress)) == null) {
                    roster.createEntry(imAddress, String.valueOf(user.getId()), null);
                }
                if ((presence = roster.getPresence(imAddress)) == null) {
                    // empty if block
                }
                if (presence != null && presence.getType() != Presence.Type.AVAILABLE) {
                    return;
                }
                StringBuffer message = new StringBuffer();
                message.append("Incoming call from... \r\n");
                message.append("\r\n");
                message.append("Contact: " + contact.getNameFirstLast() + "\r\n");
                if (contact.getOrgName() != null && !"".equals(contact.getOrgName())) {
                    message.append("Organization: " + contact.getOrgName() + "\r\n");
                }
                message.append("Phone Number: " + phoneNumber.getNumber() + "\r\n");
                if (contact.getOrgId() > 0) {
                    message.append("\r\n");
                    message.append("View this Account in Centric CRM\r\n");
                    message.append(this.systemStatus.getUrl() + "/Accounts.do?command=Details&orgId=" + contact.getOrgId() + "\r\n");
                }
                message.append("\r\n");
                message.append("View this Contact in Centric CRM\r\n");
                message.append(this.systemStatus.getUrl() + "/ExternalContacts.do?command=ContactDetails&id=" + contact.getId() + "\r\n");
                xmpp.createChat(imAddress).sendMessage(message.toString());
            }
            catch (Exception e) {
                System.out.println("AsteriskListener Exception: " + e.getMessage());
            }
            finally {
                if (connected) {
                    cp.free(db);
                }
            }
        }
    }
}

