/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CFSFileReader {
    private String filePath = null;
    private int fileType = -1;
    private String recordDelimiter = null;
    private String columnDelimiter = null;
    private BufferedReader in = null;

    public CFSFileReader(String filePath, int fileType) throws FileNotFoundException {
        this.filePath = filePath;
        this.fileType = fileType;
        this.in = new BufferedReader(new FileReader(filePath));
    }

    public void setFilePath(String tmp) {
        this.filePath = tmp;
    }

    public void setFileType(int tmp) {
        this.fileType = tmp;
    }

    public void setFileType(String tmp) {
        this.fileType = Integer.parseInt(tmp);
    }

    public void setRecordDelimiter(String tmp) {
        this.recordDelimiter = tmp;
    }

    public void setColumnDelimiter(String tmp) {
        this.columnDelimiter = tmp;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getFileType() {
        return this.fileType;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public String getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public Record nextLine() {
        Record record = null;
        try {
            switch (this.fileType) {
                case 8: {
                    record = this.retrieveExcelCSVLine();
                    break;
                }
                case 7: {
                    record = this.retrieveCustomLine();
                    break;
                }
                case 9: {
                    record = this.retrieveActLine();
                    break;
                }
            }
        }
        catch (Exception e) {
            if (System.getProperty("DEBUG") != null) {
                e.printStackTrace();
            }
            record = null;
        }
        return record;
    }

    public ArrayList parseLine(String line) {
        return null;
    }

    public Record retrieveExcelCSVLine() throws IOException {
        Record record;
        block25: {
            if (this.in == null) {
                return null;
            }
            record = null;
            try {
                boolean quoteBegin = false;
                boolean beginColumn = true;
                StringBuffer buffer = new StringBuffer();
                String line = null;
                record = new Record();
                record.data = new ArrayList();
                record.columnDelimiter = this.columnDelimiter;
                boolean done = false;
                while (!done) {
                    line = this.in.readLine();
                    if (line != null) {
                        if ("".equals(line.trim())) continue;
                        record.line = record.line + line;
                        for (int i = 0; i < line.length(); ++i) {
                            char thisChar = line.charAt(i);
                            if (beginColumn) {
                                quoteBegin = false;
                                if (thisChar == '\"') {
                                    quoteBegin = true;
                                } else {
                                    buffer.append(thisChar);
                                }
                                if (thisChar == ',') {
                                    record.data.add("");
                                    buffer = buffer.delete(0, buffer.length());
                                } else {
                                    beginColumn = false;
                                }
                            } else if (thisChar == ',') {
                                if (quoteBegin) {
                                    buffer.append(thisChar);
                                } else {
                                    record.data.add(buffer.toString());
                                    buffer = buffer.delete(0, buffer.length());
                                    beginColumn = true;
                                }
                            } else if (thisChar == '\"') {
                                int nextChar = 32;
                                if (i + 1 < line.length()) {
                                    nextChar = line.charAt(i + 1);
                                }
                                if (quoteBegin && nextChar == 34) {
                                    buffer.append(thisChar);
                                    ++i;
                                } else {
                                    record.data.add(buffer.toString());
                                    buffer = buffer.delete(0, buffer.length());
                                    beginColumn = true;
                                    if (nextChar == 44) {
                                        ++i;
                                    }
                                }
                            } else {
                                buffer.append(thisChar);
                            }
                            if (i != line.length() - 1) continue;
                            if (quoteBegin && !beginColumn) {
                                done = false;
                                continue;
                            }
                            if (!quoteBegin) {
                                record.data.add(buffer.toString());
                                buffer = buffer.delete(0, buffer.length());
                                done = true;
                                continue;
                            }
                            done = true;
                        }
                        continue;
                    }
                    done = true;
                }
            }
            catch (Exception e) {
                if (System.getProperty("DEBUG") == null) break block25;
                e.printStackTrace();
            }
        }
        if ("".equals(record.line)) {
            return null;
        }
        return record;
    }

    public Record retrieveCustomLine() {
        return null;
    }

    public Record retrieveActLine() {
        return null;
    }

    public String padLine(String line, int padCount) {
        String paddedLine = line;
        try {
            switch (this.fileType) {
                case 8: {
                    paddedLine = this.padExcelCSVLine(line, padCount);
                    break;
                }
                case 7: {
                    paddedLine = this.padCustomLine(line, padCount);
                    break;
                }
                case 9: {
                    paddedLine = this.padActLine(line, padCount);
                    break;
                }
            }
        }
        catch (Exception e) {
            paddedLine = line;
        }
        return paddedLine;
    }

    public String padExcelCSVLine(String line, int padCount) {
        for (int i = 0; i < padCount; ++i) {
            line = line + ",";
        }
        return line;
    }

    public String padCustomLine(String line, int padCount) {
        return line;
    }

    public String padActLine(String line, int padCount) {
        return line;
    }

    public static class Record {
        public String line = "";
        public ArrayList data = null;
        public String columnDelimiter = "";

        public boolean isEmpty() {
            for (String column : this.data) {
                if (column == null || "".equals(column.trim())) continue;
                return false;
            }
            this.columnDelimiter = ",";
            StringTokenizer st = new StringTokenizer(this.line, this.columnDelimiter);
            while (st.hasMoreTokens()) {
                String column = st.nextToken();
                if ("".equals(column.trim())) continue;
                return false;
            }
            return true;
        }
    }
}

