/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.util.ArrayList;
import org.aspcfs.apps.transfer.writer.cfshttpxmlwriter.CFSHttpXMLWriter;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CRMConnection
extends CFSHttpXMLWriter {
    public CRMConnection() {
        this.setId("CRMConnection");
        this.setSystemId(4);
    }

    public int getRecordCount() {
        try {
            XMLUtils xml = new XMLUtils(this.getLastResponse());
            Element response = xml.getFirstChild("response");
            Element recordSet = XMLUtils.getFirstChild(response, "recordSet");
            if (recordSet != null && recordSet.hasAttributes()) {
                return Integer.parseInt(recordSet.getAttribute("count"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int getStatus() {
        try {
            XMLUtils xml = new XMLUtils(this.getLastResponse());
            Element response = xml.getFirstChild("response");
            Element status = XMLUtils.getFirstChild(response, "status");
            if (status != null) {
                return Integer.parseInt(XMLUtils.getNodeText(status));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public String getResponseValue(String fieldName) {
        try {
            XMLUtils xml = new XMLUtils(this.getLastResponse());
            Element response = xml.getFirstChild("response");
            Element recordSet = XMLUtils.getFirstChild(response, "recordSet");
            Element record = XMLUtils.getFirstChild(recordSet, "record");
            NodeList objectElements = record.getChildNodes();
            for (int j = 0; j < objectElements.getLength(); ++j) {
                Node theObject = objectElements.item(j);
                if (theObject.getNodeType() != 1) continue;
                String param = theObject.getNodeName();
                String value = XMLUtils.getNodeText(theObject);
                if (!param.equals(fieldName)) continue;
                return value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public ArrayList getRecords(String className) {
        int count = this.getRecordCount();
        ArrayList records = new ArrayList();
        try {
            ArrayList elements = new ArrayList();
            XMLUtils xml = new XMLUtils(this.getLastResponse());
            Element response = xml.getFirstChild("response");
            Element recordSet = XMLUtils.getFirstChild(response, "recordSet");
            XMLUtils.getAllChildren(recordSet, elements);
            for (Element element : elements) {
                Object object = Class.forName(className).newInstance();
                XMLUtils.populateObject(object, element);
                records.add(object);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return records;
    }
}

