/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.modules.base.EmailAddress;
import org.aspcfs.modules.base.EmailAddressList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;

public class ContactUtils {
    public static String foundDuplicateLastName(Connection db, String lastName, int siteId) throws SQLException {
        if (lastName != null && !"".equals(lastName)) {
            ContactList contacts = new ContactList();
            contacts.setLastName(lastName);
            contacts.setSiteId(siteId);
            contacts.setExclusiveToSite(true);
            if (siteId == -1) {
                contacts.setIncludeAllSites(true);
            }
            contacts.buildList(db);
            if (contacts.size() > 1) {
                return ((Contact)((Object)contacts.get(0))).getNameFull();
            }
        }
        return "";
    }

    public static boolean hasDuplicateLastName(Connection db, String lastName, String userIdRange, boolean hasAcPermission, boolean hasGcPermission) throws SQLException {
        boolean result = false;
        int i = 0;
        if (lastName == null || "".equals(lastName)) {
            return result;
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer("SELECT COUNT(*) AS record_count FROM contact WHERE lead = ? AND employee = ? AND (status_id IS NULL OR status_id = ?) AND (" + DatabaseUtils.toLowerCase(db) + "(namelast) = ? AND namelast IS NOT NULL) " + "AND trashed_date IS NULL " + "AND enabled = ? ");
        if (!hasAcPermission || !hasGcPermission) {
            sql.append("AND ( ");
        }
        if (!hasAcPermission) {
            sql.append("(org_id IS NULL AND owner IN (" + userIdRange + ")) ");
        }
        if (!hasAcPermission && !hasGcPermission) {
            sql.append("OR ");
        }
        if (!hasGcPermission) {
            sql.append("org_id IS NOT NULL ");
        }
        if (!hasAcPermission || !hasGcPermission) {
            sql.append(") ");
        }
        pst = db.prepareStatement(sql.toString());
        pst.setBoolean(++i, false);
        pst.setBoolean(++i, false);
        pst.setInt(++i, 7);
        pst.setString(++i, lastName.toLowerCase());
        pst.setBoolean(++i, true);
        rs = pst.executeQuery();
        if (rs.next() && rs.getInt("record_count") > 0) {
            result = true;
        }
        rs.close();
        pst.close();
        return result;
    }

    public static ContactList foundDuplicateCompany(Connection db, String companyName, int siteId) throws SQLException {
        ContactList contacts = new ContactList();
        if (companyName != null && !"".equals(companyName)) {
            contacts.setCompany(companyName);
            contacts.setSiteId(siteId);
            contacts.setExclusiveToSite(true);
            if (siteId == -1) {
                contacts.setIncludeAllSites(true);
            }
            contacts.buildList(db);
        }
        return contacts;
    }

    public static String hasDuplicateCompany(Connection db, String company, String userIdRange, boolean hasAccountPermission, boolean hasGcPermission) throws SQLException {
        StringBuffer result = new StringBuffer("");
        if (company == null || "".equals(company.trim())) {
            return result.toString();
        }
        int i = 0;
        PreparedStatement pst = null;
        ResultSet rs = null;
        if (hasGcPermission) {
            pst = db.prepareStatement("SELECT COUNT(*) AS record_count FROM contact WHERE lead = ? AND employee = ? AND (status_id IS NULL OR status_id = ?) AND enabled = ? AND org_id IS NULL AND (" + DatabaseUtils.toLowerCase(db) + "(company) = ? AND company IS NOT NULL) " + "AND trashed_date IS NULL " + "AND owner IN (" + userIdRange + ") ");
            pst.setBoolean(++i, false);
            pst.setBoolean(++i, false);
            pst.setInt(++i, 7);
            pst.setBoolean(++i, true);
            pst.setString(++i, company.toLowerCase());
            rs = pst.executeQuery();
            if (rs.next() && rs.getInt("record_count") > 0) {
                result.append("general_contact");
            }
            rs.close();
            pst.close();
        }
        if (hasAccountPermission) {
            int recordCount;
            i = 0;
            pst = db.prepareStatement("SELECT COUNT(*) AS record_count FROM organization WHERE " + DatabaseUtils.toLowerCase(db) + "(name) = ? " + "AND trashed_date IS NULL " + "AND enabled = ? ");
            pst.setString(++i, company.toLowerCase());
            pst.setBoolean(++i, true);
            rs = pst.executeQuery();
            if (rs.next() && (recordCount = rs.getInt("record_count")) > 0) {
                if (!"".equals(result.toString())) {
                    result.append("|");
                }
                result.append("account");
            }
            rs.close();
            pst.close();
        }
        return result.toString();
    }

    public static String foundDuplicateEmailAddress(Connection db, String emailAddress, int siteId) throws SQLException {
        if (emailAddress != null && !"".equals(emailAddress)) {
            ContactList contacts = new ContactList();
            contacts.setEmailAddress(emailAddress);
            contacts.setSiteId(siteId);
            contacts.setExclusiveToSite(true);
            if (siteId == -1) {
                contacts.setIncludeAllSites(true);
            }
            contacts.buildList(db);
            if (contacts.size() > 1) {
                return ((Contact)((Object)contacts.get(0))).getNameFull();
            }
        }
        return "";
    }

    public static HashMap hasDuplicateEmailAddresses(Connection db, String emailAddresses, String userIdRange, boolean hasGcPermission, boolean hasAcPermission) throws SQLException {
        int i = 0;
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (emailAddresses == null || "".equals(emailAddresses.trim())) {
            return map;
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer("SELECT ce.email AS email, COUNT(c.contact_id) AS record_count FROM contact_emailaddress ce LEFT JOIN contact c ON (ce.contact_id = c.contact_id ) AND c.lead = ? AND c.employee = ? AND (c.status_id IS NULL OR c.status_id = ?) AND c.trashed_date IS NULL AND c.enabled = ? AND ce.email IN (" + StringUtils.parseToDbString(emailAddresses) + ") " + "AND c.owner IN (" + userIdRange + ") " + "GROUP BY ce.email ");
        if (!hasAcPermission) {
            sql.append("AND c.org_id IS NULL ");
        }
        if (!hasGcPermission) {
            sql.append("AND c.org_id IS NOT NULL ");
        }
        pst = db.prepareStatement(sql.toString());
        pst.setBoolean(++i, false);
        pst.setBoolean(++i, false);
        pst.setInt(++i, 7);
        pst.setBoolean(++i, true);
        rs = pst.executeQuery();
        while (rs.next()) {
            String email = rs.getString("email");
            int recordCount = rs.getInt("record_count");
            if (recordCount > 0) {
                map.put(email, new Boolean(true));
                continue;
            }
            map.put(email, new Boolean(false));
        }
        rs.close();
        pst.close();
        return map;
    }

    public static HashMap foundDuplicateEmailAddresses(Connection db, EmailAddressList emailAddresses, int siteId) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (EmailAddress emailAddress : emailAddresses) {
            ContactList contacts = new ContactList();
            contacts.setSiteId(siteId);
            contacts.setExclusiveToSite(true);
            if (siteId == -1) {
                contacts.setIncludeAllSites(true);
            }
            contacts.setEmailAddress(emailAddress.getEmail());
            contacts.buildList(db);
            if (contacts.size() <= 1) continue;
            map.put(emailAddress.getEmail(), ((Contact)((Object)contacts.get(0))).getNameFull());
        }
        return map;
    }

    public static boolean checkNameMatch(String nameLastFirst, String lastName, String firstName) {
        boolean result = false;
        String givenName = Contact.getNameLastFirst(lastName, firstName);
        if (givenName.equals(nameLastFirst)) {
            result = true;
        }
        return result;
    }
}

