/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.util.Calendar;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.utils.web.HtmlSelect;

public class CreditCardUtils {
    public static final String VISA = "Visa";
    public static final String MASTER_CARD = "Master Card";
    public static final String AMERICAN_EXPRESS = "American Express";
    public static final String DISCOVER = "Discover";
    private String nameOnCard = null;
    private String type = null;
    private String number = null;
    private String expirationMonth = null;
    private String expirationYear = null;
    private HashMap errors = new HashMap();

    public void setNameOnCard(String tmp) {
        this.nameOnCard = tmp;
    }

    public void setType(String tmp) {
        this.type = tmp;
    }

    public void setNumber(String tmp) {
        this.number = tmp;
    }

    public void setExpirationMonth(String tmp) {
        this.expirationMonth = tmp;
    }

    public void setExpirationYear(String tmp) {
        this.expirationYear = tmp;
    }

    public String getNameOnCard() {
        return this.nameOnCard;
    }

    public String getType() {
        return this.type;
    }

    public String getNumber() {
        return this.number;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public boolean isValid() {
        this.errors.clear();
        if (this.nameOnCard == null || "".equals(this.nameOnCard.trim())) {
            this.errors.put("nameOnCardError", "Name on Card is required");
        }
        if (this.type == null || "".equals(this.type.trim())) {
            this.errors.put("typeError", "Payment Type is required");
        }
        if (this.number == null || "".equals(this.number.trim())) {
            this.errors.put("numberError", "Credit Card number is required");
        }
        System.out.println("CreditCardUtils -> expirationYear : " + this.expirationYear);
        System.out.println("CreditCardUtils -> expirationMonth : " + this.expirationMonth);
        if (this.expirationMonth != null && !"".equals(this.expirationMonth.trim()) && this.expirationYear != null && !"".equals(this.expirationYear.trim())) {
            Calendar today = Calendar.getInstance();
            int year = today.get(1);
            int month = today.get(2) + 1;
            if (year == Integer.parseInt(this.expirationYear) && month + 1 > Integer.parseInt(this.expirationMonth)) {
                this.errors.put("expirationMonthError", "The card seems to have expired");
            }
        }
        if (!this.hasErrors()) {
            this.checkCardValidity(this.type, this.number);
        }
        return !this.hasErrors();
    }

    private boolean checkCardNumWithMod10(String cardNum) {
        int i = 0;
        double[] cc = new double[16];
        double checksum = 0.0;
        boolean validcc = false;
        for (i = 0; i < cardNum.length(); ++i) {
            cc[i] = Math.floor(Double.parseDouble(cardNum.substring(i, i + 1)));
        }
        for (i = cardNum.length() % 2; i < cardNum.length(); i += 2) {
            double a = cc[i] * 2.0;
            if (a >= 10.0) {
                String aStr = String.valueOf(a);
                String b = aStr.substring(0, 1);
                String c = aStr.substring(1, 2);
                cc[i] = Math.floor(Double.parseDouble(b)) + Math.floor(Double.parseDouble(c));
                continue;
            }
            cc[i] = a;
        }
        for (i = 0; i < cardNum.length(); ++i) {
            checksum += Math.floor(cc[i]);
        }
        validcc = checksum % 10.0 == 0.0;
        return validcc;
    }

    private String cleanCardNum(String cardNum) {
        String ch = "";
        String allowed = "0123456789";
        StringBuffer newCard = new StringBuffer();
        for (int i = 0; i < cardNum.length(); ++i) {
            ch = cardNum.substring(i, i + 1);
            if (allowed.indexOf(ch) > -1) {
                newCard.append(ch);
                continue;
            }
            if (" ".equals(ch) || "-".equals(ch)) continue;
            this.errors.put("numberError", "card number contains invalid characters");
            return "";
        }
        return newCard.toString().trim();
    }

    public boolean checkCardValidity(String cardType, String cardNum) {
        String validCard = "";
        int cardLength = 0;
        boolean cardLengthOK = false;
        int cardStart = 0;
        boolean cardStartOK = false;
        if (!cardType.equals(VISA)) {
            if (!cardType.equals(MASTER_CARD)) {
                if (!cardType.equals(AMERICAN_EXPRESS)) {
                    if (!cardType.equals(DISCOVER)) {
                        this.errors.put("typeError", "credit card type is invalid");
                        return false;
                    }
                }
            }
        }
        cardType = cardType.substring(0, 1);
        validCard = this.cleanCardNum(cardNum);
        if (!"".equals(validCard)) {
            cardStart = Integer.parseInt(validCard.substring(0, 1));
            boolean bl = cardStartOK = cardType.equals("V") && cardStart == 4 || cardType.equals("M") && cardStart == 5 || cardType.equals("A") && cardStart == 3 || cardType.equals("D") && cardStart == 6;
            if (!cardStartOK) {
                this.errors.put("numberError", "card number does not match the card type selected.");
                return false;
            }
            cardLength = validCard.length();
            boolean bl2 = cardLengthOK = cardType.equals("V") && (cardLength == 13 || cardLength == 16) || cardType.equals("M") && cardLength == 16 || cardType.equals("A") && cardLength == 15 || cardType.equals("D") && cardLength == 16;
            if (!cardLengthOK) {
                this.errors.put("numberError", "make sure you've entered all of the digits on your card.");
                return false;
            }
            if (this.checkCardNumWithMod10(validCard)) {
                return true;
            }
            this.errors.put("numberError", "Please make sure you've entered your card number correctly.");
            return false;
        }
        return false;
    }

    public void setRequestItems(HttpServletRequest request) {
        if (request.getParameter("nameOnCard") != null) {
            this.nameOnCard = request.getParameter("nameOnCard");
        }
        if (request.getParameter("type") != null) {
            this.type = request.getParameter("type");
        }
        if (request.getParameter("number") != null) {
            this.number = request.getParameter("number");
        }
        if (request.getParameter("expirationMonth") != null) {
            this.expirationMonth = request.getParameter("expirationMonth");
        }
        if (request.getParameter("expirationYear") != null) {
            this.expirationYear = request.getParameter("expirationYear");
        }
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public HtmlSelect getSelectExpirationMonth() {
        HtmlSelect select = new HtmlSelect();
        select.setDefaultValue(this.expirationMonth);
        for (int i = 1; i <= 12; ++i) {
            select.addItem(Integer.toString(i));
        }
        return select;
    }

    public HtmlSelect getSelectExpirationYear() {
        HtmlSelect select = new HtmlSelect();
        Calendar today = Calendar.getInstance();
        int year = today.get(1);
        select.setDefaultValue(this.expirationYear);
        for (int i = year; i <= year + 10; ++i) {
            select.addItem(Integer.toString(i));
        }
        return select;
    }

    public String displayOnlyLastFour() {
        String display = "";
        if (this.number != null) {
            int length = this.number.length();
            for (int i = 0; i < length; ++i) {
                char c = this.number.charAt(i);
                if (c == ' ' || c == '-') continue;
                if (i < length - 4) {
                    display = display + "x";
                }
                if (i == length - 4) {
                    display = display + "-" + c;
                }
                if (i <= length - 4) continue;
                display = display + c;
            }
        }
        return display.trim();
    }
}

