/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import java.util.ResourceBundle;

public class CurrencyFormat {
    Locale[] locales = NumberFormat.getAvailableLocales();
    DecimalFormatSymbols currencySymbols = new DecimalFormatSymbols(Locale.US);

    public String getCurrency(double dollarAmount) {
        return CurrencyFormat.formatCurrency(dollarAmount, this.currencySymbols, Locale.US);
    }

    private static String formatCurrency(double value, DecimalFormatSymbols currencySymbols, Locale displayLocale) {
        ResourceBundle resource = ResourceBundle.getBundle("java.text.resources.LocaleElements", displayLocale);
        String[] numberPatterns = resource.getStringArray("NumberPatterns");
        int moneySignAt = numberPatterns[1].indexOf(164);
        String pattern = numberPatterns[1].substring(0, moneySignAt) + "\u00a4\u00a4" + numberPatterns[1].substring(moneySignAt);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(displayLocale);
        symbols.setCurrencySymbol(currencySymbols.getCurrencySymbol());
        symbols.setInternationalCurrencySymbol(currencySymbols.getInternationalCurrencySymbol());
        DecimalFormat df = new DecimalFormat(pattern, symbols);
        return CurrencyFormat.justify(displayLocale.getDisplayName()) + df.format(value);
    }

    private static String justify(String s) {
        StringBuffer buf = new StringBuffer(s);
        int end = 35 - s.length();
        for (int i = 0; i < end; ++i) {
            buf.append(".");
        }
        return buf.toString();
    }

    public static String getCurrencyString(Double value, Locale locale) {
        String currencyAsString = "";
        try {
            NumberFormat nf = NumberFormat.getInstance(locale);
            currencyAsString = nf.format(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currencyAsString;
    }

    public static String getCurrencyString(double value, Locale locale, String code) {
        NumberFormat formatter = NumberFormat.getCurrencyInstance(locale);
        formatter.setMaximumFractionDigits(4);
        if (code != null) {
            Currency currency = Currency.getInstance(code);
            formatter.setCurrency(currency);
        }
        return formatter.format(value);
    }
}

