/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.actions.ActionContext;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.aspcfs.utils.web.PagedListInfo;

public class DatabaseUtils {
    public static final String CRLF = System.getProperty("line.separator");
    public static final String qsDefault = "\"";
    public static final String qsMySQL = "`";
    public static final int POSTGRESQL = 1;
    public static final int MSSQL = 2;
    public static final int ORACLE = 3;
    public static final int FIREBIRD = 4;
    public static final int DAFFODILDB = 5;
    public static final int DB2 = 6;
    public static final int MYSQL = 7;
    public static final int DERBY = 8;
    public static final int INTERBASE = 9;
    public static final String sqlReservedWords = ",language,password,level,type,position,second,minute,hour,month,dayofweek,year,length,message,active,role,number,module,section,value,size,version,display,parameter,action,global,access,lock,comment,";
    public static final int DAY = 1;
    public static final int WEEK = 2;
    public static final int MONTH = 3;
    public static final int YEAR = 4;
    public static final int HOUR = 5;
    public static final int MINUTE = 6;
    public static final int SECOND = 7;
    static final long POSSIBLE_QUERY_TIME = 3000L;

    public static String getTrue(Connection db) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return "true";
            }
            case 2: {
                return "1";
            }
            case 5: {
                return "true";
            }
            case 3: {
                return "1";
            }
            case 6: {
                return "'1'";
            }
            case 4: {
                return "'Y'";
            }
            case 7: {
                return "1";
            }
            case 8: {
                return "'1'";
            }
            case 9: {
                return "true";
            }
        }
        return "true";
    }

    public static String getFalse(Connection db) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return "false";
            }
            case 2: {
                return "0";
            }
            case 5: {
                return "false";
            }
            case 3: {
                return "0";
            }
            case 6: {
                return "'0'";
            }
            case 4: {
                return "'N'";
            }
            case 7: {
                return "0";
            }
            case 8: {
                return "'0'";
            }
            case 9: {
                return "false";
            }
        }
        return "false";
    }

    public static String getCurrentTimestamp(Connection db) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return "CURRENT_TIMESTAMP";
            }
            case 2: {
                return "CURRENT_TIMESTAMP";
            }
            case 5: {
                return "CURRENT_TIMESTAMP";
            }
            case 3: {
                return "CURRENT_TIMESTAMP";
            }
            case 6: {
                return "CURRENT_TIMESTAMP";
            }
            case 4: {
                return "CURRENT_TIMESTAMP";
            }
            case 7: {
                return "CURRENT_TIMESTAMP";
            }
            case 8: {
                return "CURRENT_TIMESTAMP";
            }
            case 9: {
                return "CURRENT_TIMESTAMP";
            }
        }
        return "CURRENT_TIMESTAMP";
    }

    public static int getType(Connection db) {
        String databaseName = db.getClass().getName();
        if (databaseName.indexOf("postgresql") > -1) {
            return 1;
        }
        if ("net.sourceforge.jtds.jdbc.ConnectionJDBC3".equals(databaseName)) {
            return 2;
        }
        if ("net.sourceforge.jtds.jdbc.TdsConnectionJDBC3".equals(databaseName)) {
            return 2;
        }
        if (databaseName.indexOf("sqlserver") > -1) {
            return 2;
        }
        if ("net.sourceforge.jtds.jdbc.TdsConnection".equals(databaseName)) {
            return 2;
        }
        if ("org.firebirdsql.jdbc.FBConnection".equals(databaseName)) {
            return 4;
        }
        if ("org.firebirdsql.jdbc.FBDriver".equals(databaseName)) {
            return 4;
        }
        if ("oracle.jdbc.driver.OracleConnection".equals(databaseName)) {
            return 3;
        }
        if (databaseName.indexOf("oracle") > -1) {
            return 3;
        }
        if ("in.co.daffodil.db.jdbc.DaffodilDBConnection".equals(databaseName)) {
            return 5;
        }
        if (databaseName.indexOf("db2") > -1) {
            return 6;
        }
        if (databaseName.indexOf("mysql") > -1) {
            return 7;
        }
        if (databaseName.indexOf("derby") > -1) {
            return 8;
        }
        if ("interbase.interclient.Connection".equals(databaseName)) {
            return 9;
        }
        System.out.println("DatabaseUtils-> Unkown Connection Class: " + databaseName);
        return -1;
    }

    public static String getTypeName(Connection db) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return "postgresql";
            }
            case 2: {
                return "mssql";
            }
            case 4: {
                return "firebird";
            }
            case 3: {
                return "oracle";
            }
            case 5: {
                return "daffodildb";
            }
            case 6: {
                return "db2";
            }
            case 7: {
                return "mysql";
            }
            case 8: {
                return "derby";
            }
            case 9: {
                return "interbase";
            }
        }
        return "unknown";
    }

    public static String castDateTimeToDate(Connection db, String date) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return date + "::date";
            }
            case 2: {
                return "CONVERT(char(10), " + date + ", 101)";
            }
            case 4: {
                return "EXTRACT(DATE FROM " + date + ")";
            }
            case 5: {
                return "DATE(" + date + ")";
            }
            case 3: {
                return "TO_DATE(" + date + ",'dd/mm/yyyy')";
            }
            case 6: {
                return "CAST(" + date + " AS DATE)";
            }
            case 7: {
                return "DATE(" + date + ")";
            }
            case 8: {
                return "DATE(" + date + ")";
            }
            case 9: {
                return "CAST(" + date + " AS DATE)";
            }
        }
        return "";
    }

    public static String addTimestampInterval(Connection db, int units, String termsColumnName, String timestampColumnName) {
        String addTimestampIntervalString = "";
        String customUnits = "";
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                if (units == 1) {
                    customUnits = "days";
                } else if (units == 2) {
                    customUnits = "weeks";
                } else if (units == 3) {
                    customUnits = "months";
                } else if (units == 4) {
                    customUnits = "years";
                }
                addTimestampIntervalString = timestampColumnName + " + ( (" + termsColumnName + " + 1 )::text || ' " + customUnits + "')::interval ";
                break;
            }
            case 2: {
                if (units != 1) {
                    if (units == 2) {
                        customUnits = "WEEK";
                    } else if (units == 3) {
                        customUnits = "MONTH";
                    } else if (units == 4) {
                        customUnits = "YEAR";
                    }
                }
                addTimestampIntervalString = " DATEADD(" + customUnits + ",(" + termsColumnName + " + 1)," + timestampColumnName + ")";
                break;
            }
            case 4: 
            case 9: {
                if (units == 1) {
                    addTimestampIntervalString = " (" + timestampColumnName + " + " + termsColumnName + ") ";
                    break;
                }
                if (units == 2) {
                    addTimestampIntervalString = " (" + timestampColumnName + " + (" + termsColumnName + " * 7)) ";
                    break;
                }
                if (units == 3) {
                    addTimestampIntervalString = " (" + timestampColumnName + " + (" + termsColumnName + " * 30)) ";
                    break;
                }
                if (units != 4) break;
                addTimestampIntervalString = " (" + timestampColumnName + " + (" + termsColumnName + " * 365)) ";
                break;
            }
            case 5: {
                if (units != 1) {
                    if (units == 2) {
                        customUnits = "SQL_TSI_WEEK";
                    } else if (units == 3) {
                        customUnits = "SQL_TSI_MONTH";
                    } else if (units == 4) {
                        customUnits = "SQL_TSI_YEAR";
                    }
                }
                addTimestampIntervalString = " TIMESTAMPADD(" + customUnits + ",(" + termsColumnName + " + 1)," + timestampColumnName + ")";
                break;
            }
            case 6: {
                if (units == 1) {
                    addTimestampIntervalString = timestampColumnName + " + (" + termsColumnName + "+1) day ";
                    break;
                }
                if (units == 2) {
                    addTimestampIntervalString = timestampColumnName + " + ((" + termsColumnName + "+1)*7) day ";
                    break;
                }
                if (units == 3) {
                    addTimestampIntervalString = timestampColumnName + " + (" + termsColumnName + "+1) month ";
                    break;
                }
                if (units != 4) break;
                addTimestampIntervalString = timestampColumnName + " + (" + termsColumnName + "+1) year ";
                break;
            }
            case 3: {
                if (units == 1) {
                    addTimestampIntervalString = " (" + timestampColumnName + " + NUMTODSINTERVAL(" + termsColumnName + " ,'day')) ";
                    break;
                }
                if (units == 2) {
                    addTimestampIntervalString = " (" + timestampColumnName + " + NUMTODSINTERVAL(" + termsColumnName + " * 7 ,'day'))";
                    break;
                }
                if (units == 3) {
                    addTimestampIntervalString = " (" + timestampColumnName + " + NUMTOYMINTERVAL(" + termsColumnName + ", 'month')) ";
                    break;
                }
                if (units != 4) break;
                addTimestampIntervalString = " (" + timestampColumnName + " + NUMTOYMINTERVAL(" + termsColumnName + ", 'year')) ";
                break;
            }
            case 7: {
                if (units != 1) {
                    if (units == 2) {
                        customUnits = "WEEK";
                    } else if (units == 3) {
                        customUnits = "MONTH";
                    } else if (units == 4) {
                        customUnits = "YEAR";
                    }
                }
                addTimestampIntervalString = " ADDDATE(" + timestampColumnName + ", INTERVAL " + termsColumnName + "+1 " + customUnits + ")";
                break;
            }
            case 8: {
                if (units == 1) {
                    customUnits = "SQL_TSI_DAY";
                } else if (units == 2) {
                    customUnits = "SQL_TSI_WEEK";
                } else if (units == 3) {
                    customUnits = "SQL_TSI_MONTH";
                } else if (units == 4) {
                    customUnits = "SQL_TSI_YEAR";
                }
                addTimestampIntervalString = " {fn TIMESTAMPADD(" + customUnits + ", CAST(" + termsColumnName + "+1 AS INTEGER), " + timestampColumnName + ")}";
            }
        }
        return addTimestampIntervalString;
    }

    public static String addTimestampInterval(Connection db, int units, String termsColumnName, String timestampColumnName, String defaultUnits, long defaultTerms) {
        String addTimestampIntervalString = "";
        String customUnits = "";
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                if (units == 2) {
                    customUnits = "weeks";
                }
                addTimestampIntervalString = timestampColumnName + " + ( (" + termsColumnName + " + " + (defaultTerms + 1L) + " )::text || ' " + customUnits + "')::interval ";
                break;
            }
            case 2: {
                if (units == 2) {
                    customUnits = "WEEK";
                }
                addTimestampIntervalString = " DATEADD(" + customUnits + ",(" + termsColumnName + " + " + (defaultTerms + 1L) + ")," + timestampColumnName + ")";
                break;
            }
            case 4: 
            case 9: {
                addTimestampIntervalString = " (" + timestampColumnName + " + ((" + termsColumnName + " + " + defaultTerms + 1 + ") * 7)) ";
                break;
            }
            case 5: {
                if (units == 2) {
                    customUnits = "SQL_TSI_WEEK";
                }
                addTimestampIntervalString = " TIMESTAMPADD(" + customUnits + ",(" + termsColumnName + " + " + (defaultTerms + 1L) + ")," + timestampColumnName + ")";
                break;
            }
            case 6: {
                if (units != 2) break;
                addTimestampIntervalString = timestampColumnName + " + ((" + termsColumnName + "+" + defaultTerms + "+1)*7) day ";
                break;
            }
            case 3: {
                addTimestampIntervalString = " (" + timestampColumnName + " + ((" + termsColumnName + " + " + defaultTerms + 1 + ") * 7)) ";
                break;
            }
            case 7: {
                if (units == 2) {
                    customUnits = "WEEK";
                }
                addTimestampIntervalString = " ADDDATE(" + timestampColumnName + ", INTERVAL (" + termsColumnName + " + " + (defaultTerms + 1L) + ") " + customUnits + ")";
                break;
            }
            case 8: {
                if (units == 2) {
                    customUnits = "SQL_TSI_WEEK";
                }
                addTimestampIntervalString = "fn{ TIMESTAMPADD(" + customUnits + ", CAST(" + termsColumnName + " + " + (defaultTerms + 1L) + " AS INTEGER)," + timestampColumnName + ")}";
            }
        }
        return addTimestampIntervalString;
    }

    public static int getNextSeq(Connection db, String origSequenceName) throws SQLException {
        int typeId = DatabaseUtils.getType(db);
        if (typeId == 1 || typeId == 2 || typeId == 7 || typeId == 8) {
            return -1;
        }
        int id = -1;
        Statement st = db.createStatement();
        ResultSet rs = null;
        String sequenceName = DatabaseUtils.getSequenceName(db, origSequenceName);
        switch (typeId) {
            case 4: 
            case 9: {
                rs = st.executeQuery("SELECT GEN_ID (" + sequenceName + ",1) FROM RDB$DATABASE");
                break;
            }
            case 5: {
                rs = st.executeQuery("SELECT " + sequenceName + ".nextval from dual");
                break;
            }
            case 3: {
                rs = st.executeQuery("SELECT " + sequenceName + ".nextval from dual");
                break;
            }
            case 6: {
                rs = st.executeQuery("VALUES NEXTVAL FOR " + sequenceName);
                break;
            }
        }
        if (rs.next()) {
            id = rs.getInt(1);
        }
        rs.close();
        st.close();
        return id;
    }

    public static String getSequenceName(Connection db, String sequenceName) {
        int typeId = DatabaseUtils.getType(db);
        switch (typeId) {
            case 4: 
            case 9: {
                if (sequenceName.length() <= 31) break;
                String seqPart1 = sequenceName.substring(0, 13);
                String seqPart2 = sequenceName.substring(14);
                sequenceName = seqPart1 + "_" + seqPart2.substring(seqPart2.length() - 17);
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                if (sequenceName.length() <= 30) break;
                String seqPart1 = sequenceName.substring(0, 13);
                String seqPart2 = sequenceName.substring(14);
                sequenceName = seqPart1 + "_" + seqPart2.substring(seqPart2.length() - 16);
                break;
            }
            case 6: {
                if (sequenceName.length() <= 30) break;
                String seqPart1 = sequenceName.substring(0, 13);
                String seqPart2 = sequenceName.substring(14);
                sequenceName = seqPart1 + "_" + seqPart2.substring(seqPart2.length() - 16);
                break;
            }
        }
        return sequenceName;
    }

    public static int getCurrVal(Connection db, String sequenceName, int defaultValue) throws SQLException {
        int typeId = DatabaseUtils.getType(db);
        if (typeId != 1 && typeId != 2 && typeId != 7 && typeId != 8) {
            return defaultValue;
        }
        int id = -1;
        Statement st = db.createStatement();
        ResultSet rs = null;
        switch (typeId) {
            case 1: {
                rs = st.executeQuery("SELECT currval('" + sequenceName + "')");
                break;
            }
            case 2: {
                rs = st.executeQuery("SELECT @@IDENTITY");
                break;
            }
            case 7: {
                rs = st.executeQuery("SELECT LAST_INSERT_ID()");
                break;
            }
            case 8: {
                rs = st.executeQuery("VALUES IDENTITY_VAL_LOCAL()");
                break;
            }
        }
        if (rs.next()) {
            id = rs.getInt(1);
        }
        rs.close();
        st.close();
        return id;
    }

    public static String getYearPart(Connection db, String fieldname) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return "date_part('year', " + fieldname + ")";
            }
            case 2: {
                return "DATEPART(YY, " + fieldname + ")";
            }
            case 4: 
            case 9: {
                return "EXTRACT(YEAR FROM " + fieldname + ")";
            }
            case 5: {
                return "YEAR(" + fieldname + ")";
            }
            case 3: {
                return "EXTRACT(YEAR FROM " + fieldname + ")";
            }
            case 6: {
                return "YEAR(" + fieldname + ")";
            }
            case 7: {
                return "YEAR(" + fieldname + ")";
            }
            case 8: {
                return "YEAR(" + fieldname + ")";
            }
        }
        return "";
    }

    public static String getTempTableName(Connection db, String tableName) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return tableName;
            }
            case 2: {
                return "#" + tableName;
            }
            case 4: {
                return "";
            }
            case 5: {
                return "";
            }
            case 3: {
                return "";
            }
            case 6: {
                return "SESSION." + tableName;
            }
            case 7: {
                return "";
            }
            case 8: {
                return "";
            }
            case 9: {
                return "";
            }
        }
        return "";
    }

    public static String getMonthPart(Connection db, String fieldname) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return "date_part('month', " + fieldname + ")";
            }
            case 2: {
                return "DATEPART(MM, " + fieldname + ")";
            }
            case 4: 
            case 9: {
                return "EXTRACT(MONTH FROM " + fieldname + ")";
            }
            case 5: {
                return "MONTH(" + fieldname + ")";
            }
            case 3: {
                return "EXTRACT(MONTH FROM " + fieldname + ")";
            }
            case 6: {
                return "MONTH(" + fieldname + ")";
            }
            case 7: {
                return "MONTH(" + fieldname + ")";
            }
            case 8: {
                return "MONTH(" + fieldname + ")";
            }
        }
        return "";
    }

    public static String getDayPart(Connection db, String fieldname) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return "date_part('day', " + fieldname + ")";
            }
            case 2: {
                return "DATEPART(DD, " + fieldname + ")";
            }
            case 4: 
            case 9: {
                return "EXTRACT(DAY FROM " + fieldname + ")";
            }
            case 5: {
                return "DAYOFWEEK(" + fieldname + ")";
            }
            case 3: {
                return "EXTRACT(DAY FROM " + fieldname + ")";
            }
            case 6: {
                return "DAY(" + fieldname + ")";
            }
            case 7: {
                return "DAY(" + fieldname + ")";
            }
            case 8: {
                return "DAY(" + fieldname + ")";
            }
        }
        return "";
    }

    public static String getHourPart(Connection db, String fieldname) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return "date_part('hour', " + fieldname + ")";
            }
            case 2: {
                return "DATEPART(HH, " + fieldname + ")";
            }
            case 4: 
            case 9: {
                return "EXTRACT(HOUR FROM " + fieldname + ")";
            }
            case 3: 
            case 5: {
                return "EXTRACT(HOUR FROM " + fieldname + ")";
            }
            case 6: {
                return "HOUR(" + fieldname + ")";
            }
            case 7: {
                return "HOUR(" + fieldname + ")";
            }
            case 8: {
                return "HOUR(" + fieldname + ")";
            }
        }
        return "";
    }

    public static String getMinutePart(Connection db, String fieldname) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return "date_part('minute', " + fieldname + ")";
            }
            case 2: {
                return "DATEPART(M, " + fieldname + ")";
            }
            case 4: 
            case 9: {
                return "EXTRACT(MINUTE FROM " + fieldname + ")";
            }
            case 5: {
                return "DAYOFWEEK(" + fieldname + ")";
            }
            case 3: {
                return "EXTRACT(MINUTE FROM " + fieldname + ")";
            }
            case 6: {
                return "MINUTE(" + fieldname + ")";
            }
            case 7: {
                return "MINUTE(" + fieldname + ")";
            }
            case 8: {
                return "MINUTE(" + fieldname + ")";
            }
        }
        return "";
    }

    public static String toLowerCase(Connection db) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return "lower";
            }
            case 2: {
                return "lower";
            }
            case 3: {
                return "lower";
            }
            case 4: 
            case 9: {
                return "lower";
            }
            case 5: {
                return "lcase";
            }
            case 6: {
                return "lower";
            }
            case 7: {
                return "lower";
            }
            case 8: {
                return "lcase";
            }
        }
        return "lower";
    }

    public static String toLowerCase(Connection db, String field) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return "lower(" + field + ")";
            }
            case 2: {
                return "lower(" + field + ")";
            }
            case 3: {
                return "lower(" + field + ")";
            }
            case 4: 
            case 9: {
                return "lower(" + field + ")";
            }
            case 5: {
                return "lcase(" + field + ")";
            }
            case 6: {
                return "lower(" + field + ")";
            }
            case 7: {
                return "lower(" + field + ")";
            }
            case 8: {
                return "LCASE(" + field + ")";
            }
        }
        return "lower(" + field + ")";
    }

    public static String getSubString(Connection db, String field, int first, int size) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return "substr(" + field + "," + first + (size < 0 ? "" : "," + size) + ") ";
            }
            case 2: {
                return "substring(" + field + "," + first + (size < 0 ? "" : "," + size) + ") ";
            }
            case 3: {
                return "substr(" + field + "," + first + (size < 0 ? "" : "," + size) + ") ";
            }
            case 4: {
                return "substr(" + field + " FROM " + first + (size < 0 ? "" : " FOR " + size) + " ) ";
            }
            case 5: {
                return "substring(" + field + "," + first + (size < 0 ? "" : "," + size) + ") ";
            }
            case 6: {
                return "substr(" + field + "," + (first + 1) + (size < 0 ? "" : "," + size) + ") ";
            }
            case 7: {
                return "substr(" + field + "," + first + (size < 0 ? "" : "," + size) + ") ";
            }
            case 8: {
                return "substr(" + field + "," + (first + 1) + (size < 0 ? "" : "," + size) + ") ";
            }
            case 9: {
                return "substr(" + field + "," + (first + 1) + (size < 0 ? ", 32767" : "," + size) + " )";
            }
        }
        return "substr(" + field + "," + first + (size < 0 ? "" : "," + size) + ") ";
    }

    public static String convertToVarChar(Connection db, String field) {
        switch (DatabaseUtils.getType(db)) {
            case 1: {
                return field;
            }
            case 2: {
                return "CONVERT(VARCHAR(2000), " + field + ")";
            }
            case 3: {
                return "TO_CHAR(" + field + ")";
            }
            case 4: 
            case 9: {
                return field;
            }
            case 6: {
                return "CAST(" + field + " AS VARCHAR(32000))";
            }
            case 5: {
                return field;
            }
            case 7: {
                return field;
            }
            case 8: {
                return "CAST(" + field + " AS VARCHAR(32000))";
            }
        }
        return field;
    }

    public static int parseInt(String tmp, int defaultValue) {
        try {
            return Integer.parseInt(tmp);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean parseBoolean(String tmp) {
        return "ON".equalsIgnoreCase(tmp) || "TRUE".equalsIgnoreCase(tmp) || "1".equals(tmp) || "Y".equalsIgnoreCase(tmp) || "YES".equalsIgnoreCase(tmp);
    }

    public static Date parseDate(String tmp) {
        Date dateValue = null;
        try {
            java.util.Date tmpDate = DateFormat.getDateInstance(3).parse(tmp);
            dateValue = new Date(new java.util.Date().getTime());
            dateValue.setTime(tmpDate.getTime());
            return dateValue;
        }
        catch (Exception e) {
            try {
                return Date.valueOf(tmp);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static Timestamp parseTimestamp(String tmp) {
        return DatabaseUtils.parseTimestamp(tmp, Locale.getDefault());
    }

    public static Timestamp parseTimestamp(String tmp, Locale locale) {
        Timestamp timestampValue = null;
        try {
            java.util.Date tmpDate = DateFormat.getDateTimeInstance(3, 1, locale).parse(tmp);
            timestampValue = new Timestamp(new java.util.Date().getTime());
            timestampValue.setTime(tmpDate.getTime());
            return timestampValue;
        }
        catch (Exception e) {
            try {
                return Timestamp.valueOf(tmp);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static Timestamp parseTimestamp(String tmp, Locale locale, boolean beLenient) {
        Timestamp timestampValue = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy", locale);
            simpleDateFormat.setLenient(beLenient);
            java.util.Date tmpDate = simpleDateFormat.parse(tmp);
            timestampValue = new Timestamp(new java.util.Date().getTime());
            timestampValue.setTime(tmpDate.getTime());
            return timestampValue;
        }
        catch (Exception e) {
            try {
                return Timestamp.valueOf(tmp);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static Timestamp parseDateToTimestamp(String tmp) {
        return DatabaseUtils.parseDateToTimestamp(tmp, Locale.getDefault());
    }

    public static Timestamp parseDateToTimestamp(String tmp, Locale locale) {
        Timestamp timestampValue = DatabaseUtils.parseTimestamp(tmp, locale);
        if (timestampValue == null) {
            try {
                DateFormat tmpDateFormat = DateFormat.getDateInstance(3, locale);
                tmpDateFormat.setLenient(false);
                java.util.Date tmpDate = tmpDateFormat.parse(tmp);
                timestampValue = new Timestamp(System.currentTimeMillis());
                timestampValue.setTime(tmpDate.getTime());
                timestampValue.setNanos(0);
                return timestampValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return timestampValue;
    }

    public static int getInt(ResultSet rs, String column, int defaultValue) throws SQLException {
        int fieldValue = rs.getInt(column);
        if (rs.wasNull()) {
            fieldValue = defaultValue;
        }
        return fieldValue;
    }

    public static double getDouble(ResultSet rs, String column, double defaultValue) throws SQLException {
        double fieldValue = rs.getDouble(column);
        if (rs.wasNull()) {
            fieldValue = defaultValue;
        }
        return fieldValue;
    }

    public static int getInt(ResultSet rs, String column) throws SQLException {
        return DatabaseUtils.getInt(rs, column, -1);
    }

    public static double getDouble(ResultSet rs, String column) throws SQLException {
        return DatabaseUtils.getDouble(rs, column, -1.0);
    }

    public static long getLong(ResultSet rs, String column) throws SQLException {
        return DatabaseUtils.getLong(rs, column, -1L);
    }

    public static long getLong(ResultSet rs, String column, long defaultValue) throws SQLException {
        long fieldValue = rs.getLong(column);
        if (rs.wasNull()) {
            fieldValue = defaultValue;
        }
        return fieldValue;
    }

    public static void setInt(PreparedStatement pst, int paramCount, int value) throws SQLException {
        if (value == -1) {
            pst.setNull(paramCount, 4);
        } else {
            pst.setInt(paramCount, value);
        }
    }

    public static void setDouble(PreparedStatement pst, int paramCount, double value) throws SQLException {
        if (value == -1.0) {
            pst.setNull(paramCount, 8);
        } else {
            pst.setDouble(paramCount, value);
        }
    }

    public static void setLong(PreparedStatement pst, int paramCount, long value) throws SQLException {
        if (value == -1L) {
            pst.setNull(paramCount, 4);
        } else {
            pst.setLong(paramCount, value);
        }
    }

    public static void setTimestamp(PreparedStatement pst, int paramCount, Timestamp value) throws SQLException {
        if (value == null) {
            pst.setNull(paramCount, 91);
        } else {
            pst.setTimestamp(paramCount, value);
        }
    }

    public static void setDate(PreparedStatement pst, int paramCount, Date value) throws SQLException {
        if (value == null) {
            pst.setNull(paramCount, 91);
        } else {
            pst.setDate(paramCount, value);
        }
    }

    public static void executeSQL(Connection db, String filename) throws SQLException, IOException {
        System.out.println("DatabaseUtils-> executeSQL: " + filename);
        BufferedReader in = new BufferedReader(new FileReader(filename));
        DatabaseUtils.executeSQL(db, in);
        in.close();
    }

    public static void executeSQL(Connection db, ServletContext context, String filename) throws SQLException, IOException {
        InputStream source = context.getResourceAsStream(filename);
        BufferedReader in = new BufferedReader(new InputStreamReader(source));
        DatabaseUtils.executeSQL(db, in);
        in.close();
    }

    public static void executeSQL(Connection db, BufferedReader in) throws SQLException, IOException {
        StringBuffer sql = new StringBuffer();
        String line = null;
        Statement st = db.createStatement();
        int tCount = 0;
        int lineCount = 0;
        while ((line = in.readLine()) != null) {
            ++lineCount;
            if (line.startsWith("//") || line.startsWith("--")) continue;
            sql.append(line);
            if (line.trim().endsWith(";")) {
                ++tCount;
                try {
                    st.execute(sql.substring(0, sql.lastIndexOf(";")));
                }
                catch (SQLException e) {
                    System.out.println("DatabaseUtils-> ERROR(1), line: " + lineCount + " message: " + e.getMessage());
                    throw new SQLException(e.getMessage());
                }
                sql.setLength(0);
                continue;
            }
            if (line.trim().equals("GO")) {
                ++tCount;
                try {
                    st.execute(sql.substring(0, sql.lastIndexOf("GO")));
                }
                catch (SQLException e) {
                    System.out.println("DatabaseUtils-> ERROR(2), line: " + lineCount + " message: " + e.getMessage());
                    throw new SQLException(e.getMessage());
                }
                sql.setLength(0);
                continue;
            }
            sql.append(CRLF);
        }
        if (sql.toString().trim().length() > 0 && !CRLF.equals(sql.toString().trim())) {
            ++tCount;
            try {
                st.execute(sql.toString());
            }
            catch (SQLException e) {
                System.out.println("DatabaseUtils-> ERROR(3), line: " + lineCount + " message: " + e.getMessage());
                throw new SQLException(e.getMessage());
            }
        }
        st.close();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Executed " + tCount + " total statements");
        }
    }

    public static void renewConnection(ActionContext context, Connection db) {
        ConnectionPool sqlDriver;
        if (db != null && (sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool")) != null) {
            sqlDriver.renew(db);
        }
    }

    public static String getTableName(Connection db, String tableName) {
        if (DatabaseUtils.getType(db) != 4 && DatabaseUtils.getType(db) != 3 && DatabaseUtils.getType(db) != 6 && DatabaseUtils.getType(db) != 9) {
            return tableName;
        }
        if (tableName.length() < 32) {
            return tableName;
        }
        if ("business_process_component_library".equals(tableName)) {
            return "business_process_comp_library";
        }
        if ("business_process_component_parameter".equals(tableName)) {
            return "business_pro_comp_parameter";
        }
        if ("business_process_component_result_lookup".equals(tableName)) {
            if (DatabaseUtils.getType(db) == 4 || DatabaseUtils.getType(db) == 9) {
                return "business_pro_comp_result_lookup";
            }
            return "business_pro_com_result_lookup";
        }
        if ("business_process_parameter_library".equals(tableName)) {
            return "business_process_param_library";
        }
        if ("document_store_department_member".equals(tableName)) {
            return "doc_store_depart_member";
        }
        if ("lookup_document_store_permission".equals(tableName)) {
            return "lookup_doc_store_perm";
        }
        if ("lookup_document_store_permission_category".equals(tableName)) {
            return "lookup_doc_store_perm_cat";
        }
        if ("lookup_project_permission_category".equals(tableName)) {
            return "lookup_project_perm_category";
        }
        if ("lookup_opportunity_event_compelling".equals(tableName)) {
            return "lookup_opt_event_compelling";
        }
        if ("ticket_category_draft_assignment".equals(tableName)) {
            if (DatabaseUtils.getType(db) == 4 || DatabaseUtils.getType(db) == 9) {
                return "ticket_category_draf_assignment";
            }
            return "ticket_category_dra_assignment";
        }
        System.out.println("DatabaseUtils-> Invalid table name: " + tableName);
        return tableName;
    }

    public static String parseReservedWord(Connection db, String reservedWord) {
        if (DatabaseUtils.getType(db) == 4 || DatabaseUtils.getType(db) == 9 || DatabaseUtils.getType(db) == 3 || DatabaseUtils.getType(db) == 6 || DatabaseUtils.getType(db) == 7 || DatabaseUtils.getType(db) == 8) {
            if (reservedWord.indexOf(".") > -1) {
                String part1 = reservedWord.substring(0, reservedWord.indexOf("."));
                String part2 = reservedWord.substring(reservedWord.indexOf(".") + 1);
                return part1 + "." + DatabaseUtils.parseReservedWord(db, part2);
            }
            if (sqlReservedWords.indexOf("," + reservedWord + ",") != -1) {
                return DatabaseUtils.getQuote(db) + reservedWord + DatabaseUtils.getQuote(db);
            }
        }
        return reservedWord;
    }

    private static String getQuote(Connection db) {
        String quoteSymbol = "";
        switch (DatabaseUtils.getType(db)) {
            case 7: {
                quoteSymbol = qsMySQL;
                break;
            }
            default: {
                quoteSymbol = qsDefault;
            }
        }
        return quoteSymbol;
    }

    public static String addQuotes(Connection db, String stringToQuote) {
        String quoteSymbol = DatabaseUtils.getQuote(db);
        return quoteSymbol + stringToQuote + quoteSymbol;
    }

    public static Connection getConnection(String dbUrl, String dbUser, String dbPwd) throws SQLException {
        Connection connection = DriverManager.getConnection(dbUrl, dbUser, dbPwd);
        if (DatabaseUtils.getType(connection) == 7) {
            PreparedStatement pst = connection.prepareStatement("SELECT @@session.sql_mode;");
            String currentMode = "";
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                currentMode = rs.getString(1);
            }
            rs.close();
            pst.close();
            pst = connection.prepareStatement("SET sql_mode = '" + currentMode + (currentMode.length() > 0 ? "," : "") + "ANSI_QUOTES,NO_AUTO_VALUE_ON_ZERO';");
            pst.execute();
            pst.close();
        } else if (DatabaseUtils.getType(connection) == 6) {
            // empty if block
        }
        return connection;
    }

    public static void skipRowsManual(Connection db, ResultSet rs, int skipRowsCount) throws SQLException {
        if (DatabaseUtils.getType(db) == 2 || DatabaseUtils.getType(db) == 5 || DatabaseUtils.getType(db) == 8 || DatabaseUtils.getType(db) == 3) {
            for (int skipCount = 0; skipCount < skipRowsCount; ++skipCount) {
                rs.next();
            }
        }
    }

    public static void doManualLimit(Connection db, PreparedStatement pst, int maxRowsCount) throws SQLException {
        if (DatabaseUtils.getType(db) == 8) {
            pst.setMaxRows(maxRowsCount);
        }
    }

    public static String getTruncDateDialect(String dateColumn, int truncTo, int dbType) {
        String truncSQL = "";
        String dateFormat = "";
        block0 : switch (dbType) {
            case 1: {
                switch (truncTo) {
                    case 1: {
                        dateFormat = "day";
                        break;
                    }
                    case 3: {
                        dateFormat = "month";
                        break;
                    }
                    case 6: {
                        dateFormat = "minute";
                        break;
                    }
                    case 5: {
                        dateFormat = "hour";
                        break;
                    }
                    case 4: {
                        dateFormat = "year";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                truncSQL = "date_trunc('" + dateFormat + "'," + dateColumn + ")";
                break;
            }
            case 2: {
                switch (truncTo) {
                    case 1: {
                        truncSQL = "CAST(CONVERT(varchar, " + dateColumn + ",101) AS DATETIME) ";
                        break block0;
                    }
                    case 3: {
                        truncSQL = "CAST(CONVERT(varchar, " + dateColumn + ",101) AS DATETIME) ";
                        break block0;
                    }
                    case 6: {
                        truncSQL = "CAST(CONVERT(varchar, " + dateColumn + ",100) AS DATETIME) ";
                        break block0;
                    }
                    case 5: {
                        truncSQL = "CAST(CONVERT(varchar, " + dateColumn + ",101) AS DATETIME) ";
                        break block0;
                    }
                    case 4: {
                        truncSQL = "CAST(CONVERT(varchar, " + dateColumn + ",101) AS DATETIME) ";
                        break block0;
                    }
                }
                return null;
            }
            case 5: {
                switch (truncTo) {
                    case 1: {
                        dateFormat = "DD";
                        break;
                    }
                    case 3: {
                        dateFormat = "MM";
                        break;
                    }
                    case 6: {
                        dateFormat = "MI";
                        break;
                    }
                    case 5: {
                        dateFormat = "HH";
                        break;
                    }
                    case 4: {
                        dateFormat = "YYYY";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                truncSQL = "trunc(" + dateColumn + ",'" + dateFormat + "')";
                break;
            }
            case 3: {
                switch (truncTo) {
                    case 1: {
                        dateFormat = "DD";
                        break;
                    }
                    case 3: {
                        dateFormat = "MM";
                        break;
                    }
                    case 6: {
                        dateFormat = "MI";
                        break;
                    }
                    case 5: {
                        dateFormat = "HH";
                        break;
                    }
                    case 4: {
                        dateFormat = "YYYY";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                truncSQL = "trunc(" + dateColumn + ",'" + dateFormat + "')";
                break;
            }
            case 6: {
                switch (truncTo) {
                    case 1: {
                        truncSQL = "DATE(" + dateColumn + ") ";
                        break block0;
                    }
                }
                return null;
            }
            case 4: 
            case 9: {
                switch (truncTo) {
                    case 1: {
                        truncSQL = "CAST(" + dateColumn + " AS date) ";
                        break block0;
                    }
                }
                return null;
            }
            case 7: {
                switch (truncTo) {
                    case 1: {
                        truncSQL = "CAST(" + dateColumn + " AS date) ";
                        break block0;
                    }
                }
                return null;
            }
            case 8: {
                switch (truncTo) {
                    case 1: {
                        truncSQL = "CAST(" + dateColumn + " AS date) ";
                        break block0;
                    }
                }
                return null;
            }
        }
        return truncSQL;
    }

    public static ResultSet executeQuery(Connection db, PreparedStatement pst, Logger log) throws SQLException {
        return DatabaseUtils.executeQuery(db, pst, log, null);
    }

    public static ResultSet executeQuery(Connection db, PreparedStatement pst, Logger log, PagedListInfo pagedListInfo) throws SQLException {
        ResultSet rs = null;
        long milies = System.currentTimeMillis();
        if (pagedListInfo != null) {
            pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        milies = System.currentTimeMillis() - milies;
        log.debug((Object)pst);
        log.debug((Object)(milies + " ms."));
        if (milies > 3000L) {
            log.warn((Object)"To improve the speed of your application please send the following query to Centric CRM support:");
            log.warn((Object)"------------------------");
            log.warn((Object)pst);
            log.warn((Object)("[QUERY TIME: " + milies + " ms.]"));
            log.warn((Object)"------------------------");
        }
        if (pagedListInfo != null) {
            pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }
}

