/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.utils.StringUtils;

public class DateUtils {
    public static java.sql.Date parseDateString(String tmp) {
        java.sql.Date dateValue = null;
        try {
            Date tmpDate = DateFormat.getDateInstance(3).parse(tmp);
            dateValue = new java.sql.Date(new Date().getTime());
            dateValue.setTime(tmpDate.getTime());
            return dateValue;
        }
        catch (Exception e) {
            try {
                return java.sql.Date.valueOf(tmp);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static Timestamp parseTimestampString(String tmp) {
        Timestamp timestampValue = null;
        try {
            Date tmpDate = DateFormat.getDateTimeInstance(3, 1).parse(tmp);
            timestampValue = new Timestamp(new Date().getTime());
            timestampValue.setTime(tmpDate.getTime());
            return timestampValue;
        }
        catch (Exception e) {
            try {
                return Timestamp.valueOf(tmp);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static Timestamp parseTimestampString(String tmp, String format) {
        Timestamp timestampValue = null;
        SimpleDateFormat df = null;
        df = new SimpleDateFormat(format);
        try {
            Date tmpDate = df.parse(tmp, new ParsePosition(0));
            timestampValue = new Timestamp(new Date().getTime());
            timestampValue.setTime(tmpDate.getTime());
            return timestampValue;
        }
        catch (Exception e) {
            try {
                return Timestamp.valueOf(tmp);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static java.sql.Date parseDateString(String tmp, String format) {
        java.sql.Date dateValue = null;
        SimpleDateFormat df = null;
        df = new SimpleDateFormat(format);
        try {
            Date tmpDate = df.parse(tmp, new ParsePosition(0));
            dateValue = new java.sql.Date(new Date().getTime());
            dateValue.setTime(tmpDate.getTime());
            return dateValue;
        }
        catch (Exception e) {
            try {
                return java.sql.Date.valueOf(tmp);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static String getUserToServerDateTimeString(TimeZone timeZone, int dateFormat, int timeFormat, String date) {
        return DateUtils.getUserToServerDateTimeString(timeZone, dateFormat, timeFormat, date, Locale.getDefault());
    }

    public static String getUserToServerDateTimeString(TimeZone timeZone, int dateFormat, int timeFormat, String date, Locale locale) {
        String convertedDate;
        block3: {
            convertedDate = null;
            try {
                DateFormat localeFormatter = DateFormat.getDateInstance(dateFormat, locale);
                if (timeZone != null) {
                    localeFormatter.setTimeZone(timeZone);
                }
                DateFormat serverFormatter = DateFormat.getDateTimeInstance(dateFormat, timeFormat);
                convertedDate = serverFormatter.format(new Date(localeFormatter.parse(date).getTime()));
            }
            catch (Exception e) {
                if (date == null || "".equals(date)) break block3;
                System.err.println("EXCEPTION: DateUtils-> Timestamp " + e);
            }
        }
        return convertedDate;
    }

    public static Timestamp getUserToServerDateTime(TimeZone timeZone, int dateFormat, int timeFormat, String date, Locale locale) {
        try {
            DateFormat localeFormatter = DateFormat.getDateInstance(dateFormat, locale);
            if (timeZone != null) {
                localeFormatter.setTimeZone(timeZone);
            }
            localeFormatter.setLenient(false);
            return new Timestamp(localeFormatter.parse(date).getTime());
        }
        catch (Exception e) {
            if (date != null && !"".equals(date)) {
                System.err.println("EXCEPTION: DateUtils-> Timestamp " + e);
            }
            return null;
        }
    }

    public static Timestamp getUserToServerDateTime(Calendar cal, TimeZone timeZone) {
        Timestamp timestampValue = null;
        try {
            String date = DateUtils.getDateString(cal);
            DateFormat localFormatter = DateFormat.getDateInstance(3);
            if (timeZone != null) {
                localFormatter.setTimeZone(timeZone);
            }
            timestampValue = new Timestamp(localFormatter.parse(date).getTime());
        }
        catch (Exception e) {
            System.out.println("DateUtils-> getUserToServerDateTime Exception" + e.toString());
        }
        return timestampValue;
    }

    public static String getServerToUserDateString(TimeZone timeZone, int dateFormat, Timestamp date) {
        SimpleDateFormat formatter = null;
        try {
            formatter = (SimpleDateFormat)SimpleDateFormat.getDateInstance(dateFormat);
            formatter.applyPattern("M/d/yyyy");
            formatter.setTimeZone(timeZone);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION: DateUtils -> Timestamp " + date);
        }
        return formatter.format(date);
    }

    public static String getServerToUserDateTimeString(TimeZone timeZone, int dateFormat, int timeFormat, Timestamp date) {
        SimpleDateFormat formatter = null;
        try {
            formatter = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(dateFormat, timeFormat);
            if (timeZone != null) {
                formatter.setTimeZone(timeZone);
            }
        }
        catch (Exception e) {
            System.err.println("EXCEPTION: DateUtils -> Timestamp " + date);
        }
        return formatter.format(date);
    }

    public static Date getDate(Calendar cal) {
        Date convertedDate = null;
        try {
            SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3);
            formatter.applyPattern("M/d/yyyy");
            String tmpDate = cal.get(2) + 1 + "/" + cal.get(5) + "/" + cal.get(1);
            convertedDate = formatter.parse(tmpDate);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION: DateUtils -> Timestamp ");
        }
        return convertedDate;
    }

    public static String getDateString(Calendar cal) {
        return cal.get(2) + 1 + "/" + cal.get(5) + "/" + cal.get(1);
    }

    public static String getDatePath(Date fileDate) {
        return DateUtils.getDatePath(new Timestamp(fileDate.getTime()));
    }

    public static String getDatePath(Timestamp fileDate) {
        if (fileDate == null) {
            return "0000" + System.getProperty("file.separator") + "0000" + System.getProperty("file.separator");
        }
        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy");
        String datePathToUse1 = formatter1.format(fileDate);
        SimpleDateFormat formatter2 = new SimpleDateFormat("MMdd");
        String datePathToUse2 = formatter2.format(fileDate);
        return datePathToUse1 + System.getProperty("file.separator") + datePathToUse2 + System.getProperty("file.separator");
    }

    public static String getFilename() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return formatter.format(new Date());
    }

    public static Timestamp roundUpToNextFive(long millis) {
        Calendar cal = Calendar.getInstance();
        while (cal.get(12) % 5 != 0) {
            cal.set(12, cal.get(12) + 1);
        }
        return new Timestamp(cal.getTimeInMillis());
    }

    static int getDaysBetween(Calendar d1, Calendar d2) {
        if (d1.after(d2)) {
            Calendar swap = d1;
            d1 = d2;
            d2 = swap;
        }
        int days = d2.get(6) - d1.get(6);
        int y2 = d2.get(1);
        if (d1.get(1) != y2) {
            d1 = (Calendar)d1.clone();
            do {
                days += d1.getActualMaximum(6);
                d1.add(1, 1);
            } while (d1.get(1) != y2);
        }
        return days;
    }

    public static String getDateAsString(Timestamp date, ActionContext context) {
        Locale locale = null;
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        if (thisUser != null) {
            locale = thisUser.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return DateUtils.getDateAsString(date, locale);
    }

    public static String getDateAsString(Timestamp tmpTimestamp, Locale locale) {
        String dateAsString = "";
        try {
            SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale);
            formatter.applyPattern(DateUtils.get4DigitYearDateFormat(formatter.toPattern()));
            dateAsString = formatter.format(tmpTimestamp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateAsString;
    }

    public static String get4DigitYearDateFormat(String tmpDateFormat) {
        if (tmpDateFormat.indexOf("yy") > -1 && tmpDateFormat.indexOf("yyyy") == -1) {
            return StringUtils.replace(tmpDateFormat, "yy", "yyyy");
        }
        return tmpDateFormat;
    }

    public static boolean isWeekend(Calendar cal) {
        return cal.get(7) == 7 || cal.get(7) == 1;
    }
}

