/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Dictionary {
    private String language = null;
    private String defaultLanguage = "en_US";
    private String languageFilePath = null;
    private Map localizationPrefs = new LinkedHashMap();

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String tmp) {
        this.defaultLanguage = tmp;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String tmp) {
        this.language = tmp;
    }

    public String getLanguageFilePath() {
        return this.languageFilePath;
    }

    public void setLanguageFilePath(String tmp) {
        this.languageFilePath = tmp;
    }

    public Map getLocalizationPrefs() {
        return this.localizationPrefs;
    }

    public void setLocalizationPrefs(Map tmp) {
        this.localizationPrefs = tmp;
    }

    public String getTerm(String section, String parameter, String tagName) {
        Node param;
        Map prefGroup = (Map)this.localizationPrefs.get(section);
        if (prefGroup != null && (param = (Node)prefGroup.get(parameter)) != null) {
            return XMLUtils.getNodeText(XMLUtils.getFirstChild((Element)param, tagName));
        }
        return null;
    }

    public Dictionary() {
    }

    public Dictionary(String languageFilePath, String defaultLanguage) throws Exception {
        this.languageFilePath = languageFilePath;
        this.defaultLanguage = defaultLanguage;
        this.load(languageFilePath, defaultLanguage);
    }

    public void load(String languageFilePath, String language) throws Exception {
        File prefsFile;
        if (languageFilePath == null) {
            throw new Exception("Dictionary file path not provided");
        }
        if (!languageFilePath.endsWith(System.getProperty("file.separator"))) {
            languageFilePath = languageFilePath + System.getProperty("file.separator");
        }
        String languageFilename = "dictionary_" + language + ".xml";
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Dictionary-> Loading dictionary preferences: " + languageFilePath + languageFilename);
        }
        if ((prefsFile = new File(languageFilePath + languageFilename)).exists()) {
            XMLUtils xml = new XMLUtils(prefsFile);
            NodeList configNodes = xml.getDocumentElement().getElementsByTagName("config");
            for (int i = 0; i < configNodes.getLength(); ++i) {
                Node configNode = configNodes.item(i);
                if (configNode == null || configNode.getNodeType() != 1 || !"config".equals(((Element)configNode).getTagName()) || ((Element)configNode).getAttribute("enabled") != null && !"".equals(((Element)configNode).getAttribute("enabled")) && !"true".equals(((Element)configNode).getAttribute("enabled"))) continue;
                String configName = ((Element)configNode).getAttribute("name");
                LinkedHashMap preferenceGroup = null;
                if (configName == null) continue;
                if (this.localizationPrefs.containsKey(configName)) {
                    preferenceGroup = (LinkedHashMap)this.localizationPrefs.get(configName);
                } else {
                    preferenceGroup = new LinkedHashMap();
                    this.localizationPrefs.put(configName, preferenceGroup);
                }
                NodeList paramNodes = ((Element)configNode).getElementsByTagName("param");
                for (int j = 0; j < paramNodes.getLength(); ++j) {
                    String paramName;
                    Node paramNode = paramNodes.item(j);
                    if (paramNode == null || paramNode.getNodeType() != 1 || !"param".equals(((Element)paramNode).getTagName()) || (paramName = ((Element)paramNode).getAttribute("name")) == null) continue;
                    preferenceGroup.put(paramName, paramNode);
                }
            }
        }
    }
}

