/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class ExternalHttpRequest {
    StringBuffer htmlOutput = new StringBuffer();
    int errorCode = 0;
    String errorMessage = "";

    public ExternalHttpRequest() {
    }

    public ExternalHttpRequest(String link) {
        try {
            URL url = new URL(link);
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            this.retrieveHtml(http);
        }
        catch (MalformedURLException e) {
            this.errorCode = 1;
            this.errorMessage = e.toString();
        }
        catch (IOException e) {
            this.errorCode = 2;
            this.errorMessage = e.toString();
        }
    }

    public ExternalHttpRequest(HttpServletRequest request, String link, String username) {
        Enumeration parameters = request.getParameterNames();
        StringBuffer parameterList = new StringBuffer();
        if (username != null) {
            parameterList.append("ckname=" + username);
        }
        while (parameters.hasMoreElements()) {
            String param = (String)parameters.nextElement();
            if (param.equals("command")) continue;
            parameterList.append((parameterList.length() == 0 ? "" : "&") + param + "=" + request.getParameter(param));
        }
        try {
            HttpURLConnection http;
            URL url;
            if (request.getMethod().equals("POST")) {
                url = new URL(link);
                http = (HttpURLConnection)url.openConnection();
                http.setRequestMethod("POST");
                http.setDoOutput(true);
                PrintWriter outStream = new PrintWriter(http.getOutputStream());
                outStream.println(parameterList.toString());
                outStream.close();
            } else {
                url = parameterList.length() > 0 ? new URL(link + "?" + parameterList.toString()) : new URL(link);
                http = (HttpURLConnection)url.openConnection();
            }
            this.retrieveHtml(http);
        }
        catch (MalformedURLException e) {
            this.errorCode = 1;
            this.errorMessage = e.toString();
        }
        catch (IOException e) {
            this.errorCode = 2;
            this.errorMessage = e.toString();
        }
    }

    public String getHtmlOutput() {
        return this.htmlOutput.toString();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void retrieveHtml(HttpURLConnection http) throws IOException {
        String inputLine;
        InputStreamReader input = new InputStreamReader(http.getInputStream());
        BufferedReader inStream = new BufferedReader(input);
        while ((inputLine = inStream.readLine()) != null) {
            this.htmlOutput.append(inputLine + System.getProperty("line.separator"));
        }
        inStream.close();
    }
}

