/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.aspcfs.utils.StringUtils;

public class FileUtils {
    public static boolean copyFile(File sourceFile, File destinationFile) {
        return FileUtils.copyFile(sourceFile, destinationFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File sourceFile, File destinationFile, boolean overwrite) {
        String fs = System.getProperty("file.separator");
        int wildcardPos = sourceFile.getName().indexOf("*");
        if (wildcardPos > 0) {
            if (!sourceFile.getParentFile().exists()) {
                System.out.println("FileUtils-> Source directory does not exist: " + sourceFile.getParentFile());
                return false;
            }
            File[] fileNames = sourceFile.getParentFile().listFiles();
            int count = fileNames.length;
            if (count > 0) {
                String part1 = sourceFile.getName().substring(0, wildcardPos);
                String part2 = null;
                if (wildcardPos < sourceFile.getName().length()) {
                    part2 = sourceFile.getName().substring(wildcardPos + 1);
                }
                for (int i = 0; i < count; ++i) {
                    File thisFile = fileNames[i];
                    if (!thisFile.getName().startsWith(part1) || part2 != null && (part2 == null || !thisFile.getName().endsWith(part2))) continue;
                    FileUtils.copyFile(fileNames[i], destinationFile, overwrite);
                }
            } else {
                System.out.println("FileUtils-> No parent files found in: " + sourceFile.getParentFile());
            }
            return true;
        }
        if (!sourceFile.exists()) {
            System.out.println("FileUtils-> Source file not found: " + sourceFile);
            return false;
        }
        if (destinationFile.isDirectory()) {
            destinationFile = new File(destinationFile.getPath() + fs + sourceFile.getName());
        }
        if (sourceFile.equals(destinationFile)) {
            System.out.println("FileUtils-> Source and destination are the same");
            return false;
        }
        if (!overwrite && destinationFile.exists()) {
            System.out.println("FileUtils-> Destination already exists");
            return true;
        }
        FileInputStream source = null;
        FileOutputStream destination = null;
        try {
            source = new FileInputStream(sourceFile);
            destination = new FileOutputStream(destinationFile);
            byte[] buffer = new byte[4096];
            int read = -1;
            while ((read = source.read(buffer)) != -1) {
                destination.write(buffer, 0, read);
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("FileUtils-> Copied: " + sourceFile + " to " + destinationFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException io) {}
            }
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException io) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyBytesToFile(byte[] bytes, File destinationFile, boolean overwrite) throws IOException {
        if (destinationFile.isDirectory()) {
            destinationFile = new File(destinationFile.getPath());
        }
        if (!overwrite && destinationFile.exists()) {
            System.out.println("FileUtils-> Destination already exists");
            return true;
        }
        FileOutputStream destination = null;
        try {
            destination = new FileOutputStream(destinationFile);
            destination.write(bytes);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("FileUtils-> Copied bytes to " + destinationFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException io) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(ServletContext context, String filename, File destinationFile, boolean overwrite) throws IOException {
        String fs = System.getProperty("file.separator");
        if (destinationFile.isDirectory()) {
            File sourceFile = new File(filename);
            destinationFile = new File(destinationFile.getPath() + fs + sourceFile.getName());
        }
        if (!overwrite && destinationFile.exists()) {
            return true;
        }
        InputStream source = context.getResourceAsStream(filename);
        FileOutputStream destination = null;
        try {
            destination = new FileOutputStream(destinationFile);
            byte[] buffer = new byte[4096];
            int read = -1;
            while ((read = source.read(buffer)) != -1) {
                destination.write(buffer, 0, read);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException io) {}
            }
        }
        return true;
    }

    public static long getFreeBytes(String dir) {
        long free = -1L;
        String[] command = null;
        File osCheckFile = new File("/bin/sh");
        if (osCheckFile.exists()) {
            dir = StringUtils.replace(dir, " ", "\\ ");
            command = new String[]{"/bin/sh", "-c", "df " + dir};
        } else {
            command = new String[]{"cmd", "/C", "dir", dir};
        }
        String line = null;
        String thisLine = null;
        try {
            int blockSize = 1024;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((thisLine = in.readLine()) != null) {
                line = thisLine;
                if (line.indexOf("512-blocks") > -1) {
                    blockSize = 512;
                }
                if (!line.endsWith("bytes free")) continue;
                if (line.indexOf("Dir(s)") > -1) {
                    line = line.substring(line.indexOf("Dir(s)"));
                }
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < line.length(); ++i) {
                    char ch = line.charAt(i);
                    if (!Character.isDigit(ch)) continue;
                    sb.append(ch);
                }
                free = Long.parseLong(sb.toString());
                line = null;
                break;
            }
            in.close();
            if (line != null) {
                StringTokenizer st = new StringTokenizer(line, " ");
                int items = st.countTokens();
                for (int i = 0; i < items - 3; ++i) {
                    st.nextToken();
                }
                free = Long.parseLong(st.nextToken()) * (long)blockSize;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return free;
    }

    public static boolean deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDirectory(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean fileExists(String fullPath) {
        File thisFile = new File(fullPath);
        return thisFile.exists();
    }

    public static String getRelativeSize(float size, Locale locale) {
        if (size == -1.0f) {
            return "Could not be determined";
        }
        NumberFormat formatter = null;
        formatter = locale == null ? NumberFormat.getInstance() : NumberFormat.getInstance(locale);
        if (size > 1.0E9f) {
            formatter.setMaximumFractionDigits(2);
            return formatter.format(size / 1000.0f / 1000.0f / 1000.0f) + " GB";
        }
        if (size > 1000000.0f) {
            formatter.setMaximumFractionDigits(1);
            return formatter.format(size / 1000.0f / 1000.0f) + " MB";
        }
        if (size > 1000.0f) {
            formatter.setMaximumFractionDigits(0);
            return formatter.format(size / 1000.0f) + " KB";
        }
        return formatter.format(size) + " bytes";
    }

    public static String getFileName(String dir, String fileName) throws IllegalArgumentException {
        String path = null;
        if (dir == null || fileName == null) {
            throw new IllegalArgumentException("dir or fileName is null");
        }
        int index = fileName.lastIndexOf(47);
        String name = null;
        name = index >= 0 ? fileName.substring(index + 1) : fileName;
        if ((index = name.lastIndexOf(92)) >= 0) {
            fileName = name.substring(index + 1);
        }
        path = dir + File.separator + fileName;
        if (File.separatorChar == '/') {
            return path.replace('\\', File.separatorChar);
        }
        return path.replace('/', File.separatorChar);
    }

    public static String getFileName(String fileName) throws IllegalArgumentException {
        if (fileName == null) {
            throw new IllegalArgumentException("dir or fileName is null");
        }
        int index = fileName.lastIndexOf(47);
        String name = null;
        name = index >= 0 ? fileName.substring(index + 1) : fileName;
        if ((index = name.lastIndexOf(92)) >= 0) {
            fileName = name.substring(index + 1);
        }
        return fileName;
    }
}

