/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.aspcfs.utils.HttpsHostnameVerifier;
import org.aspcfs.utils.HttpsTrustManager;
import org.aspcfs.utils.StringUtils;

public class HTTPUtils {
    public static String toHtml(String s) {
        if (s != null) {
            if (s.trim().equals("")) {
                return "&nbsp;";
            }
            return HTTPUtils.toHtmlValue(s);
        }
        return "&nbsp;";
    }

    public static String toHtmlValue(String s) {
        if (s != null) {
            String htmlReady = s.trim();
            htmlReady = StringUtils.replace(htmlReady, "\"", "&quot;");
            htmlReady = StringUtils.replace(htmlReady, "<", "&lt;");
            htmlReady = StringUtils.replace(htmlReady, ">", "&gt;");
            htmlReady = StringUtils.replace(htmlReady, "\r\n", "<br>");
            htmlReady = StringUtils.replace(htmlReady, "\n\r", "<br>");
            htmlReady = StringUtils.replace(htmlReady, "\n", "<br>");
            htmlReady = StringUtils.replace(htmlReady, "\r", "<br>");
            return htmlReady;
        }
        return "";
    }

    public static String sendPacket(String address, String xmlPacket) throws IOException {
        return HTTPUtils.sendPacket(address, xmlPacket, null);
    }

    public static String sendPacket(String address, String xmlPacket, HashMap headers) throws IOException {
        Exception errorMessage = null;
        try {
            HttpsTrustManager xtm = new HttpsTrustManager();
            TrustManager[] mytm = new TrustManager[]{xtm};
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, mytm, null);
            SSLSocketFactory factory = ctx.getSocketFactory();
            URL url = new URL(address);
            URLConnection conn = url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(factory);
                ((HttpsURLConnection)conn).setHostnameVerifier(new HttpsHostnameVerifier());
            }
            ((HttpURLConnection)conn).setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
            if (headers != null && headers.size() > 0) {
                for (String header : headers.keySet()) {
                    String value = (String)headers.get(header);
                    conn.setRequestProperty(header, value);
                }
            }
            conn.setDoInput(true);
            conn.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), "UTF8");
            out.write(xmlPacket);
            out.close();
            return HTTPUtils.retrieveHtml(conn);
        }
        catch (MalformedURLException e) {
            errorMessage = e;
        }
        catch (IOException e) {
            errorMessage = e;
        }
        catch (KeyManagementException e) {
            errorMessage = e;
        }
        catch (NoSuchAlgorithmException e) {
            errorMessage = e;
        }
        catch (NullPointerException e) {
            e.printStackTrace(System.out);
            errorMessage = e;
        }
        if (errorMessage != null) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("HTTPUtils-> sendPacket error: " + errorMessage.getMessage());
            }
            throw new IOException(errorMessage.toString());
        }
        return null;
    }

    public static String retrieveHtml(URLConnection http) throws IOException {
        String inputLine;
        StringBuffer htmlOutput = new StringBuffer();
        InputStreamReader input = new InputStreamReader(http.getInputStream());
        BufferedReader inStream = new BufferedReader(input);
        while ((inputLine = inStream.readLine()) != null) {
            htmlOutput.append(inputLine + System.getProperty("line.separator"));
        }
        inStream.close();
        return htmlOutput.toString();
    }

    public static int convertUrlToPostscriptFile(String url, String baseFilename) {
        String[] command = null;
        File osCheckFile = new File("/bin/sh");
        command = osCheckFile.exists() ? new String[]{"/bin/sh", "-c", "/usr/bin/htmldoc --quiet -f " + baseFilename + ".ps " + "--webpage " + "-t ps " + "--header ... " + "--footer ... " + url} : new String[]{"htmldoc", "--quiet -f " + baseFilename + ".ps " + "--webpage " + "-t ps3 " + "--header ... " + "--footer ... " + url};
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(command);
            return process.waitFor();
        }
        catch (Exception e) {
            System.err.println("HTTPUtils-> urlToPostscriptFile error: " + e.toString());
            return 1;
        }
    }

    public static String getServerName(String address) {
        block4: {
            System.out.println("HTTPUtils-> Checking: " + address);
            try {
                HttpsTrustManager xtm = new HttpsTrustManager();
                TrustManager[] mytm = new TrustManager[]{xtm};
                SSLContext ctx = SSLContext.getInstance("SSL");
                ctx.init(null, mytm, null);
                SSLSocketFactory factory = ctx.getSocketFactory();
                URL url = new URL(address);
                URLConnection conn = url.openConnection();
                if (conn instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(factory);
                    ((HttpsURLConnection)conn).setHostnameVerifier(new HttpsHostnameVerifier());
                }
                if (conn instanceof HttpURLConnection) {
                    HttpURLConnection httpConnection = (HttpURLConnection)conn;
                    httpConnection.setRequestMethod("HEAD");
                    httpConnection.connect();
                    return httpConnection.getHeaderField("Server");
                }
            }
            catch (Exception e) {
                System.out.println("HTTPUtils-> getServerName error: " + e.getMessage());
                if (System.getProperty("DEBUG") == null) break block4;
                e.printStackTrace(System.out);
            }
        }
        return null;
    }
}

