/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.aspcfs.utils.FileUtils;

public class ImageUtils {
    public static void saveThumbnail(File originalFile, File thumbnailFile, double maxWidth, double maxHeight) throws IOException {
        BufferedImage thumbnailImage = ImageIO.read(originalFile);
        double ratioWidth = maxWidth / (double)thumbnailImage.getWidth();
        double ratioHeight = maxHeight / (double)thumbnailImage.getHeight();
        double ratio = 1.0;
        if ((double)thumbnailImage.getWidth() <= maxWidth && (double)thumbnailImage.getHeight() <= maxHeight) {
            ratio = 1.0;
        } else {
            if (maxWidth > 0.0 && maxHeight <= 0.0) {
                ratio = ratioWidth;
            }
            if (maxWidth <= 0.0 && maxHeight > 0.0) {
                ratio = ratioHeight;
            }
            if (maxWidth > 0.0 && maxHeight > 0.0) {
                ratio = ratioWidth < ratioHeight ? ratioWidth : ratioHeight;
            }
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ImageUtils-> Ratio: " + ratio);
        }
        if (ratio == 1.0) {
            FileUtils.copyFile(originalFile, thumbnailFile);
        } else {
            try {
                float softenFactor = 0.05f;
                float[] softenArray = new float[]{0.0f, softenFactor, 0.0f, softenFactor, 1.0f - softenFactor * 4.0f, softenFactor, 0.0f, softenFactor, 0.0f};
                Kernel kernel = new Kernel(3, 3, softenArray);
                ConvolveOp cOp = new ConvolveOp(kernel, 1, null);
                thumbnailImage = cOp.filter(thumbnailImage, null);
            }
            catch (Exception e) {
                System.out.println("ImageUtils-> Soften: " + e.getMessage());
            }
            AffineTransform at = AffineTransform.getScaleInstance(ratio, ratio);
            AffineTransformOp op = new AffineTransformOp(at, 1);
            thumbnailImage = op.filter(thumbnailImage, null);
            ImageIO.write((RenderedImage)thumbnailImage, "jpg", thumbnailFile);
        }
    }

    public static int convertPostscriptToTiffG3File(String baseFilename) {
        String[] command = null;
        File osCheckFile = new File("/bin/sh");
        command = osCheckFile.exists() ? new String[]{"/bin/sh", "-c", "gs -q -sDEVICE=tiffg3 -dNOPAUSE -dBATCH -sOutputFile=" + baseFilename + ".tiff " + baseFilename + ".ps"} : new String[]{"gs", "-q -sDEVICE=tiffg4 -dNOPAUSE -dBATCH -sOutputFile=" + baseFilename + ".tiff " + baseFilename + ".ps"};
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(command);
            return process.waitFor();
        }
        catch (Exception e) {
            System.err.println("ImageUtils-> convertPostscriptToTiff error: " + e.toString());
            return 1;
        }
    }

    public static int urlToJpegThumbnail(String url, String filename, double maxWidth, double maxHeight) {
        File gsPath = new File("/usr/bin/gs");
        if (!gsPath.exists()) {
            gsPath = new File("/sw/bin/gs");
        }
        String[] command = new String[]{"/bin/sh", "-c", "/usr/bin/htmldoc --quiet --jpeg --webpage -t ps --left 0 --top 0 --header ... --footer ... --landscape " + url + " " + "| " + gsPath.getAbsoluteFile() + " -q -sDEVICE=jpeg -dNOPAUSE -dBATCH -sOutputFile=- -"};
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(command);
            InputStream input = process.getInputStream();
            BufferedImage originalImage = ImageIO.read(input);
            double ratioWidth = maxWidth / (double)originalImage.getWidth();
            double ratioHeight = maxHeight / (double)originalImage.getHeight();
            double ratio = 1.0;
            ratio = maxWidth > 0.0 && maxHeight < 0.0 ? ratioWidth : (maxHeight > 0.0 && maxWidth < 0.0 ? ratioHeight : (ratioWidth < ratioHeight ? ratioWidth : ratioHeight));
            AffineTransform at = new AffineTransform();
            at.scale(ratio, ratio);
            AffineTransformOp op = new AffineTransformOp(at, 1);
            BufferedImage scaledImage = op.filter(originalImage, null);
            at = new AffineTransform();
            at.setToTranslation(scaledImage.getHeight() / 2, scaledImage.getWidth() / 2);
            at.rotate(Math.toRadians(90.0));
            at.translate(-(scaledImage.getWidth() / 2), -(scaledImage.getHeight() / 2));
            op = new AffineTransformOp(at, 1);
            BufferedImage thumbnailImage = op.filter(scaledImage, null);
            File thumbnailFile = new File(filename);
            ImageIO.write((RenderedImage)thumbnailImage, "jpg", thumbnailFile);
            return process.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.err.println("GraphicUtils-> urlToJpeg error: " + e.toString());
            return 1;
        }
    }

    public static int urlToJpegThumbnail(String url, String filename) {
        String[] command = new String[]{"/bin/sh", "-c", "/usr/bin/htmldoc --quiet --jpeg --webpage -t ps --left 0 --top 0 --header ... --footer ... " + url + " " + "| /usr/bin/gs -q -sDEVICE=jpeg -dNOPAUSE -dBATCH -sOutputFile=- -"};
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(command);
            InputStream input = process.getInputStream();
            BufferedImage originalImage = ImageIO.read(input);
            File thumbnailFile = new File(filename);
            ImageIO.write((RenderedImage)originalImage, "jpg", thumbnailFile);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.err.println("GraphicUtils-> urlToJpeg error: " + e.toString());
            return 1;
        }
    }
}

