/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperRunManager;
import net.sf.jasperreports.engine.util.JRLoader;
import org.aspcfs.utils.StringUtils;

public class JasperReportUtils {
    private static final int en_US = 1;
    private static final int de_DE = 2;
    private static final int el_GR = 3;
    private static final int es_VE = 4;
    private static final int hu_HU = 5;
    private static final int it_IT = 6;
    private static final int lt_LT = 7;
    private static final int nl_NL = 8;
    private static final int pt_BR = 9;
    private static final int ru_RU = 10;
    private static final int sq_AL = 11;
    private static final int zh_CN = 12;
    private static final int th_TH = 13;
    private static final int ja_JP = 14;

    public static synchronized JasperReport getReport(String filename) throws Exception {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("JasperReportUtils-> Checking report: " + filename);
        }
        System.setProperty("jasper.reports.compiler.class", "net.sf.jasperreports.compilers.JRBshCompiler");
        String jasperFilename = filename.substring(0, filename.lastIndexOf(".xml"));
        File jasperFile = new File(jasperFilename + ".jasper");
        if (!jasperFile.exists()) {
            File xmlFile = new File(filename);
            if (!xmlFile.exists()) {
                return null;
            }
            JasperCompileManager.compileReportToFile((String)xmlFile.getPath(), (String)jasperFile.getPath());
        }
        if (!jasperFile.exists()) {
            return null;
        }
        return (JasperReport)JRLoader.loadObject((String)jasperFile.getPath());
    }

    public static byte[] getReportAsBytes(String filename, HashMap map, Connection db) throws Exception {
        JasperReport report = JasperReportUtils.getReport(filename);
        if (report == null) {
            return null;
        }
        return JasperRunManager.runReportToPdf((JasperReport)report, (Map)map, (Connection)db);
    }

    public static void readSystemFonts() {
        HashMap fontFaceNames = new HashMap();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        for (int i = 0; i < fonts.length; ++i) {
            String familyName = fonts[i].getFamily();
            String faceName = fonts[i].getName();
        }
    }

    public static void modifyFontProperties(JasperReport jasperReport, String reportsPath, String fontPath, String language) throws Exception {
        String pdfFont = JasperReportUtils.getPdfFont(language);
        String pdfEncoding = JasperReportUtils.getPdfEncoding(language);
        if (fontPath != null) {
            boolean proceed = true;
            String fontFile = fontPath + pdfFont + ".ttf";
            if (proceed) {
                if (pdfFont.startsWith("$") && pdfFont.endsWith("$")) {
                    fontFile = StringUtils.replace(pdfFont, "$", "");
                } else {
                    File file = new File(fontFile);
                    if (!file.exists()) {
                        System.out.println("Missing Font file: " + fontFile);
                        proceed = false;
                    }
                }
            }
            if (proceed) {
                JasperReportUtils.modifyBandProperties(jasperReport, reportsPath, fontFile, pdfEncoding);
            }
        }
    }

    private static void modifyBandProperties(JasperReport jasperReport, String reportsPath, String fontFile, String pdfEncoding) throws Exception {
        JRBand summary;
        JRBand lastPageFooter;
        JRBand pageFooter;
        JRBand columnFooter;
        JRBand detail;
        JRGroup[] groups;
        JRBand columnHeader;
        JRBand pageHeader;
        JRBand title = jasperReport.getTitle();
        if (title != null) {
            JasperReportUtils.modifyFontProperties(title.getElements(), reportsPath, fontFile, pdfEncoding);
        }
        if ((pageHeader = jasperReport.getPageHeader()) != null) {
            JasperReportUtils.modifyFontProperties(pageHeader.getElements(), reportsPath, fontFile, pdfEncoding);
        }
        if ((columnHeader = jasperReport.getColumnHeader()) != null) {
            JasperReportUtils.modifyFontProperties(columnHeader.getElements(), reportsPath, fontFile, pdfEncoding);
        }
        if ((groups = jasperReport.getGroups()) != null) {
            for (int i = 0; i < groups.length; ++i) {
                JRGroup group = groups[i];
                if (group == null) continue;
                if (group.getGroupHeader() != null) {
                    JasperReportUtils.modifyFontProperties(group.getGroupHeader().getElements(), reportsPath, fontFile, pdfEncoding);
                }
                if (group.getGroupFooter() == null) continue;
                JasperReportUtils.modifyFontProperties(group.getGroupFooter().getElements(), reportsPath, fontFile, pdfEncoding);
            }
        }
        if ((detail = jasperReport.getDetail()) != null) {
            JasperReportUtils.modifyFontProperties(detail.getElements(), reportsPath, fontFile, pdfEncoding);
        }
        if ((columnFooter = jasperReport.getColumnFooter()) != null) {
            JasperReportUtils.modifyFontProperties(columnFooter.getElements(), reportsPath, fontFile, pdfEncoding);
        }
        if ((pageFooter = jasperReport.getPageFooter()) != null) {
            JasperReportUtils.modifyFontProperties(pageFooter.getElements(), reportsPath, fontFile, pdfEncoding);
        }
        if ((lastPageFooter = jasperReport.getLastPageFooter()) != null) {
            JasperReportUtils.modifyFontProperties(lastPageFooter.getElements(), reportsPath, fontFile, pdfEncoding);
        }
        if ((summary = jasperReport.getSummary()) != null) {
            JasperReportUtils.modifyFontProperties(summary.getElements(), reportsPath, fontFile, pdfEncoding);
        }
    }

    private static void modifyFontProperties(JRElement[] elements, String reportsPath, String fontFile, String pdfEncoding) throws Exception {
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                JRElement element = elements[i];
                if (element instanceof JRTextElement) {
                    JRFont font = ((JRTextElement)element).getFont();
                    if (font == null) continue;
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("JasperReportUtils-> Specifying Font properties");
                    }
                    font.setPdfFontName(fontFile);
                    font.setPdfEncoding(pdfEncoding);
                    font.setPdfEmbedded(true);
                    continue;
                }
                if (!(element instanceof JRSubreport)) continue;
                String expression = ((JRSubreport)element).getExpression().getText().trim();
                if (expression.indexOf("\"") > -1 && expression.indexOf("\"") < expression.length()) {
                    expression = expression.substring(expression.indexOf("\"") + 1);
                }
                String jasperFileName = expression.substring(0, expression.indexOf("\""));
                String jasperFilePath = reportsPath + jasperFileName;
                File jasperFile = new File(jasperFilePath);
                if (!jasperFile.exists()) continue;
                JasperReport subReport = (JasperReport)JRLoader.loadObject((String)jasperFile.getPath());
                JasperReportUtils.modifyBandProperties(subReport, reportsPath, fontFile, pdfEncoding);
            }
        }
    }

    private static String getPdfFont(String language) {
        switch (JasperReportUtils.getCode(language)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return "LucidaSansUnicode";
            }
            case 12: {
                return "$STSong-Light$";
            }
            case 14: {
                return "$HeiseiMin-W3$";
            }
            case 13: {
                return "Garuda-Bold";
            }
        }
        return "$Helvetica$";
    }

    private static String getPdfEncoding(String language) {
        switch (JasperReportUtils.getCode(language)) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                return "CP1250";
            }
            case 10: {
                return "CP1251";
            }
            case 4: {
                return "CP1252";
            }
            case 3: {
                return "CP1253";
            }
            case 13: {
                return "Identity-H";
            }
            case 12: {
                return "UniGB-UCS2-H";
            }
            case 14: {
                return "UniJIS-UCS2-H";
            }
        }
        return "CP1250";
    }

    private static int getCode(String language) {
        if ("en_US".equals(language)) {
            return 1;
        }
        if ("de_DE".equals(language)) {
            return 2;
        }
        if ("es_VE".equals(language)) {
            return 4;
        }
        if ("hu_HU".equals(language)) {
            return 5;
        }
        if ("it_IT".equals(language)) {
            return 6;
        }
        if ("lt_LT".equals(language)) {
            return 7;
        }
        if ("nl_NL".equals(language)) {
            return 8;
        }
        if ("sq_AL".equals(language)) {
            return 11;
        }
        if ("ru_RU".equals(language)) {
            return 10;
        }
        if ("pt_BR".equals(language)) {
            return 9;
        }
        if ("el_GR".equals(language)) {
            return 3;
        }
        if ("th_TH".equals(language)) {
            return 13;
        }
        if ("zh_CN".equals(language)) {
            return 12;
        }
        if ("ja_JP".equals(language)) {
            return 14;
        }
        return 1;
    }
}

