/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRScriptletException;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JasperScriptletUtils
extends JRDefaultScriptlet {
    public void beforeReportInit() throws JRScriptletException {
    }

    public void afterReportInit() throws JRScriptletException {
    }

    public void beforePageInit() throws JRScriptletException {
    }

    public void afterPageInit() throws JRScriptletException {
    }

    public void beforeColumnInit() throws JRScriptletException {
    }

    public void afterColumnInit() throws JRScriptletException {
    }

    public void beforeGroupInit(String groupName) throws JRScriptletException {
    }

    public void afterGroupInit(String groupName) throws JRScriptletException {
    }

    public void beforeDetailEval() throws JRScriptletException {
    }

    public void afterDetailEval() throws JRScriptletException {
    }

    private Locale getLocale(String language, String country) {
        Locale locale = Locale.getDefault();
        if (language != null) {
            switch (language.length()) {
                case 2: {
                    if (country != null) {
                        locale = new Locale(language.substring(0, 2), country);
                        break;
                    }
                    locale = new Locale(language.substring(0, 2), "");
                    break;
                }
                case 5: {
                    locale = new Locale(language.substring(0, 2), language.substring(3, 5));
                    break;
                }
                case 10: {
                    locale = new Locale(language.substring(0, 2), language.substring(3, 5), language.substring(6));
                }
            }
        }
        return locale;
    }

    public String getLocaleFormat(Date date) throws JRScriptletException {
        if (date == null) {
            return "";
        }
        return this.getLocaleFormat(new Timestamp(date.getTime()));
    }

    public String getLocaleFormat(Date date, String pattern) throws JRScriptletException {
        if (date == null) {
            return "";
        }
        return this.getLocaleFormat(new Timestamp(date.getTime()), pattern);
    }

    public String getLocaleFormat(Timestamp ts) throws JRScriptletException {
        if (ts == null) {
            return "";
        }
        String language = (String)this.getParameterValue("language");
        String country = (String)this.getParameterValue("country");
        Locale locale = this.getLocale(language, country);
        SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale);
        formatter.applyPattern(DateUtils.get4DigitYearDateFormat(formatter.toPattern()));
        return formatter.format(ts);
    }

    public String getLocaleFormat(Timestamp ts, String pattern) throws JRScriptletException {
        if (ts == null) {
            return "";
        }
        String language = (String)this.getParameterValue("language");
        String country = (String)this.getParameterValue("country");
        Locale locale = this.getLocale(language, country);
        SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale);
        formatter.applyPattern(pattern);
        return formatter.format(ts);
    }

    public String getLocaleFormat(Double value) throws JRScriptletException {
        if (value == null) {
            return "";
        }
        String language = (String)this.getParameterValue("language");
        String country = (String)this.getParameterValue("country");
        String code = (String)this.getParameterValue("currency");
        Locale locale = this.getLocale(language, country);
        NumberFormat nf = NumberFormat.getCurrencyInstance(locale);
        if (code != null) {
            Currency currency = Currency.getInstance(code);
            nf.setCurrency(currency);
        }
        return nf.format(value);
    }

    public static boolean hasQuoteProductOptions(Connection db, int id) throws SQLException, JRScriptletException {
        boolean exists = false;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS recordcount FROM quote_product_options WHERE item_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next() && rs.getInt("recordcount") > 0) {
            exists = true;
        }
        rs.close();
        pst.close();
        return exists;
    }

    public String getFormattedQuoteProductTotalPrice(Connection db, int id) throws SQLException, JRScriptletException {
        QuoteProduct thisProduct = new QuoteProduct();
        thisProduct.setBuildProductOptions(true);
        thisProduct.queryRecord(db, id);
        return this.getLocaleFormat(new Double(thisProduct.getTotalPrice()));
    }

    public Double getQuoteProductTotalPrice(Connection db, int id) throws SQLException, JRScriptletException {
        QuoteProduct thisProduct = new QuoteProduct();
        thisProduct.setBuildProductOptions(true);
        thisProduct.queryRecord(db, id);
        return new Double(thisProduct.getTotalPrice());
    }

    public String getPaddedTicketId(int ticketId) {
        String paddedId = String.valueOf(ticketId);
        while (paddedId.length() < 6) {
            paddedId = "0" + paddedId;
        }
        return paddedId;
    }

    public String getPaddedQuoteId(int groupId, String version) {
        String paddedId = String.valueOf(groupId);
        while (paddedId.length() < 6) {
            paddedId = "0" + paddedId;
        }
        return paddedId + "(" + version + ")";
    }

    public static boolean activityItemsExist(Connection db, int id) throws SQLException, JRScriptletException {
        boolean exists = false;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS recordcount FROM ticket_csstm_form tcf, ticket_activity_item tai WHERE tcf.form_id = tai.link_form_id AND link_ticket_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next() && rs.getInt("recordcount") > 0) {
            exists = true;
        }
        rs.close();
        pst.close();
        return exists;
    }

    public static int getActionPlanNoteCount(Connection db, int planWorkId) throws SQLException, JRScriptletException {
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS notecount FROM action_plan_work_notes apwn WHERE apwn.plan_work_id = ? ");
        pst.setInt(1, planWorkId);
        ResultSet rs = pst.executeQuery();
        int count = 0;
        if (rs.next()) {
            count = rs.getInt("notecount");
        }
        pst.close();
        return count;
    }

    public static boolean maintenanceItemsExist(Connection db, int id) throws SQLException, JRScriptletException {
        boolean exists = false;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS recordcount FROM ticket_sun_form tsf, trouble_asset_replacement tar WHERE tar.link_form_id = tsf.form_id AND tsf.link_ticket_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next() && rs.getInt("recordcount") > 0) {
            exists = true;
        }
        rs.close();
        pst.close();
        return exists;
    }

    public static String getOrgAddress(Connection db, int orgId) throws SQLException, JRScriptletException {
        String url;
        String fax;
        String phone;
        StringBuffer sb = new StringBuffer();
        PreparedStatement pst = db.prepareStatement("SELECT addrline1, addrline2, addrline3, city, state, country, postalcode FROM organization_address addr WHERE org_id = ? AND address_type = 1 ");
        pst.setInt(1, orgId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            String addrline1 = rs.getString("addrline1");
            String addrline2 = rs.getString("addrline2");
            String addrline3 = rs.getString("addrline3");
            String city = rs.getString("city");
            String state = rs.getString("state");
            String country = rs.getString("country");
            String postalcode = rs.getString("postalcode");
            if (addrline1 != null && !"".equals(addrline1.trim())) {
                sb.append(addrline1);
            }
            if (addrline2 != null && !"".equals(addrline2.trim())) {
                if (sb.length() > 0) {
                    sb.append("\n" + addrline2);
                } else {
                    sb.append(addrline2);
                }
            }
            if (addrline3 != null && !"".equals(addrline3.trim())) {
                if (sb.length() > 0) {
                    sb.append("\n" + addrline3);
                } else {
                    sb.append(addrline3);
                }
            }
            if (city != null && !"".equals(city.trim())) {
                if (sb.length() > 0) {
                    sb.append("\n" + city);
                } else {
                    sb.append(city);
                }
            }
            if (state != null && !"".equals(state.trim())) {
                if (city != null && !"".equals(city.trim())) {
                    sb.append(", ");
                } else {
                    sb.append("\n");
                }
                sb.append(state);
            }
            if (postalcode != null && !"".equals(postalcode.trim())) {
                sb.append(" " + postalcode);
            }
            if (country != null && !"".equals(country.trim())) {
                sb.append("\n" + country);
            }
        }
        pst.close();
        pst = db.prepareStatement("SELECT " + DatabaseUtils.addQuotes(db, "number") + " AS phonenum " + "FROM organization_phone " + "WHERE org_id = ? AND phone_type = 1 ");
        pst.setInt(1, orgId);
        rs = pst.executeQuery();
        if (rs.next() && (phone = rs.getString("phonenum")) != null && !"".equals(phone.trim())) {
            if (sb.length() > 0) {
                sb.append("\nPhone: " + phone);
            } else {
                sb.append("Phone: " + phone);
            }
        }
        pst.close();
        pst = db.prepareStatement("SELECT " + DatabaseUtils.addQuotes(db, "number") + " AS faxnum " + "FROM organization_phone " + "WHERE org_id = ? AND phone_type = 2 ");
        pst.setInt(1, orgId);
        rs = pst.executeQuery();
        if (rs.next() && (fax = rs.getString("faxnum")) != null && !"".equals(fax.trim())) {
            if (sb.length() > 0) {
                sb.append("\nFax: " + fax);
            } else {
                sb.append("Fax: " + fax);
            }
        }
        pst.close();
        pst = db.prepareStatement("SELECT url FROM organization org WHERE org_id = ? ");
        pst.setInt(1, orgId);
        rs = pst.executeQuery();
        if (rs.next() && (url = rs.getString("url")) != null && !"".equals(url.trim())) {
            if (sb.length() > 0) {
                sb.append("\n" + url);
            } else {
                sb.append(url);
            }
        }
        rs.close();
        pst.close();
        return sb.toString();
    }

    public static String getQuoteContactAddress(Connection db, int quoteId) throws SQLException, JRScriptletException {
        StringBuffer sb = new StringBuffer();
        PreparedStatement pst = db.prepareStatement("SELECT email_address, phone_number, address, fax_number FROM quote_entry qe WHERE quote_id = ? ");
        pst.setInt(1, quoteId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            String email = rs.getString("email_address");
            String phone = rs.getString("phone_number");
            String address = rs.getString("address");
            String fax = rs.getString("fax_number");
            if (address != null && !"".equals(address.trim())) {
                sb.append(address);
            }
            if (phone != null && !"".equals(phone.trim())) {
                if (sb.length() > 0) {
                    sb.append("\nPhone: " + phone);
                } else {
                    sb.append("Phone: " + phone);
                }
            }
            if (fax != null && !"".equals(fax.trim())) {
                if (sb.length() > 0) {
                    sb.append("\nFax: " + fax);
                } else {
                    sb.append("Fax: " + fax);
                }
            }
            if (email != null && !"".equals(email.trim())) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append("Email: " + email);
            }
        }
        rs.close();
        pst.close();
        return sb.toString();
    }

    public static String getContactDetails(Connection db, int contactId) throws SQLException, JRScriptletException {
        StringBuffer sb = new StringBuffer();
        Contact contact = new Contact();
        contact.setBuildDetails(true);
        contact.queryRecord(db, contactId);
        if (contact.getCompany() != null) {
            sb.append(contact.getCompany());
        }
        for (ContactPhoneNumber thisPhoneNumber : contact.getPhoneNumberList()) {
            if (!thisPhoneNumber.getPrimaryNumber()) continue;
            sb.append((sb.length() > 0 ? "\r\n" : "") + thisPhoneNumber.getPhoneNumber());
        }
        for (ContactEmailAddress thisEmailAddress : contact.getEmailAddressList()) {
            if (!thisEmailAddress.getPrimaryEmail()) continue;
            sb.append((sb.length() > 0 ? "\r\n" : "") + thisEmailAddress.getEmail());
        }
        return sb.toString().trim();
    }

    public static String getLabel(Map localizationPrefs, String labelName, String defaultLabel) throws JRScriptletException {
        Node param;
        Map prefGroup;
        String section = "system.fields.label";
        String tagName = "value";
        String val = null;
        if (localizationPrefs != null && (prefGroup = (Map)localizationPrefs.get(section)) != null && (param = (Node)prefGroup.get(labelName)) != null) {
            val = XMLUtils.getNodeText(XMLUtils.getFirstChild((Element)param, tagName));
        }
        return val != null ? val : defaultLabel;
    }

    public static boolean contractLogExists(Connection db, int id) throws SQLException, JRScriptletException {
        boolean exists = false;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS recordcount FROM netapp_contractexpiration_log WHERE expiration_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next() && rs.getInt("recordcount") > 0) {
            exists = true;
        }
        rs.close();
        pst.close();
        return exists;
    }

    public static int getCallVolumeCount(Connection db, int siteId, int orgId, int code, int level, Timestamp dateStart, Timestamp dateEnd, int resolvable) throws SQLException, JRScriptletException {
        return JasperScriptletUtils.getCallVolumeCount(db, siteId, orgId, -1, -1, code, level, dateStart, dateEnd, resolvable);
    }

    public static int getCallVolumeCount(Connection db, int siteId, Timestamp entered, int code, int level, Timestamp dateStart, Timestamp dateEnd) throws SQLException, JRScriptletException {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(entered.getTime());
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        return JasperScriptletUtils.getCallVolumeCount(db, siteId, -1, month, year, code, level, dateStart, dateEnd, -1);
    }

    public static int getCallVolumeCount(Connection db, int siteId, int orgId, int month, int year, int code, int level, Timestamp dateStart, Timestamp dateEnd, int resolvable) throws SQLException, JRScriptletException {
        ResultSet rs;
        int count = -1;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT count(*) AS recordcount FROM ticket t LEFT JOIN organization o ON (t.org_id = o.org_id) WHERE t.ticketid > 0 AND o.enabled = ? AND t.trashed_date IS NULL AND t.ticketid NOT IN (SELECT ticket_id FROM ticketlink_project) ");
        if (dateStart != null) {
            sb.append("AND t.entered >= ? ");
        }
        if (dateEnd != null) {
            sb.append("AND t.entered <= ? ");
        }
        if (siteId > -1) {
            sb.append("AND t.site_id = ? ");
        }
        if (orgId > -1) {
            sb.append("AND t.org_id = ? ");
        }
        switch (level) {
            case 0: {
                sb.append("AND t.cat_code IS NULL AND t.subcat_code1 IS NULL AND t.subcat_code2 IS NULL AND t.subcat_code3 is NULL ");
                break;
            }
            case 1: {
                sb.append("AND t.cat_code = ? AND t.subcat_code1 IS NULL AND t.subcat_code2 IS NULL AND t.subcat_code3 is NULL ");
                break;
            }
            case 2: {
                sb.append("AND t.subcat_code1 = ? AND t.subcat_code2 IS NULL AND t.subcat_code3 is NULL ");
                break;
            }
            case 3: {
                sb.append("AND t.subcat_code2 = ? AND t.subcat_code3 is NULL ");
                break;
            }
            case 4: {
                sb.append("AND t.subcat_code3 = ? ");
            }
        }
        if (resolvable != -1) {
            sb.append("AND t.resolvable = ? ");
        }
        if (month > -1) {
            sb.append("AND " + DatabaseUtils.getMonthPart(db, "t.entered") + " = ? ");
        }
        if (year > -1) {
            sb.append("AND " + DatabaseUtils.getYearPart(db, "t.entered") + " = ? ");
        }
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sb.toString());
        pst.setBoolean(++i, true);
        if (dateStart != null) {
            pst.setTimestamp(++i, dateStart);
        }
        if (dateEnd != null) {
            pst.setTimestamp(++i, dateEnd);
        }
        if (siteId > -1) {
            pst.setInt(++i, siteId);
        }
        if (orgId > -1) {
            pst.setInt(++i, orgId);
        }
        if (level > 0) {
            pst.setInt(++i, code);
        }
        if (resolvable == 1) {
            pst.setBoolean(++i, true);
        } else if (resolvable == 0) {
            pst.setBoolean(++i, false);
        }
        if (month > -1) {
            pst.setInt(++i, month);
        }
        if (year > -1) {
            pst.setInt(++i, year);
        }
        if ((rs = pst.executeQuery()).next()) {
            count = rs.getInt("recordcount");
        }
        rs.close();
        pst.close();
        return count;
    }
}

