/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.sql.Connection;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.modules.base.EmailAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddressList;
import org.aspcfs.modules.login.beans.LoginBean;

public class LDAPUtils {
    public static int RESULT_NOT_REQUIRED = -1;
    public static int RESULT_INVALID = 0;
    public static int RESULT_VALID = 1;

    public static int authenticateUser(ApplicationPrefs prefs, Connection db, LoginBean bean) {
        String searchValue = null;
        if ("username".equals(prefs.get("LDAP.CENTRIC_CRM.FIELD"))) {
            searchValue = bean.getUsername();
        }
        try {
            if ("email".equals(prefs.get("LDAP.CENTRIC_CRM.FIELD"))) {
                ContactEmailAddressList emailAddressList = new ContactEmailAddressList();
                emailAddressList.setType(1);
                emailAddressList.setUsername(bean.getUsername());
                emailAddressList.buildList(db);
                if (emailAddressList.size() == 1) {
                    EmailAddress thisEmail = (EmailAddress)((Object)emailAddressList.get(0));
                    searchValue = thisEmail.getEmail();
                }
            }
        }
        catch (Exception e) {
            System.out.println("LDAPUtils-> authenticateUser error: " + e.getMessage());
            return RESULT_INVALID;
        }
        return LDAPUtils.authenticateUser(prefs, searchValue, bean.getLdapPassword());
    }

    public static int authenticateUser(ApplicationPrefs prefs, String username, String password) {
        if (username != null && LDAPUtils.isLdapString(username)) {
            String userDN = null;
            boolean searchByAttribute = "true".equals(prefs.get("LDAP.SEARCH.BY_ATTRIBUTE"));
            if (searchByAttribute) {
                userDN = LDAPUtils.searchLDAP(prefs, username);
            } else {
                String compositeDNprefix = prefs.get("LDAP.SEARCH.PREFIX");
                String compositeDNpostfix = prefs.get("LDAP.SEARCH.POSTFIX");
                userDN = compositeDNprefix + username + compositeDNpostfix;
            }
            if (LDAPUtils.authenticateLDAP(prefs, userDN, password)) {
                return RESULT_VALID;
            }
        } else {
            System.out.println("LDAPUtils-> Username is not a valid string");
        }
        return RESULT_INVALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String searchLDAP(ApplicationPrefs prefs, String searchValue) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", prefs.get("LDAP.FACTORY"));
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", prefs.get("LDAP.SEARCH.USERNAME"));
        env.put("java.naming.security.credentials", prefs.get("LDAP.SEARCH.PASSWORD"));
        env.put("java.naming.provider.url", prefs.get("LDAP.SERVER"));
        InitialDirContext ldap = null;
        try {
            ldap = new InitialDirContext(env);
            String searchName = prefs.get("LDAP.SEARCH.ATTRIBUTE");
            String searchContainer = prefs.get("LDAP.SEARCH.CONTAINER");
            boolean doSearchSubtree = "true".equals(prefs.get("LDAP.SEARCH.SUBTREE"));
            String filter = "(& (objectclass=" + prefs.get("LDAP.SEARCH.ORGPERSON") + ") (" + searchName + "=" + searchValue + " ). )";
            SearchControls cons = new SearchControls();
            cons.setSearchScope(doSearchSubtree ? 2 : 1);
            NamingEnumeration<SearchResult> results = ldap.search(searchContainer, filter, cons);
            if (results.hasMore()) {
                System.out.println("LDAPUtils-> Found user with " + searchName + "= " + searchValue);
                SearchResult object = results.next();
                String result = object.getName() + ',' + searchContainer;
                if (results.hasMore()) {
                    System.out.println("LDAPUtils-> Several users with same " + searchName + "= " + searchValue);
                    return null;
                }
                return result;
            }
            System.out.println("LDAPUtils-> Didn't find user with " + searchName + "= " + searchValue);
        }
        catch (Throwable t) {
            System.out.println("LDAPUtils-> Search in LDAP failed: " + t);
        }
        try {
            if (ldap != null) {
                ldap.close();
            }
        }
        catch (Exception e) {
        }
        finally {
            ldap = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean authenticateLDAP(ApplicationPrefs prefs, String userDN, String password) {
        boolean result = false;
        Context ldap = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", prefs.get("LDAP.FACTORY"));
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", userDN);
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.provider.url", prefs.get("LDAP.SERVER"));
            ldap = new InitialDirContext(env);
            result = true;
        }
        catch (Throwable t) {
            result = false;
            System.out.println("LDAPUtils-> LDAP authentication failed: " + t);
        }
        finally {
            try {
                ldap.close();
            }
            catch (Throwable t) {}
            ldap = null;
            System.out.println("LDAPUtils-> Authentication to LDAP - result: " + result);
        }
        return result;
    }

    public static boolean isLdapString(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '(' || c == ')' || c == '&' || c == '\'') {
                return false;
            }
            if (c == '@' || c == '-' || c == '+' || c == '.' || '0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == ' ') continue;
            return false;
        }
        return true;
    }
}

