/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.StringTokenizer;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.LookupList;

public class LeadUtils {
    public static synchronized int setReadStatus(Connection db, int contactId, int userId) throws SQLException {
        if (contactId == -1) {
            return -1;
        }
        int readId = -1;
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT user_id FROM contact_lead_read_map clrm WHERE clrm.contact_id = ? ");
        pst.setInt(1, contactId);
        rs = pst.executeQuery();
        if (rs.next()) {
            readId = DatabaseUtils.getInt(rs, "user_id");
        }
        rs.close();
        pst.close();
        if (readId == userId) {
            pst = db.prepareStatement("DELETE FROM contact_lead_skipped_map WHERE contact_id= ? AND user_id = ? ");
            pst.setInt(1, contactId);
            pst.setInt(2, userId);
            pst.execute();
            pst.close();
            return readId;
        }
        if (readId != -1) {
            return readId;
        }
        if (readId == -1) {
            pst = db.prepareStatement("DELETE FROM contact_lead_skipped_map WHERE contact_id= ? AND user_id = ? ");
            pst.setInt(1, contactId);
            pst.setInt(2, userId);
            pst.execute();
            pst.close();
            int mapId = DatabaseUtils.getNextSeq(db, "contact_lead_read_map_map_id_seq");
            pst = db.prepareStatement("INSERT INTO contact_lead_read_map (" + (mapId > -1 ? "map_id, " : "") + "contact_id, user_id) " + "VALUES(" + (mapId > -1 ? "?, " : "") + "?, ?)");
            int i = 0;
            if (mapId > -1) {
                pst.setInt(++i, mapId);
            }
            pst.setInt(++i, contactId);
            pst.setInt(++i, userId);
            pst.execute();
            pst.close();
            mapId = DatabaseUtils.getCurrVal(db, "contact_lead_read_map_map_id_seq", mapId);
            return userId;
        }
        return -1;
    }

    public static synchronized boolean skipLead(Connection db, int contactId, int userId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int mapId = -1;
        int readId = -1;
        int ownerId = 0;
        pst = db.prepareStatement("SELECT owner FROM contact WHERE contact_id = ?");
        pst.setInt(1, contactId);
        rs = pst.executeQuery();
        if (rs.next()) {
            ownerId = DatabaseUtils.getInt(rs, "owner");
        }
        rs.close();
        pst.close();
        pst = db.prepareStatement("SELECT map_id, user_id FROM contact_lead_read_map WHERE contact_id = ?");
        pst.setInt(1, contactId);
        rs = pst.executeQuery();
        if (rs.next()) {
            mapId = DatabaseUtils.getInt(rs, "map_id");
            readId = DatabaseUtils.getInt(rs, "user_id");
        }
        rs.close();
        pst.close();
        if (mapId == -1) {
            return false;
        }
        if (userId == readId && ownerId != userId && userId == readId && ownerId == -1) {
            pst = db.prepareStatement("DELETE FROM contact_lead_read_map WHERE map_id = ?");
            pst.setInt(1, mapId);
            pst.execute();
            pst.close();
            int skipMapId = -1;
            skipMapId = DatabaseUtils.getNextSeq(db, "contact_lead_skipped_map_map_id_seq");
            pst = db.prepareStatement("INSERT INTO contact_lead_skipped_map (" + (skipMapId > -1 ? "map_id, " : "") + "contact_id, user_id) " + "VALUES (" + (skipMapId > -1 ? "?, " : "") + "?, ?)");
            int i = 0;
            if (skipMapId > -1) {
                pst.setInt(++i, skipMapId);
            }
            pst.setInt(++i, contactId);
            pst.setInt(++i, userId);
            pst.execute();
            pst.close();
            skipMapId = DatabaseUtils.getCurrVal(db, "contact_lead_skipped_map_map_id_seq", skipMapId);
        }
        return true;
    }

    public static synchronized int cleanUpContact(Connection db, int contactId, int userId) throws SQLException {
        PreparedStatement pst = null;
        pst = db.prepareStatement("DELETE FROM contact_lead_read_map WHERE contact_id = ?");
        pst.setInt(1, contactId);
        int size = pst.executeUpdate();
        pst.close();
        pst = db.prepareStatement("DELETE FROM contact_lead_skipped_map WHERE contact_id = ?");
        pst.setInt(1, contactId);
        pst.close();
        return size += pst.executeUpdate();
    }

    public static synchronized boolean tryToAssignLead(Connection db, int contactId, int userId) throws SQLException {
        boolean lead = true;
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT lead FROM contact c WHERE c.contact_id = ? ");
        pst.setInt(1, contactId);
        rs = pst.executeQuery();
        if (rs.next()) {
            lead = rs.getBoolean("lead");
        }
        rs.close();
        pst.close();
        if (!lead) {
            return false;
        }
        pst = db.prepareStatement("DELETE FROM contact_lead_read_map WHERE contact_id = ? ");
        pst.setInt(1, contactId);
        pst.execute();
        pst.close();
        pst = db.prepareStatement("UPDATE contact SET owner = ? WHERE contact_id = ?");
        pst.setInt(1, userId);
        pst.setInt(2, contactId);
        int result = pst.executeUpdate();
        pst.close();
        int mapId = DatabaseUtils.getNextSeq(db, "contact_lead_read_map_map_id_seq");
        pst = db.prepareStatement("INSERT INTO contact_lead_read_map (" + (mapId > -1 ? "map_id, " : "") + "contact_id, user_id) " + "VALUES(" + (mapId > -1 ? "?, " : "") + "?, ?)");
        int i = 0;
        if (mapId > -1) {
            pst.setInt(++i, mapId);
        }
        pst.setInt(++i, contactId);
        pst.setInt(++i, userId);
        pst.execute();
        pst.close();
        mapId = DatabaseUtils.getCurrVal(db, "contact_lead_read_map_map_id_seq", mapId);
        return true;
    }

    public static synchronized boolean tryToAssignLead(Connection db, int contactId, int userId, int ownerId) throws SQLException {
        boolean lead = true;
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement("SELECT lead FROM contact c WHERE c.contact_id = ? ");
        pst.setInt(1, contactId);
        rs = pst.executeQuery();
        if (rs.next()) {
            lead = rs.getBoolean("lead");
        }
        rs.close();
        pst.close();
        if (!lead) {
            return false;
        }
        pst = db.prepareStatement("DELETE FROM contact_lead_read_map WHERE contact_id = ? ");
        pst.setInt(1, contactId);
        pst.execute();
        pst.close();
        pst = db.prepareStatement("UPDATE contact SET owner = ? WHERE contact_id = ?");
        pst.setInt(1, ownerId);
        pst.setInt(2, contactId);
        int result = pst.executeUpdate();
        pst.close();
        if (userId == ownerId) {
            int mapId = DatabaseUtils.getNextSeq(db, "contact_lead_read_map_map_id_seq");
            pst = db.prepareStatement("INSERT INTO contact_lead_read_map (" + (mapId > -1 ? "map_id, " : "") + "contact_id, user_id) " + "VALUES(" + (mapId > -1 ? "?, " : "") + "?, ?)");
            int i = 0;
            if (mapId > -1) {
                pst.setInt(++i, mapId);
            }
            pst.setInt(++i, contactId);
            pst.setInt(++i, userId);
            pst.execute();
            pst.close();
            mapId = DatabaseUtils.getCurrVal(db, "contact_lead_read_map_map_id_seq", mapId);
        }
        return true;
    }

    public static synchronized int getNextLead(Connection db, int contactId, ContactList criteria, int siteId, boolean includeContactsAllSites) throws SQLException {
        int nextContactId = -1;
        PreparedStatement pst = null;
        ResultSet rs = null;
        if (criteria.getOldestFirst() == 0 && contactId == 0) {
            pst = db.prepareStatement("SELECT MAX(contact_id) as contact_id FROM contact ");
            rs = pst.executeQuery();
            if (rs.next()) {
                contactId = DatabaseUtils.getInt(rs, "contact_id") + 1;
            }
            rs.close();
            pst.close();
        }
        StringBuffer sql = new StringBuffer("");
        if (criteria.getOldestFirst() != 0) {
            sql.append("SELECT MIN(c.contact_id) AS contact_id ");
        } else {
            sql.append("SELECT MAX(c.contact_id) AS contact_id ");
        }
        sql.append("FROM contact c ");
        if (criteria.getOldestFirst() != 0) {
            sql.append("WHERE c.contact_id > ? AND c.trashed_date IS NULL ");
        } else {
            sql.append("WHERE c.contact_id < ? AND c.trashed_date IS NULL ");
        }
        LeadUtils.createFilter(db, sql, criteria, siteId, includeContactsAllSites);
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, 1, contactId);
        LeadUtils.prepareFilter(pst, criteria, siteId, includeContactsAllSites);
        rs = pst.executeQuery();
        if (rs.next()) {
            nextContactId = DatabaseUtils.getInt(rs, "contact_id");
        }
        rs.close();
        pst.close();
        return nextContactId;
    }

    private static void createFilter(Connection db, StringBuffer sqlFilter, ContactList criteria, int siteId, boolean includeContactsAllSites) throws SQLException {
        int owner = criteria.getOwner();
        int leadStatus = criteria.getLeadStatus();
        int leadsOnly = criteria.getLeadsOnly();
        int readBy = criteria.getReadBy();
        int source = criteria.getSource();
        int rating = criteria.getRating();
        int leadStatusExists = criteria.getLeadStatusExists();
        String postalCode = criteria.getPostalCode();
        int employeesOnly = criteria.getEmployeesOnly();
        boolean ownerOrReader = criteria.getOwnerOrReader();
        int hasConversionDate = criteria.getHasConversionDate();
        String country = criteria.getCountry();
        String emailAddress = criteria.getEmailAddress();
        Timestamp enteredStart = criteria.getEnteredStart();
        Timestamp enteredEnd = criteria.getEnteredEnd();
        Timestamp conversionDateStart = criteria.getConversionDateStart();
        Timestamp conversionDateEnd = criteria.getConversionDateEnd();
        String company = criteria.getCompany();
        String firstName = criteria.getFirstName();
        String lastName = criteria.getLastName();
        sqlFilter.append("AND c.lead = ? ");
        if (owner != -1) {
            sqlFilter.append("AND c.owner = ? ");
        }
        if (leadStatus > 0 && employeesOnly == -1) {
            if (leadStatus == 1 || leadStatus == 3 || leadStatus == 2) {
                sqlFilter.append("AND c.lead_status = ? ");
            }
        } else if (leadsOnly == 1 && leadStatus == 0 && readBy == -1 && !ownerOrReader && employeesOnly == -1) {
            sqlFilter.append("AND c.lead_status = ? ");
            sqlFilter.append("AND c.contact_id NOT IN ( SELECT clm.contact_id AS contact_id FROM contact_lead_read_map clm WHERE clm.user_id <> ? ) AND c.contact_id NOT IN ( SELECT clsm.contact_id AS contact_id FROM contact_lead_skipped_map clsm WHERE clsm.user_id = ?) ");
        } else if (leadStatus == -1 && readBy == -1 && employeesOnly == -1 && leadsOnly == 1) {
            sqlFilter.append("AND c.lead_status IN (?, ?, ?) ");
        }
        if (source > -1) {
            sqlFilter.append("AND c.source = ? ");
        }
        if (rating > -1) {
            sqlFilter.append("AND c.rating = ? ");
        }
        if (leadsOnly == 1 && readBy > -1 && !ownerOrReader) {
            sqlFilter.append("AND c.contact_id NOT IN ( SELECT clsm.contact_id AS contact_id FROM contact_lead_skipped_map clsm WHERE clsm.user_id = ?) AND c.contact_id IN ( SELECT clrm.contact_id AS contact_id FROM contact_lead_read_map clrm WHERE clrm.user_id = ? ) ");
        }
        if (leadStatusExists == 1) {
            sqlFilter.append("AND c.lead_status IS NOT NULL ");
        } else if (leadStatusExists == 0) {
            sqlFilter.append("AND c.lead_status IS NULL ");
        }
        if (enteredStart != null) {
            sqlFilter.append("AND c.entered >= ? ");
        }
        if (enteredEnd != null) {
            sqlFilter.append("AND c.entered <= ? ");
        }
        if (conversionDateStart != null) {
            sqlFilter.append("AND c.conversion_date >= ? ");
        }
        if (conversionDateEnd != null) {
            sqlFilter.append("AND c.conversion_date <= ? ");
        }
        if (emailAddress != null) {
            sqlFilter.append("AND c.contact_id IN (SELECT cc.contact_id FROM contact cc LEFT JOIN contact_emailaddress ce ON (cc.contact_id = ce.contact_id ) WHERE cc.contact_id = c.contact_id AND ce.email = ? )");
        }
        if (postalCode != null) {
            sqlFilter.append("AND c.contact_id IN (SELECT cc.contact_id FROM contact cc LEFT JOIN contact_address ca ON (cc.contact_id = ca.contact_id) WHERE ca.postalcode = ? ) ");
        }
        if (hasConversionDate == 1) {
            sqlFilter.append("AND c.conversion_date IS NOT NULL ");
        } else if (hasConversionDate == 0) {
            sqlFilter.append("AND c.conversion_date IS NULL ");
        }
        if (country != null && !"-1".equals(country)) {
            sqlFilter.append("AND c.contact_id IN (SELECT cc.contact_id FROM contact cc LEFT JOIN contact_address ca ON (cc.contact_id = ca.contact_id) WHERE ca.country = ? ) ");
        }
        if (ownerOrReader) {
            sqlFilter.append("AND c.contact_id NOT IN ( SELECT clsm.contact_id AS contact_id FROM contact_lead_skipped_map clsm WHERE clsm.user_id = ?) AND (c.owner = ? OR c.contact_id IN (SELECT cr.contact_id AS contact_id FROM contact_lead_read_map cr WHERE cr.user_id = ?)) ");
        }
        if (siteId != -1) {
            sqlFilter.append("AND c.site_id = ? ");
        } else if (!includeContactsAllSites) {
            sqlFilter.append("AND c.site_id IS NULL ");
        }
        if (company != null) {
            if (company.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.org_name) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.org_name) = ? ");
            }
        }
        if (firstName != null) {
            if (firstName.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.namefirst) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.namefirst) = ? ");
            }
        }
        if (lastName != null) {
            if (lastName.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.namelast) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(c.namelast) = ? ");
            }
        }
    }

    private static int prepareFilter(PreparedStatement pst, ContactList criteria, int siteId, boolean includeContactsAllSites) throws SQLException {
        int i = 1;
        int owner = criteria.getOwner();
        int leadStatus = criteria.getLeadStatus();
        int leadsOnly = criteria.getLeadsOnly();
        int readBy = criteria.getReadBy();
        int source = criteria.getSource();
        int rating = criteria.getRating();
        int leadStatusExists = criteria.getLeadStatusExists();
        String postalCode = criteria.getPostalCode();
        int userId = criteria.getUserId();
        int employeesOnly = criteria.getEmployeesOnly();
        boolean ownerOrReader = criteria.getOwnerOrReader();
        int hasConversionDate = criteria.getHasConversionDate();
        String country = criteria.getCountry();
        String emailAddress = criteria.getEmailAddress();
        Timestamp enteredStart = criteria.getEnteredStart();
        Timestamp enteredEnd = criteria.getEnteredEnd();
        Timestamp conversionDateStart = criteria.getConversionDateStart();
        Timestamp conversionDateEnd = criteria.getConversionDateEnd();
        String company = criteria.getCompany();
        String firstName = criteria.getFirstName();
        String lastName = criteria.getLastName();
        pst.setBoolean(++i, true);
        if (owner != -1) {
            pst.setInt(++i, owner);
        }
        if (leadStatus > 0 && employeesOnly == -1) {
            if (leadStatus == 1 || leadStatus == 3 || leadStatus == 2) {
                pst.setInt(++i, leadStatus);
            }
        } else if (leadsOnly == 1 && leadStatus == 0 && readBy == -1 && !ownerOrReader && employeesOnly == -1) {
            pst.setInt(++i, 1);
            pst.setInt(++i, userId);
            pst.setInt(++i, userId);
        } else if (leadStatus == -1 && readBy == -1 && employeesOnly == -1 && leadsOnly == 1) {
            pst.setInt(++i, 3);
            pst.setInt(++i, 2);
            pst.setInt(++i, 1);
        }
        if (source > -1) {
            pst.setInt(++i, source);
        }
        if (rating > -1) {
            pst.setInt(++i, rating);
        }
        if (leadsOnly == 1 && readBy > -1 && !ownerOrReader) {
            pst.setInt(++i, readBy);
            pst.setInt(++i, readBy);
        }
        if (enteredStart != null) {
            pst.setTimestamp(++i, enteredStart);
        }
        if (enteredEnd != null) {
            pst.setTimestamp(++i, enteredEnd);
        }
        if (conversionDateStart != null) {
            pst.setTimestamp(++i, conversionDateStart);
        }
        if (conversionDateEnd != null) {
            pst.setTimestamp(++i, conversionDateEnd);
        }
        if (emailAddress != null) {
            pst.setString(++i, emailAddress);
        }
        if (postalCode != null) {
            pst.setString(++i, postalCode);
        }
        if (country != null && !"-1".equals(country)) {
            pst.setString(++i, country);
        }
        if (ownerOrReader) {
            pst.setInt(++i, readBy);
            pst.setInt(++i, owner);
            pst.setInt(++i, readBy);
        }
        if (siteId != -1) {
            pst.setInt(++i, siteId);
        }
        if (company != null) {
            pst.setString(++i, company.toLowerCase());
        }
        if (firstName != null) {
            pst.setString(++i, firstName.toLowerCase());
        }
        if (lastName != null) {
            pst.setString(++i, lastName.toLowerCase());
        }
        return i;
    }

    public static int getLeadsAssigned(Connection db, String userIdRange, Timestamp startDate, Timestamp endDate) throws SQLException {
        int count = 0;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS resultcount FROM action_plan_work apw WHERE apw.plan_work_id > -1 AND apw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) AND apw.assignedto IN (" + userIdRange + ") " + "AND apw.entered >= ? AND apw.entered <= ? ");
        int i = 0;
        pst.setInt(++i, 42420034);
        DatabaseUtils.setTimestamp(pst, ++i, startDate);
        DatabaseUtils.setTimestamp(pst, ++i, endDate);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("resultcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public static int getLeadsActive(Connection db, String userIdRange, Timestamp endDate) throws SQLException {
        int count = 0;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS resultcount FROM action_plan_work apw LEFT JOIN action_phase_work aphw ON (apw.plan_work_id = aphw.plan_work_id) LEFT JOIN action_item_work aiw ON (aphw.phase_work_id = aiw.phase_work_id) LEFT JOIN opportunity_component oc ON (aiw.link_item_id = oc.id) WHERE apw.plan_work_id > -1 AND apw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) AND aiw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) AND apw.assignedto IN (" + userIdRange + ") " + "AND apw.plan_work_id IN (SELECT pw.plan_work_id " + "                             FROM action_plan_work pw " + "                             LEFT JOIN action_phase_work phw ON (pw.plan_work_id = phw.plan_work_id) " + "                             LEFT JOIN action_item_work iw ON (phw.phase_work_id = iw.phase_work_id) " + "                             WHERE pw.plan_work_id > -1 " + "                             AND pw.entered < ? " + "                             AND iw.end_date IS NULL OR iw.end_date > ? ) ");
        int i = 0;
        pst.setInt(++i, 42420034);
        pst.setInt(++i, 1011200517);
        DatabaseUtils.setTimestamp(pst, ++i, endDate);
        DatabaseUtils.setTimestamp(pst, ++i, endDate);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("resultcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public static int getLeadsUnassigned(Connection db, String userIdRange, Timestamp endDate) throws SQLException {
        int count = 0;
        PreparedStatement pst1 = db.prepareStatement("SELECT count(*) AS resultcount FROM organization o WHERE o.owner IN (" + userIdRange + ") " + "AND o.entered < ? " + "AND o.org_id NOT IN (" + "  SELECT pw.link_item_id " + "  FROM action_plan_work pw " + "  WHERE pw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?)) ");
        int i = 0;
        DatabaseUtils.setTimestamp(pst1, ++i, endDate);
        pst1.setInt(++i, 42420034);
        ResultSet rs1 = pst1.executeQuery();
        if (rs1.next()) {
            count = rs1.getInt("resultcount");
        }
        rs1.close();
        pst1.close();
        PreparedStatement pst2 = db.prepareStatement("SELECT count(*) AS resultcount FROM organization o WHERE o.owner IN (" + userIdRange + ") " + "AND o.entered < ? " + "AND o.org_id IN (" + "  SELECT pw.link_item_id " + "  FROM action_plan_work pw " + "  WHERE pw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) " + "  AND pw.entered > ?) ");
        i = 0;
        DatabaseUtils.setTimestamp(pst2, ++i, endDate);
        pst2.setInt(++i, 42420034);
        DatabaseUtils.setTimestamp(pst2, ++i, endDate);
        ResultSet rs2 = pst2.executeQuery();
        if (rs2.next()) {
            count += rs2.getInt("resultcount");
        }
        rs2.close();
        pst2.close();
        return count;
    }

    public static int getAccountsWon(Connection db, String userIdRange, Timestamp startDate, Timestamp endDate) throws SQLException {
        int count = 0;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS resultcount FROM action_plan_work apw LEFT JOIN action_phase_work aphw ON (apw.plan_work_id = aphw.plan_work_id) LEFT JOIN action_item_work aiw ON (aphw.phase_work_id = aiw.phase_work_id) LEFT JOIN action_step acs ON (aiw.action_step_id = acs.step_id) LEFT JOIN custom_field_record cfr ON (aiw.link_item_id = cfr.record_id) LEFT JOIN custom_field_data cfd ON (cfr.record_id = cfd.record_id) LEFT JOIN custom_field_info cfi ON (cfd.field_id = cfi.field_id) LEFT JOIN custom_field_lookup cfl ON (cfd.selected_item_id = cfl.code) WHERE apw.plan_work_id > -1 AND apw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) AND aiw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) AND apw.assignedto IN (" + userIdRange + ") " + "AND acs.action_id = ? " + "AND cfi.field_type = ? " + "AND cfl.code = ? " + "AND cfr.modified >= ? AND cfr.modified <= ? ");
        int i = 0;
        pst.setInt(++i, 42420034);
        pst.setInt(++i, 42420034);
        pst.setInt(++i, 110061033);
        pst.setInt(++i, 2);
        pst.setInt(++i, 20);
        DatabaseUtils.setTimestamp(pst, ++i, startDate);
        DatabaseUtils.setTimestamp(pst, ++i, endDate);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("resultcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public static int getAccountsLost(Connection db, String userIdRange, Timestamp startDate, Timestamp endDate) throws SQLException {
        int count = 0;
        String lostIdRange = "23,24,25,26,27";
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS resultcount FROM action_plan_work apw LEFT JOIN action_phase_work aphw ON (apw.plan_work_id = aphw.plan_work_id) LEFT JOIN action_item_work aiw ON (aphw.phase_work_id = aiw.phase_work_id) LEFT JOIN action_step acs ON (aiw.action_step_id = acs.step_id) LEFT JOIN custom_field_record cfr ON (aiw.link_item_id = cfr.record_id) LEFT JOIN custom_field_data cfd ON (cfr.record_id = cfd.record_id) LEFT JOIN custom_field_info cfi ON (cfd.field_id = cfi.field_id) LEFT JOIN custom_field_lookup cfl ON (cfd.selected_item_id = cfl.code) WHERE apw.plan_work_id > -1 AND apw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) AND aiw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) AND apw.assignedto IN (" + userIdRange + ") " + "AND acs.action_id = ? " + "AND cfi.field_type = ? " + "AND cfl.code IN (" + lostIdRange + ") " + "AND cfr.modified >= ? AND cfr.modified <= ? ");
        int i = 0;
        pst.setInt(++i, 42420034);
        pst.setInt(++i, 42420034);
        pst.setInt(++i, 110061033);
        pst.setInt(++i, 2);
        DatabaseUtils.setTimestamp(pst, ++i, startDate);
        DatabaseUtils.setTimestamp(pst, ++i, endDate);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("resultcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public static int getAccountsWon(Connection db, String userIdRange, Timestamp startDate, Timestamp endDate, int days) throws SQLException {
        int count = 0;
        PreparedStatement pst = db.prepareStatement("SELECT apw.entered as date_assigned, cfr.modified as date_won FROM action_plan_work apw LEFT JOIN action_phase_work aphw ON (apw.plan_work_id = aphw.plan_work_id) LEFT JOIN action_item_work aiw ON (aphw.phase_work_id = aiw.phase_work_id) LEFT JOIN action_step acs ON (aiw.action_step_id = acs.step_id) LEFT JOIN custom_field_record cfr ON (aiw.link_item_id = cfr.record_id) LEFT JOIN custom_field_data cfd ON (cfr.record_id = cfd.record_id) LEFT JOIN custom_field_info cfi ON (cfd.field_id = cfi.field_id) LEFT JOIN custom_field_lookup cfl ON (cfd.selected_item_id = cfl.code) WHERE apw.plan_work_id > -1 AND apw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) AND aiw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) AND apw.assignedto IN (" + userIdRange + ") " + "AND acs.action_id = ? " + "AND cfi.field_type = ? " + "AND cfl.code = ? " + "AND cfr.modified >= ? AND cfr.modified <= ? ");
        int i = 0;
        pst.setInt(++i, 42420034);
        pst.setInt(++i, 42420034);
        pst.setInt(++i, 110061033);
        pst.setInt(++i, 2);
        pst.setInt(++i, 20);
        DatabaseUtils.setTimestamp(pst, ++i, startDate);
        DatabaseUtils.setTimestamp(pst, ++i, endDate);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            Timestamp dateWon = rs.getTimestamp("date_won");
            Timestamp dateAssigned = rs.getTimestamp("date_assigned");
            Calendar won = Calendar.getInstance();
            Calendar assigned = Calendar.getInstance();
            won.setTimeInMillis(dateWon.getTime());
            assigned.setTimeInMillis(dateAssigned.getTime());
            if (DateUtils.getDaysBetween(won, assigned) > days) continue;
            ++count;
        }
        rs.close();
        pst.close();
        return count;
    }

    public static Timestamp getPlanAssignedDate(Connection db, int planId) throws SQLException {
        Timestamp dateAssigned = null;
        PreparedStatement pst = db.prepareStatement("SELECT aiw.end_date FROM action_plan_work apw LEFT JOIN action_phase_work aphw ON (apw.plan_work_id = aphw.plan_work_id) LEFT JOIN action_item_work aiw ON (aphw.phase_work_id = aiw.phase_work_id) LEFT JOIN action_step acs ON (aiw.action_step_id = acs.step_id) WHERE apw.plan_work_id > -1 AND acs.action_id = ? AND apw.plan_work_id = ? ");
        int i = 0;
        pst.setInt(++i, 110061033);
        pst.setInt(++i, planId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            dateAssigned = rs.getTimestamp("end_date");
        }
        rs.close();
        pst.close();
        return dateAssigned;
    }

    public static int getAverageDays(Connection db, String userIdRange, String status, Timestamp startDate, Timestamp endDate) throws SQLException {
        int count = 0;
        int days = 0;
        String lookupIds = "WIN".equals(status) ? "20" : "23,24,25,26,27";
        PreparedStatement pst = db.prepareStatement("SELECT apw.entered as date_assigned, cfr.modified as date_closed FROM action_plan_work apw LEFT JOIN action_phase_work aphw ON (apw.plan_work_id = aphw.plan_work_id) LEFT JOIN action_item_work aiw ON (aphw.phase_work_id = aiw.phase_work_id) LEFT JOIN action_step acs ON (aiw.action_step_id = acs.step_id) LEFT JOIN custom_field_record cfr ON (aiw.link_item_id = cfr.record_id) LEFT JOIN custom_field_data cfd ON (cfr.record_id = cfd.record_id) LEFT JOIN custom_field_info cfi ON (cfd.field_id = cfi.field_id) LEFT JOIN custom_field_lookup cfl ON (cfd.selected_item_id = cfl.code) WHERE apw.plan_work_id > -1 AND apw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) AND aiw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) AND apw.assignedto IN (" + userIdRange + ") " + "AND acs.action_id = ? " + "AND cfi.field_type = ? " + "AND cfl.code IN (" + lookupIds + ") " + "AND cfr.modified >= ? AND cfr.modified <= ? ");
        int i = 0;
        pst.setInt(++i, 42420034);
        pst.setInt(++i, 42420034);
        pst.setInt(++i, 110061033);
        pst.setInt(++i, 2);
        DatabaseUtils.setTimestamp(pst, ++i, startDate);
        DatabaseUtils.setTimestamp(pst, ++i, endDate);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            Timestamp dateClosed = rs.getTimestamp("date_closed");
            Timestamp dateAssigned = rs.getTimestamp("date_assigned");
            Calendar closed = Calendar.getInstance();
            Calendar assigned = Calendar.getInstance();
            closed.setTimeInMillis(dateClosed.getTime());
            assigned.setTimeInMillis(dateAssigned.getTime());
            days += DateUtils.getDaysBetween(assigned, closed);
            ++count;
        }
        rs.close();
        pst.close();
        return days > 0 ? days / count : 0;
    }

    public static int getDaysToWin(Connection db, Timestamp assignedDate, Timestamp conversionDate) throws SQLException {
        Calendar assigned = Calendar.getInstance();
        Calendar conversion = Calendar.getInstance();
        assigned.setTimeInMillis(assignedDate.getTime());
        conversion.setTimeInMillis(conversionDate.getTime());
        return DateUtils.getDaysBetween(assigned, conversion);
    }

    public static int getLeadsGenerated(Connection db, int userId, String source, Timestamp startDate, Timestamp endDate) throws SQLException {
        int count = 0;
        String sourceRange = "";
        LookupList sourceLookup = new LookupList(db, "lookup_contact_source");
        if (source.indexOf("|") == -1) {
            sourceRange = sourceRange + sourceLookup.getIdFromValue(source);
        } else {
            StringTokenizer st = new StringTokenizer(source, "|");
            while (st.hasMoreTokens()) {
                sourceRange = sourceRange + sourceLookup.getIdFromValue(st.nextToken()) + (st.hasMoreTokens() ? ", " : "");
            }
        }
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS resultcount FROM organization o WHERE o.org_id > -1 AND o.owner = ? AND o.source IN (" + sourceRange + ") " + "AND o.entered >= ? AND o.entered <= ? ");
        int i = 0;
        pst.setInt(++i, userId);
        DatabaseUtils.setTimestamp(pst, ++i, startDate);
        DatabaseUtils.setTimestamp(pst, ++i, endDate);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("resultcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public static int getLeadsConverted(Connection db, int userId, String source, Timestamp startDate, Timestamp endDate) throws SQLException {
        int count = 0;
        String sourceRange = "";
        LookupList sourceLookup = new LookupList(db, "lookup_contact_source");
        if (source.indexOf("|") == -1) {
            sourceRange = sourceRange + sourceLookup.getIdFromValue(source);
        } else {
            StringTokenizer st = new StringTokenizer(source, "|");
            while (st.hasMoreTokens()) {
                sourceRange = sourceRange + sourceLookup.getIdFromValue(st.nextToken()) + (st.hasMoreTokens() ? ", " : "");
            }
        }
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS resultcount FROM action_plan_work apw LEFT JOIN action_phase_work aphw ON (apw.plan_work_id = aphw.plan_work_id) LEFT JOIN action_item_work aiw ON (aphw.phase_work_id = aiw.phase_work_id) LEFT JOIN action_step acs ON (aiw.action_step_id = acs.step_id) LEFT JOIN organization o ON (apw.link_item_id = o.org_id) LEFT JOIN custom_field_record cfr ON (aiw.link_item_id = cfr.record_id) LEFT JOIN custom_field_data cfd ON (cfr.record_id = cfd.record_id) LEFT JOIN custom_field_info cfi ON (cfd.field_id = cfi.field_id) LEFT JOIN custom_field_lookup cfl ON (cfd.selected_item_id = cfl.code) WHERE apw.plan_work_id > -1 AND o.source IN (" + sourceRange + ") " + "AND apw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) " + "AND aiw.link_module_id IN (SELECT map_id FROM action_plan_constants WHERE constant_id = ?) " + "AND apw.assignedto = ? " + "AND acs.action_id = ? " + "AND cfi.field_type = ? " + "AND cfl.code = ? " + "AND cfr.modified >= ? AND cfr.modified <= ? ");
        int i = 0;
        pst.setInt(++i, 42420034);
        pst.setInt(++i, 42420034);
        pst.setInt(++i, userId);
        pst.setInt(++i, 110061033);
        pst.setInt(++i, 2);
        pst.setInt(++i, 20);
        DatabaseUtils.setTimestamp(pst, ++i, startDate);
        DatabaseUtils.setTimestamp(pst, ++i, endDate);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("resultcount");
        }
        rs.close();
        pst.close();
        return count;
    }
}

