/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.login.beans.LoginBean;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.LDAPUtils;

public class LoginUtils {
    private String username = null;
    private String password = null;
    private int userId = -1;
    private int roleId = -1;
    private String role = null;
    private int roleType = -1;
    private int aliasId = -1;
    private int tmpUserId = -1;
    private Timestamp expires = null;
    private boolean hasWebdavAccess = false;
    private boolean hasHttpApiAccess = false;
    private SystemStatus thisSystem = null;
    private ApplicationPrefs applicationPrefs = null;
    private String code = null;
    private UserBean thisUser = null;
    private boolean built = false;

    public LoginUtils(Connection db, String username, String password) throws Exception {
        this.username = username;
        this.password = password;
        this.build(db);
    }

    public LoginUtils(Connection db, LoginBean loginBean) throws Exception {
        this.username = loginBean.getUsername();
        this.password = loginBean.getPassword();
        this.build(db);
    }

    public UserBean getUserBean() {
        return this.thisUser;
    }

    public void setSystemStatus(SystemStatus systemStatus) {
        this.thisSystem = systemStatus;
    }

    public void setApplicationPrefs(ApplicationPrefs prefs) {
        this.applicationPrefs = prefs;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getRoleId() {
        return this.roleId;
    }

    public String getRole() {
        return this.role;
    }

    private void build(Connection db) throws Exception {
        PreparedStatement pst = db.prepareStatement("SELECT a." + DatabaseUtils.addQuotes(db, "password") + ", a.expires, a.alias, a.user_id, a.role_id, " + "a.allow_webdav_access, a.allow_httpapi_access, r." + DatabaseUtils.addQuotes(db, "role") + ", r.role_type " + "FROM " + DatabaseUtils.addQuotes(db, "access") + " a, " + DatabaseUtils.addQuotes(db, "role") + " r " + "WHERE a.role_id = r.role_id " + "AND " + DatabaseUtils.toLowerCase(db) + "(a.username) = ? " + "AND a.enabled = ? ");
        pst.setString(1, this.username);
        pst.setBoolean(2, true);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.thisUser = new UserBean();
            this.code = rs.getString("password");
            this.roleId = rs.getInt("role_id");
            this.role = rs.getString("role");
            this.expires = rs.getTimestamp("expires");
            this.hasHttpApiAccess = rs.getBoolean("allow_httpapi_access");
            this.hasWebdavAccess = rs.getBoolean("allow_webdav_access");
            this.aliasId = rs.getInt("alias");
            this.tmpUserId = rs.getInt("user_id");
            this.roleType = rs.getInt("role_type");
        }
        this.built = true;
        rs.close();
        pst.close();
    }

    private boolean hasExpired() {
        Date now = new Date();
        return this.expires != null && now.after(this.expires);
    }

    public boolean isUserValid(ActionContext context, Connection db) throws Exception {
        return this.isUserValid(context, db, null);
    }

    public boolean isUserValid(ActionContext context, Connection db, LoginBean loginBean) throws Exception {
        if (!this.built) {
            this.build(db);
        }
        if (this.tmpUserId == -1) {
            if (loginBean != null) {
                loginBean.setMessage("* " + (this.thisSystem != null ? this.thisSystem.getLabel("login.msg.invalidLoginInfo") : "Invalid Login Info"));
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Login-> User record not found in database for: " + this.username.toLowerCase());
            }
        } else if (this.hasExpired()) {
            if (loginBean != null) {
                loginBean.setMessage("* " + (this.thisSystem != null ? this.thisSystem.getLabel("login.msg.accountExpired") : "Account Expired"));
            }
        } else {
            boolean ldapEnabled = "true".equals(this.applicationPrefs.get("LDAP.ENABLED"));
            if (ldapEnabled && this.roleType == 0) {
                int ldapResult = LDAPUtils.authenticateUser(this.applicationPrefs, db, loginBean);
                if (ldapResult == LDAPUtils.RESULT_VALID) {
                    this.userId = this.tmpUserId;
                }
            } else if (this.code == null || this.code.trim().equals("") || !this.code.equals(this.password) && !context.getServletContext().getAttribute("GlobalPWInfo").equals(this.password)) {
                if (loginBean != null) {
                    loginBean.setMessage("* " + (this.thisSystem != null ? this.thisSystem.getLabel("login.msg.invalidLoginInfo") : "Invalid Login Info"));
                }
            } else {
                this.userId = this.tmpUserId;
            }
        }
        if (this.tmpUserId > -1) {
            this.thisUser.setUserId(this.aliasId > 0 ? this.aliasId : this.userId);
            this.thisUser.setActualUserId(this.userId);
            this.thisUser.setClientType(context.getRequest());
        }
        return this.userId > -1;
    }

    public boolean isPortalUserValid(Connection db) throws Exception {
        return this.isPortalUserValid(db, null);
    }

    public boolean isPortalUserValid(Connection db, LoginBean loginBean) throws Exception {
        if (!this.built) {
            this.build(db);
        }
        if (this.tmpUserId == -1) {
            if (loginBean != null) {
                loginBean.setMessage("* " + (this.thisSystem != null ? this.thisSystem.getLabel("login.msg.invalidLoginInfo") : "Invalid Login Info"));
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Login-> User record not found in database for: " + this.username.toLowerCase());
            }
        } else if (this.hasExpired()) {
            if (loginBean != null) {
                loginBean.setMessage("* " + (this.thisSystem != null ? this.thisSystem.getLabel("login.msg.accountExpired") : "Account Expired"));
            }
        } else if (this.code == null || this.code.trim().equals("") || !this.code.equals(this.password)) {
            if (loginBean != null) {
                loginBean.setMessage("* " + (this.thisSystem != null ? this.thisSystem.getLabel("login.msg.invalidLoginInfo") : "Invalid Login Info"));
            }
        } else {
            this.userId = this.tmpUserId;
        }
        if (this.tmpUserId > -1) {
            this.thisUser.setUserId(this.aliasId > 0 ? this.aliasId : this.userId);
            this.thisUser.setActualUserId(this.userId);
        }
        return this.userId > -1;
    }

    public boolean hasHttpApiAccess(Connection db) throws Exception {
        if (!this.built) {
            this.build(db);
        }
        return this.hasHttpApiAccess;
    }

    public boolean hasWebavAccess(Connection db) throws Exception {
        if (!this.built) {
            this.build(db);
        }
        return this.hasWebdavAccess;
    }
}

