/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class NCFTPApp {
    private String appExecutable = "ncftp";
    private int result = 0;
    private ArrayList files = new ArrayList();
    private String stdOut = null;
    private String stdErr = null;
    private boolean deleteSourceFilesAfterSend = false;
    private boolean makeRemoteDir = false;

    public void setAppExecutable(String tmp) {
        this.appExecutable = tmp;
    }

    public void setResult(int tmp) {
        this.result = tmp;
    }

    public void setFiles(ArrayList tmp) {
        this.files = tmp;
    }

    public void setStdOut(String tmp) {
        this.stdOut = tmp;
    }

    public void setStdErr(String tmp) {
        this.stdErr = tmp;
    }

    public void setDeleteSourceFilesAfterSend(boolean tmp) {
        this.deleteSourceFilesAfterSend = tmp;
    }

    public void setMakeRemoteDir(boolean tmp) {
        this.makeRemoteDir = tmp;
    }

    public String getAppExecutable() {
        return this.appExecutable;
    }

    public int getResult() {
        return this.result;
    }

    public ArrayList getFiles() {
        return this.files;
    }

    public String getStdOut() {
        return this.stdOut;
    }

    public String getStdErr() {
        return this.stdErr;
    }

    public boolean getDeleteSourceFilesAfterSend() {
        return this.deleteSourceFilesAfterSend;
    }

    public void addFile(String tmp) {
        this.files.add(tmp);
    }

    public int put(String ftpUrl) {
        this.stdOut = null;
        this.stdErr = null;
        StringBuffer out = new StringBuffer();
        StringBuffer err = new StringBuffer();
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.appExecutable + "put");
            if (NCFTPApp.getFtpUser(ftpUrl) != null) {
                command.add("-u");
                command.add(NCFTPApp.getFtpUser(ftpUrl));
            }
            if (NCFTPApp.getFtpPassword(ftpUrl) != null) {
                command.add("-p");
                command.add(NCFTPApp.getFtpPassword(ftpUrl));
            }
            command.add("-Z");
            command.add("-S");
            command.add(".tmp");
            if (this.makeRemoteDir) {
                command.add("-m");
            }
            if (this.deleteSourceFilesAfterSend) {
                command.add("-DD");
            }
            command.add(NCFTPApp.getFtpHost(ftpUrl));
            command.add(NCFTPApp.getFtpRemoteDir(ftpUrl));
            for (String file : this.files) {
                command.add(file);
            }
            String[] commands = command.toArray(new String[0]);
            Process process = Runtime.getRuntime().exec(commands);
            BufferedReader brErr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String tmp = null;
            while ((tmp = brErr.readLine()) != null) {
                err.append(tmp);
            }
            this.stdErr = err.toString();
            process.waitFor();
            this.result = process.exitValue();
        }
        catch (Exception e) {
            this.result = -1;
            e.printStackTrace(System.out);
        }
        return this.result;
    }

    private static String getFtpUser(String ftpUrl) {
        String tmp = ftpUrl.substring(ftpUrl.indexOf("ftp://") + 6, ftpUrl.indexOf("@"));
        if (tmp.indexOf(":") > -1) {
            return tmp.substring(0, tmp.indexOf(":"));
        }
        return tmp;
    }

    private static String getFtpPassword(String ftpUrl) {
        String tmp = ftpUrl.substring(ftpUrl.indexOf("ftp://") + 6, ftpUrl.indexOf("@"));
        if (tmp.indexOf(":") > -1) {
            return tmp.substring(tmp.indexOf(":") + 1);
        }
        return null;
    }

    private static String getFtpHost(String ftpUrl) {
        String tmp = ftpUrl.substring(ftpUrl.indexOf("@") + 1);
        if (tmp.indexOf(":") > -1) {
            return tmp.substring(0, tmp.indexOf(":"));
        }
        return tmp;
    }

    private static String getFtpRemoteDir(String ftpUrl) {
        String tmp = ftpUrl.substring(ftpUrl.lastIndexOf(":") + 1);
        if (tmp.indexOf("@") > -1) {
            return "./";
        }
        return tmp;
    }
}

